/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.JMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSRegistrar;
import com.ibm.ejs.jms.JMSRegistrationFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQRRSConnectionFactory;
import com.ibm.mq.jms.MQRRSQueueConnectionFactory;
import com.ibm.mq.jms.MQRRSTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.GenericCredential;
import javax.security.auth.Subject;

public class WSJMSManagedConnectionFactory
extends JMSManagedConnectionFactory {
    private static final TraceComponent tc = Tr.register(WSJMSManagedConnectionFactory.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private Integer objectType;
    private Properties properties;
    private String sslRepertoire;
    private static final long serialVersionUID = 9221193036057649758L;
    private Boolean isRRSTransactional = null;
    private static boolean zOS = System.getProperty("os.name").equals("OS/390") || System.getProperty("os.name").equals("z/OS");
    private static ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objectType", Integer.class), new ObjectStreamField("properties", Properties.class), new ObjectStreamField("isRRSTransactional", Boolean.class), new ObjectStreamField("optionC_authDataAlias", String.class)};
    private String optionC_authDataAlias = null;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("objectType", this.objectType);
        putField.put("properties", this.properties);
        putField.put("isRRSTransactional", this.isRRSTransactional);
        putField.put("optionC_authDataAlias", this.optionC_authDataAlias);
        objectOutputStream.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        if ((getField = objectInputStream.readFields()).defaulted("objectType")) {
            throw new IOException("Serialized WSJMSManagedConnectionFactory does not contain a value for objectType");
        }
        this.objectType = (Integer)getField.get("objectType", null);
        this.properties = (Properties)getField.get("properties", null);
        this.isRRSTransactional = (Boolean)getField.get("isRRSTransactional", new Boolean(false));
        this.optionC_authDataAlias = (String)getField.get("optionC_authDataAlias", null);
        if (tc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{this.objectType, this.properties, this.isRRSTransactional, this.optionC_authDataAlias};
            Tr.exit(tc, "readObject", objectArray);
        }
    }

    public String[] introspectSelf() {
        String string = System.getProperty("line.separator") + "\t";
        String[] stringArray = super.introspectSelf();
        String[] stringArray2 = new String[stringArray.length + 2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string + "objectType = " + this.objectType;
        stringArray2[stringArray.length + 1] = string + "properties = " + this.properties;
        return stringArray2;
    }

    public void setDataSourceProperties(Properties properties) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DataSourceProperties set", properties);
        }
        this.optionC_authDataAlias = (String)properties.remove("OptionC_authDataAlias");
        this.properties = properties;
    }

    public Properties getDataSourceProperties() {
        Properties properties = null;
        if (this.sslRepertoire != null && !"".equals(this.sslRepertoire)) {
            properties = (Properties)this.properties.clone();
            properties.setProperty("ssl.repertoire", this.sslRepertoire);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DataSourceProperties get", this.properties);
        }
        if (properties != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DataSourceProperties is cloned ", properties);
            }
            return properties;
        }
        return this.properties;
    }

    public void setObjectType(Integer n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ObjectType set", n);
        }
        this.objectType = n;
    }

    public final Integer getObjectType() {
        return this.objectType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WSJMSManagedConnectionFactory wSJMSManagedConnectionFactory = (WSJMSManagedConnectionFactory)object;
        if (!JMSCMUtils.objectsEqual(this.objectType, wSJMSManagedConnectionFactory.objectType)) {
            return false;
        }
        return JMSCMUtils.objectsEqual(this.properties, wSJMSManagedConnectionFactory.properties);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.objectType);
        n = JMSCMUtils.HASH_CODE_PRIME * n + JMSCMUtils.objectHashCode(this.properties);
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator") + "\t";
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(string + "object type = " + this.objectType);
        stringBuffer.append(string + "properties = " + this.properties);
        return stringBuffer.toString();
    }

    protected synchronized ConnectionFactory getConnectionFactory() throws ResourceException {
        return this.getConnectionFactory(false);
    }

    protected synchronized ConnectionFactory getConnectionFactory(boolean bl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionFactory: ", new Boolean(bl));
        }
        try {
            if (this.connectionFactory == null) {
                if (this.objectType == null || this.properties == null) {
                    ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Object type and data source properties must be set");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Object type and data source properties must be set", resourceAdapterInternalException);
                    }
                    throw resourceAdapterInternalException;
                }
                if (this.isRRSTransactional()) {
                    try {
                        this.getRRSConnectionFactoryAnd1PCOnlyCF();
                    }
                    catch (JMSException jMSException) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Error raised constructing MQRRS Connection Factory");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Error raised constructing MQRRS Connection Factory", (Object)jMSException);
                        }
                        throw resourceAdapterInternalException;
                    }
                } else {
                    AdminObject adminObject = new AdminObject(this.objectType.intValue(), (Hashtable)this.properties, true);
                    if (adminObject.errorRaised()) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("Error raised constructing AdminObject", (adminObject.getErrorString1() == null ? "" : adminObject.getErrorString1()) + " " + (adminObject.getErrorString2() == null ? "" : adminObject.getErrorString2()));
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Error raised constructing AdminObject", new Object[]{new Integer(adminObject.getErrorType()), adminObject.getErrorString1(), adminObject.getErrorString2()});
                        }
                        throw resourceAdapterInternalException;
                    }
                    Object object = adminObject.getObject();
                    if (!(object instanceof ConnectionFactory)) {
                        ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException("AdminObject did not return ConnectionFactory");
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "AdminObject did not return ConnectionFactory", resourceAdapterInternalException);
                        }
                        throw resourceAdapterInternalException;
                    }
                    this.connectionFactory = (ConnectionFactory)object;
                }
            }
            this.configureSSLForSSLRepertoire();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.getConnectionFactory", "227", this);
            throw resourceException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.getConnectionFactory", "232", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception when creating ConnectionFactory", exception);
            }
            throw JMSCMUtils.mapToResourceException(exception, tc, "Unexpected exception when creating ConnectionFactory");
        }
        if (this.isRRSTransactional() && bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionFactory", this.connectionFactory1pc);
            }
            return this.connectionFactory1pc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionFactory", this.connectionFactory);
        }
        return this.connectionFactory;
    }

    protected synchronized ConnectionFactory get1PCConnectionFactory() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get1PCConnectionFactory");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get1PCConnectionFactory");
        }
        return this.connectionFactory1pc;
    }

    protected void setupForRecovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupForRecovery");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupForRecovery");
        }
    }

    protected boolean zosSubjectHasValidUtokenCredential(Subject subject) throws SecurityException {
        boolean bl = false;
        if (zOS && this.isRRSTransactional() && subject != null) {
            Set set = subject.getPrivateCredentials(GenericCredential.class);
            final Iterator iterator = set.iterator();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return iterator.next();
                }
            };
            GenericCredential genericCredential = null;
            while (iterator.hasNext()) {
                if (System.getSecurityManager() != null) {
                    try {
                        genericCredential = (GenericCredential)AccessController.doPrivileged(privilegedExceptionAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new SecurityException("PriviligedAction Exception thrown when iterating through Subject's private credentials.");
                    }
                    if (!genericCredential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                    bl = true;
                    break;
                }
                genericCredential = (GenericCredential)iterator.next();
                if (!genericCredential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
                bl = true;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subjectHasUtokenCredential: " + bl);
        }
        return bl;
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
    }

    void getRRSConnectionFactoryAnd1PCOnlyCF() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRRSConnectionFactory");
        }
        if ((n = this.objectType.intValue()) == 4 || n == 0) {
            this.connectionFactory = new MQRRSQueueConnectionFactory();
            this.connectionFactory1pc = new MQQueueConnectionFactory();
        } else if (n == 5 || n == 2) {
            this.connectionFactory = new MQRRSTopicConnectionFactory();
            this.connectionFactory1pc = new MQTopicConnectionFactory();
        } else if (n == 9 || n == 8) {
            this.connectionFactory = new MQRRSConnectionFactory();
            this.connectionFactory1pc = new MQConnectionFactory();
        }
        this.setRRSConnectionFactoryProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRRSConnectionFactory");
        }
    }

    void setRRSConnectionFactoryProperties() throws JMSException {
        block26: {
            JMSRegistrar jMSRegistrar;
            MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)this.connectionFactory;
            MQConnectionFactory mQConnectionFactory2 = (MQConnectionFactory)this.connectionFactory1pc;
            Integer n = (Integer)this.properties.get("CCS");
            if (n != null) {
                mQConnectionFactory.setCCSID(n.intValue());
                mQConnectionFactory2.setCCSID(n.intValue());
            }
            mQConnectionFactory.setClientId((String)this.properties.get("CID"));
            mQConnectionFactory2.setClientId((String)this.properties.get("CID"));
            mQConnectionFactory.setDescription((String)this.properties.get("DESC"));
            mQConnectionFactory2.setDescription((String)this.properties.get("DESC"));
            String string = (String)this.properties.get("QMGR");
            if (string != null) {
                mQConnectionFactory.setQueueManager(string);
                mQConnectionFactory2.setQueueManager(string);
            }
            if ((jMSRegistrar = JMSRegistrationFactory.getJMSRegistration()) != null) {
                Object object;
                if (jMSRegistrar.checkCompatibleVersion("6.0.1.1") && (object = this.properties.get("MAPNAMESTYLE")) == null) {
                    mQConnectionFactory.setMapNameStyle(false);
                    mQConnectionFactory2.setMapNameStyle(false);
                }
                if (jMSRegistrar.checkCompatibleVersion("7.0.0.0")) {
                    Method method2;
                    Object object2;
                    Object object3;
                    block25: {
                        block24: {
                            object = null;
                            object3 = null;
                            try {
                                object = this.properties.getProperty("PVER");
                                if (object != null || (object = this.properties.getProperty("PROVIDERVERSION")) != null || (object = this.properties.getProperty("XMSC_WMQ_PROVIDER_VERSION")) != null) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Provider version: " + (String)object);
                                    }
                                    object2 = MQConnectionFactory.class.getMethod("setProviderVersion", String.class);
                                    ((Method)object2).invoke((Object)mQConnectionFactory, object);
                                    ((Method)object2).invoke((Object)mQConnectionFactory2, object);
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.setRRSConnectionFactoryProperties", "1:783:1.23.2.4", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                                Tr.debug(tc, "Caught exception: ", object);
                            }
                        }
                        try {
                            object3 = this.properties.get("AEX");
                            if (object3 != null || (object3 = this.properties.get("ASYNCEXCEPTION")) != null || (object3 = this.properties.get("XMSC_ASYNC_EXCEPTIONS")) != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Async exceptions: " + object3);
                                }
                                object2 = new Integer(-1);
                                if (object3 instanceof Integer) {
                                    object2 = (Integer)object3;
                                } else if (object3 instanceof String) {
                                    object2 = Integer.valueOf((String)object3);
                                }
                                method2 = MQConnectionFactory.class.getMethod("setAsyncExceptions", Integer.TYPE);
                                method2.invoke((Object)mQConnectionFactory, object2);
                                method2.invoke((Object)mQConnectionFactory2, object2);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.setRRSConnectionFactoryProperties", "1:817:1.23.2.4", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                            Tr.debug(tc, "Caught exception: ", object);
                        }
                    }
                    try {
                        object3 = this.properties.get("SCC");
                        if (object3 != null || (object3 = this.properties.get("SENDCHECKCOUNT")) != null || (object3 = this.properties.get("XMSC_WMQ_SEND_CHECK_COUNT")) != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Send check count: " + object3);
                            }
                            object2 = new Integer(-1);
                            if (object3 instanceof Integer) {
                                object2 = (Integer)object3;
                            } else if (object3 instanceof String) {
                                object2 = Integer.valueOf((String)object3);
                            }
                            if ((Integer)object2 >= 0) {
                                method2 = MQConnectionFactory.class.getMethod("setSendCheckCount", Integer.TYPE);
                                method2.invoke((Object)mQConnectionFactory, object2);
                                method2.invoke((Object)mQConnectionFactory2, object2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.setRRSConnectionFactoryProperties", "1:854:1.23.2.4", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block26;
                        Tr.debug(tc, "Caught exception: ", object);
                    }
                }
            }
        }
        this.setRRSConnectionFactoryProperties_NonCommon();
    }

    void setRRSConnectionFactoryProperties_NonCommon() throws JMSException {
        this.setV7PubSubProperties();
    }

    protected void setV7PubSubProperties() {
        block24: {
            JMSRegistrar jMSRegistrar;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setV7PubSubProperties");
            }
            if ((jMSRegistrar = JMSRegistrationFactory.getJMSRegistration()) != null && jMSRegistrar.checkCompatibleVersion("7.0.0.0")) {
                Object object;
                MQConnectionFactory mQConnectionFactory;
                MQConnectionFactory mQConnectionFactory2;
                String string;
                block23: {
                    string = null;
                    mQConnectionFactory2 = (MQConnectionFactory)this.connectionFactory;
                    mQConnectionFactory = (MQConnectionFactory)this.connectionFactory1pc;
                    try {
                        string = this.properties.getProperty("TTP");
                        if (string != null || (string = this.properties.getProperty("TEMPTOPICPREFIX")) != null || (string = this.properties.getProperty("XMSC_WMQ_TEMP_TOPIC_PREFIX")) != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Temp topic prefix: " + string);
                            }
                            object = MQConnectionFactory.class.getMethod("setTempTopicPrefix", String.class);
                            ((Method)object).invoke((Object)mQConnectionFactory2, string);
                            ((Method)object).invoke((Object)mQConnectionFactory, string);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.setV7PubSubProperties", "1:919:1.23.2.4", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                        Tr.debug(tc, "Caught exception: ", string);
                    }
                }
                try {
                    string = this.properties.getProperty("WCFMT");
                    if (string != null || (string = this.properties.getProperty("WILDCARDFORMAT")) != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "value: " + string);
                        }
                        int n = -1;
                        if (string.equals("CHAR_ONLY")) {
                            n = 1;
                        } else if (string.equals("TOPIC_ONLY")) {
                            n = 0;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Wildcard format: " + n);
                        }
                        if (n != -1) {
                            Integer n2 = new Integer(n);
                            Method method2 = MQConnectionFactory.class.getMethod("setWildcardFormat", Integer.TYPE);
                            method2.invoke((Object)mQConnectionFactory2, n2);
                            method2.invoke((Object)mQConnectionFactory, n2);
                        }
                    } else if (this.properties.containsKey("wildcardFormat")) {
                        object = new Integer(-1);
                        Object object2 = this.properties.get("wildcardFormat");
                        if (object2 instanceof Integer) {
                            object = (Integer)object2;
                        } else if (object2 instanceof String) {
                            object = Integer.valueOf((String)object2);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Wildcard format: " + object);
                        }
                        if ((Integer)object != -1) {
                            Method method3 = MQConnectionFactory.class.getMethod("setWildcardFormat", Integer.TYPE);
                            method3.invoke((Object)mQConnectionFactory2, object);
                            method3.invoke((Object)mQConnectionFactory, object);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.WSJMSManagedConnectionFactory.setV7PubSubProperties", "1:982:1.23.2.4", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Caught exception: ", string);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setV7PubSubProperties");
        }
    }

    public Boolean getRRSTransactional() {
        return Boolean.FALSE;
    }

    public Boolean getRRSEnabledSessions() {
        return this.isRRSTransactional() ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getThreadIdentitySupport() {
        return this.isRRSTransactional() ? "ALLOWED" : "NOTALLOWED";
    }

    public Boolean getThreadSecurity() {
        return this.isRRSTransactional() ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean isRRSTransactional() {
        if (this.isRRSTransactional == null) {
            Integer n = (Integer)this.properties.get("TRAN");
            if (zOS && n == 0) {
                this.isRRSTransactional = Boolean.TRUE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JMSManagedConnectionFactory will be created as RRS-enabled");
                }
            } else {
                this.isRRSTransactional = Boolean.FALSE;
            }
        }
        return this.isRRSTransactional;
    }

    public String getOptionC_authDataAlias() {
        return this.optionC_authDataAlias;
    }

    public void setSSLRepertoire(String string) {
        this.sslRepertoire = string;
        this.configureSSLForSSLRepertoire();
    }

    private void configureSSLForSSLRepertoire() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "configureSSLForSSLRepertoire", this.sslRepertoire);
        }
        if (this.sslRepertoire != null && !"".equals(this.sslRepertoire)) {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(WSJMSManagedConnectionFactory.this.sslRepertoire);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Created socket factory for CF: " + sSLSocketFactory);
                    }
                    return sSLSocketFactory;
                }
            });
            if (this.connectionFactory != null) {
                ((MQConnectionFactory)this.connectionFactory).setSSLSocketFactory((Object)sSLSocketFactory);
            }
            if (this.connectionFactory1pc != null) {
                ((MQConnectionFactory)this.connectionFactory1pc).setSSLSocketFactory((Object)sSLSocketFactory);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "configureSSLForSSLRepertoire");
        }
    }
}

