/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms;

import com.ibm.ejs.jms.mq.JMSWrapXAQueueConnectionFactory;
import com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;

public class WrapObjectFactory
implements ObjectFactory {
    public static final String ADDR_TYPE_WRAP = "WRAP";
    private static TraceComponent tc = Tr.register(WrapObjectFactory.class.getName(), "Messaging");

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        Tr.entry(tc, "getObjectInstance");
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.getClassName().equals(JMSWrapXAQueueConnectionFactory.class.getName())) {
                Tr.debug(tc, "It's a JMSWrapXAQueueConnectionFactory");
                RefAddr refAddr = reference.get(ADDR_TYPE_WRAP);
                if (refAddr != null) {
                    byte[] byArray = (byte[])refAddr.getContent();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Reference reference2 = (Reference)objectInputStream.readObject();
                    QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)NamingManager.getObjectInstance(reference2, null, null, null);
                    JMSWrapXAQueueConnectionFactory jMSWrapXAQueueConnectionFactory = new JMSWrapXAQueueConnectionFactory(queueConnectionFactory);
                    Tr.exit(tc, "getObjectInstance");
                    return jMSWrapXAQueueConnectionFactory;
                }
            } else if (reference.getClassName().equals(JMSWrapXATopicConnectionFactory.class.getName())) {
                Tr.debug(tc, "It's an JMSWrapXATopicConnectionFactory");
                RefAddr refAddr = reference.get(ADDR_TYPE_WRAP);
                if (refAddr != null) {
                    byte[] byArray = (byte[])refAddr.getContent();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Reference reference3 = (Reference)objectInputStream.readObject();
                    TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)NamingManager.getObjectInstance(reference3, null, null, null);
                    JMSWrapXATopicConnectionFactory jMSWrapXATopicConnectionFactory = new JMSWrapXATopicConnectionFactory(topicConnectionFactory);
                    Tr.exit(tc, "getObjectInstance");
                    return jMSWrapXATopicConnectionFactory;
                }
            } else {
                Tr.debug(tc, "Wrapped object type not recognised");
            }
        } else {
            Tr.debug(tc, "Wrapped object not a Reference");
        }
        Tr.exit(tc, "getObjectInstance");
        return null;
    }
}

