/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageLog;
import com.ibm.ejs.jms.listener.AsyncMessageRequest;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;

public class AsyncMessageConsumer
implements Runnable {
    protected static TraceComponent tc = Tr.register(AsyncMessageConsumer.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private boolean started = false;
    private final Object lock = new Object();
    private AsyncMessageLog asyncMessageLog = null;
    private MDBConfigData mdbConfig = null;
    private ServerSessionPool serverSessionPool = null;

    public AsyncMessageConsumer(AsyncMessageLog asyncMessageLog, MDBConfigData mDBConfigData, ServerSessionPool serverSessionPool) {
        Tr.entry(tc, "AsyncMessageConsumer");
        this.asyncMessageLog = asyncMessageLog;
        this.mdbConfig = mDBConfigData;
        this.serverSessionPool = serverSessionPool;
        Tr.exit(tc, "AsyncMessageConsumer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Tr.entry(tc, "start");
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            this.started = true;
            thread.start();
        }
        Tr.exit(tc, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Tr.entry(tc, "stop");
        Object object = this.lock;
        synchronized (object) {
            this.started = false;
            this.lock.notify();
        }
        Tr.exit(tc, "stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Tr.entry(tc, "run");
        boolean bl = false;
        while (!bl) {
            Object object;
            Iterator iterator = this.asyncMessageLog.getIterator(this.mdbConfig.msgListenerPort.getName());
            while (iterator != null && iterator.hasNext()) {
                Object object2;
                Object object3;
                object = null;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                int n = 0;
                while (iterator.hasNext() && n < this.mdbConfig.msgListenerPort.getMaxMessages()) {
                    object3 = (AsyncMessageRequest)iterator.next();
                    if (!((AsyncMessageRequest)object3).isCommitted()) continue;
                    Tr.event(tc, "Processing async message request", object3);
                    object2 = ((AsyncMessageRequest)object3).getRequestID();
                    Iterator iterator2 = ((AsyncMessageRequest)object3).getCorrelIDs().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        object = object == null ? "JMSCorrelationID = '" + string + "'" : (String)object + " OR JMSCorrelationID = '" + string + "'";
                        hashtable.put(string, object2);
                    }
                    ++n;
                }
                if (object == null) continue;
                object3 = this.mdbConfig.inputPort.JMSMessageSelector != null && this.mdbConfig.inputPort.JMSMessageSelector.trim().length() > 0 ? this.mdbConfig.inputPort.JMSMessageSelector + " AND (" + (String)object + ")" : object;
                object2 = null;
                try {
                    object2 = (ServerSession)this.serverSessionPool.getServerSession();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "125", this);
                    Tr.event(tc, "Exception calling getServerSession", (Object)jMSException);
                    object2 = null;
                }
                if (object2 != null) {
                    try {
                        Tr.event(tc, "Starting async message consumer request with selector:", object3);
                        ((ServerSession)object2).startReceiveMsgNoWait((String)object3, hashtable);
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "140", this);
                        Tr.event(tc, "Exception starting async message consumer ServerSession", (Object)jMSException);
                    }
                    continue;
                }
                Tr.event(tc, "No ServerSessions available");
            }
            this.checkForExpiredRequests(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestTimeout());
            try {
                object = this.lock;
                synchronized (object) {
                    if (this.started) {
                        if (tc.isEntryEnabled()) {
                            Tr.event(tc, "sleeping for duration in milli-seconds: ", new Integer(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestInterval()));
                        }
                        this.lock.wait(this.mdbConfig.msgListenerPort.getAsyncMessageConsumerRequestInterval());
                    }
                    if (!this.started) {
                        bl = true;
                        Tr.event(tc, "Terminating AsyncMessageConsumer thread");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.run", "161", this);
            }
        }
        Tr.exit(tc, "run");
    }

    private void checkForExpiredRequests(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForExpiredRequests", new Integer(n));
        }
        if (n > -1) {
            try {
                long l = System.currentTimeMillis();
                Iterator iterator = this.asyncMessageLog.getIterator(this.mdbConfig.msgListenerPort.getName());
                while (iterator != null && iterator.hasNext()) {
                    AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)iterator.next();
                    if (!asyncMessageRequest.isCommitted() || l - asyncMessageRequest.getRegisterTime() <= (long)(n * 1000)) continue;
                    Tr.event(tc, "Async Message Request has expired", asyncMessageRequest);
                    this.asyncMessageLog.removeRequest(asyncMessageRequest.getRequestID());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.AsyncMessageConsumer.checkForExpiredRequests", "192", this);
                Tr.event(tc, "Exception checking for expired requests", exception);
            }
        }
        Tr.exit(tc, "checkForExpiredRequests");
    }
}

