/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class JMSExceptionListener
implements ExceptionListener {
    protected static final TraceComponent tc = Tr.register(JMSExceptionListener.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private final Hashtable mdbListeners = new Hashtable();

    public JMSExceptionListener(MDBListenerImpl mDBListenerImpl) {
        Tr.entry(tc, "JMSExceptionListener", mDBListenerImpl);
        this.mdbListeners.put(mDBListenerImpl, mDBListenerImpl);
        Tr.exit(tc, "JMSExceptionListener");
    }

    public void addMDBListener(MDBListenerImpl mDBListenerImpl) {
        Tr.entry(tc, "addMDBListener", mDBListenerImpl);
        this.mdbListeners.put(mDBListenerImpl, mDBListenerImpl);
        Tr.exit(tc, "addMDBListener");
    }

    public int removeMDBListener(MDBListenerImpl mDBListenerImpl) {
        Tr.entry(tc, "removeMDBListener", mDBListenerImpl);
        this.mdbListeners.remove(mDBListenerImpl);
        Tr.exit(tc, "removeMDBListener", new Integer(this.mdbListeners.size()));
        return this.mdbListeners.size();
    }

    public void onException(JMSException jMSException) {
        Object object;
        Tr.entry(tc, "onException", (Object)jMSException);
        String string = new String("");
        String string2 = new String("");
        Enumeration enumeration = this.mdbListeners.elements();
        while (enumeration.hasMoreElements()) {
            object = (MDBListenerImpl)enumeration.nextElement();
            string = string + ((MDBListenerImpl)object).getMDBConfig().mdbName + " ";
            string2 = string2 + ((MDBListenerImpl)object).getMDBConfig().msgListenerPort.getJmsDestJNDIName() + " ";
        }
        Tr.error(tc, "JMSConnectionException", new Object[]{string, string2, jMSException});
        Tr.error(tc, "JMSConnectionLinkedException", new Object[]{string, string2, jMSException.getLinkedException()});
        object = this.mdbListeners.elements();
        while (object.hasMoreElements()) {
            try {
                MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)object.nextElement();
                boolean bl = mDBListenerImpl.internalStop(true);
                if (bl) continue;
                mDBListenerImpl.startRecoveryAlarm();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.JMSExceptionListener.onException", "114", this);
                Tr.event(tc, "Exception trying to restart MDB Listener", exception);
            }
        }
        Tr.exit(tc, "onException");
    }
}

