/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.jms.DurableSubscription;
import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.GenericJMSManagedConnectionFactory;
import com.ibm.ejs.jms.JMSConnectionFactoryHandle;
import com.ibm.ejs.jms.WSJMSManagedConnectionFactory;
import com.ibm.ejs.jms.listener.AsyncMessageConsumer;
import com.ibm.ejs.jms.listener.AsyncMessageLog;
import com.ibm.ejs.jms.listener.JMSExceptionListener;
import com.ibm.ejs.jms.listener.MDBComponentMetaData;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBInvalidConfigException;
import com.ibm.ejs.jms.listener.MDBListener;
import com.ibm.ejs.jms.listener.MDBListenerManagerImpl;
import com.ibm.ejs.jms.listener.MDBPool;
import com.ibm.ejs.jms.listener.MDBRuntimeException;
import com.ibm.ejs.jms.listener.MDBStartRescheduledException;
import com.ibm.ejs.jms.listener.MsgListenerPort;
import com.ibm.ejs.jms.listener.NonASFConnectionConsumer;
import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.JMSQueueManagerName;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threadContext.ConnectionHandleAccessorImpl;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class MDBListenerImpl
implements MDBListener,
AlarmListener {
    protected static final TraceComponent tc = Tr.register(MDBListenerImpl.class, "Messaging", "com.ibm.ejs.jms.messaging");
    protected MDBListenerManagerImpl mdbMgr = null;
    protected DurableSubscriptionManager durableSubscriptionMgr = null;
    protected MsgListenerPort msgListenerPort = null;
    protected boolean quiescing = false;
    protected boolean quiesceComplete = false;
    protected boolean started = false;
    protected boolean requiredToBeStarted = false;
    protected Alarm recoveryAlarm = null;
    protected int recoveryCount = 0;
    protected MDBConfigData mdbConfig = null;
    protected boolean isQueue;
    protected boolean isUnifiedCF;
    protected Destination jmsDestination = null;
    protected ConnectionFactory jmsConnFactory = null;
    protected Connection jmsConn = null;
    protected ConnectionConsumer jmsConnConsumer = null;
    protected boolean nonASFListener = false;
    protected NonASFConnectionConsumer nonASFConnectionConsumer = null;
    protected boolean nonASFBMTRollbackEnabled = false;
    protected MDBPool listenerMDBPool = null;
    protected ServerSessionPool serverSessionPool = null;
    protected ThreadPool threadPool = null;
    protected AsyncMessageConsumer asyncMessageConsumer = null;
    protected AsyncMessageLog asyncMessageLog = null;
    protected boolean jmsWrapper = true;
    private boolean internalStopInProgress = false;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public MDBListenerImpl(MDBListenerManagerImpl mDBListenerManagerImpl, DurableSubscriptionManager durableSubscriptionManager, MDBPool mDBPool, ThreadPool threadPool, MDBConfigData mDBConfigData, AsyncMessageLog asyncMessageLog) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MDBListenerImpl", new Object[]{mDBListenerManagerImpl, durableSubscriptionManager, mDBPool, threadPool, mDBConfigData, asyncMessageLog});
        }
        this.mdbMgr = mDBListenerManagerImpl;
        this.durableSubscriptionMgr = durableSubscriptionManager;
        this.threadPool = threadPool;
        this.mdbConfig = mDBConfigData;
        this.listenerMDBPool = mDBPool;
        this.asyncMessageLog = asyncMessageLog;
        Tr.exit(tc, "MDBListenerImpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResources() throws Exception {
        Object object;
        Tr.entry(tc, "createResources");
        if (this.mdbConfig.pmiFactory != null) {
            this.mdbConfig.pmiBean = this.mdbConfig.pmiFactory.getPmiBean(this.mdbConfig.j2eeName, this.mdbConfig.containerName);
        }
        InitialContext initialContext = new InitialContext();
        LocalTransactionCurrent localTransactionCurrent = null;
        boolean bl = false;
        try {
            localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
            object = localTransactionCurrent.getLocalTranCoord();
            if (object == null) {
                localTransactionCurrent.begin();
                bl = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "152", this);
            Tr.event(tc, "Exception beginning local transaction:", exception);
            Tr.exit(tc, "createResources");
            throw exception;
        }
        object = ConnectionHandleAccessorImpl.getConnectionHandleAccessor().getThreadContext();
        object.beginContext(new HandleList());
        ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        componentMetaDataAccessorImpl.beginContext(new MDBComponentMetaData());
        try {
            String string;
            Object object2;
            Object object3;
            ManagedConnectionFactory managedConnectionFactory;
            try {
                this.jmsDestination = (Destination)initialContext.lookup(this.mdbConfig.msgListenerPort.getJmsDestJNDIName());
                this.jmsConnFactory = (ConnectionFactory)initialContext.lookup(this.mdbConfig.msgListenerPort.getJmsConnJNDIName());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "133", this);
                Tr.warning(tc, "JNDILookupException", MDBListenerManagerImpl.getNestedException(exception).getMessage());
                Tr.debug(tc, "Exception:", exception);
                Tr.exit(tc, "createResources");
                throw exception;
            }
            this.jmsWrapper = this.jmsConnFactory instanceof JMSConnectionFactoryHandle;
            if (!this.jmsWrapper) {
                if (this.jmsConnFactory.getClass().getName().startsWith("com.ibm.ws.sib") || this.jmsConnFactory.getClass().getName().startsWith("com.ibm.websphere.sib")) {
                    Tr.error(tc, "DefaultMessagingListenerPortNotValid", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getName()});
                    Tr.exit(tc, "createResources");
                    throw new MDBInvalidConfigException("Cannot deploy an MDB against a listener port specifying a default messaging JMS resource");
                }
                Tr.error(tc, "ResourceAdapterListenerPortNotValid", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getName()});
                Tr.exit(tc, "createResources");
                throw new MDBInvalidConfigException("Cannot deploy an MDB against a listener port specifying a JCA resource adapter JMS resource");
            }
            int n = 0;
            if (!this.jmsWrapper || this.mdbMgr.getNonASFReceiveTimeout() > 0) {
                this.nonASFListener = true;
                if (this.jmsWrapper) {
                    n = this.mdbMgr.getNonASFReceiveTimeout();
                    this.nonASFBMTRollbackEnabled = this.mdbMgr.getNonASFBMTRollbackEnabled();
                } else {
                    n = 10000;
                }
            } else {
                this.nonASFListener = false;
            }
            if (this.jmsWrapper) {
                ((JMSConnectionFactoryHandle)this.jmsConnFactory).enableRestrictedMethods();
            }
            if (this.jmsWrapper && this.recoveryCount < this.mdbMgr.getMaxRecoveryRetries() && (managedConnectionFactory = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getManagedConnectionFactory()) instanceof WSJMSManagedConnectionFactory && (object3 = (String)((Properties)(object2 = ((WSJMSManagedConnectionFactory)managedConnectionFactory).getDataSourceProperties())).get("QMGR")) != null) {
                try {
                    this.checkForInactiveSIBMQClientLink((String)object3);
                }
                catch (MDBStartRescheduledException mDBStartRescheduledException) {
                    Tr.exit(tc, "createResources");
                    throw mDBStartRescheduledException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "304", this);
                    Tr.debug(tc, "Exception calling checkSIBMQClientLinkActive", exception);
                    Tr.exit(tc, "createResources");
                    throw exception;
                }
            }
            this.isQueue = this.jmsDestination instanceof Queue && this.jmsDestination instanceof Topic ? this.mdbConfig.inputPort.JMSDestinationType == 0 : this.jmsDestination instanceof Queue;
            this.isUnifiedCF = !(this.jmsConnFactory instanceof QueueConnectionFactory) && !(this.jmsConnFactory instanceof TopicConnectionFactory);
            if (!this.isUnifiedCF && (this.isQueue && !(this.jmsConnFactory instanceof QueueConnectionFactory) || !this.isQueue && !(this.jmsConnFactory instanceof TopicConnectionFactory))) {
                Tr.exit(tc, "createResources");
                throw new MDBInvalidConfigException("MDB Listener Port JMSConnectionFactory type does not match JMSDestination type");
            }
            managedConnectionFactory = null;
            if (this.jmsWrapper && (object2 = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getAuthDataAlias()) != null) {
                object3 = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getManagedConnectionFactory();
                string = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getMappingConfigAlias();
                Object object4 = object2;
                managedConnectionFactory = (PasswordCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((ManagedConnectionFactory)object3, string, (String)object4){
                    private final /* synthetic */ ManagedConnectionFactory val$mcf;
                    private final /* synthetic */ String val$mappingConfig;
                    private final /* synthetic */ String val$fContainerAuthAlias;
                    {
                        this.val$mcf = managedConnectionFactory;
                        this.val$mappingConfig = string;
                        this.val$fContainerAuthAlias = string2;
                    }

                    public Object run() throws IOException, LoginException, Exception {
                        Subject subject = WSDefaultPrincipalMapping.getSubject(this.val$mcf, this.val$mappingConfig, this.val$fContainerAuthAlias);
                        if (subject != null) {
                            Set set = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = MDBListenerImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                PasswordCredential passwordCredential;
                                Object t = iterator.next();
                                if (!(t instanceof PasswordCredential) || !(passwordCredential = (PasswordCredential)t).getManagedConnectionFactory().equals(this.val$mcf)) continue;
                                return passwordCredential;
                            }
                        }
                        return null;
                    }
                });
                Tr.event(tc, "MDB JMS connection credentials", managedConnectionFactory);
            }
            this.jmsConn = this.isUnifiedCF ? (managedConnectionFactory == null ? this.jmsConnFactory.createConnection() : this.jmsConnFactory.createConnection(managedConnectionFactory.getUserName(), new String(managedConnectionFactory.getPassword()))) : (this.isQueue ? (managedConnectionFactory == null ? ((QueueConnectionFactory)this.jmsConnFactory).createQueueConnection() : ((QueueConnectionFactory)this.jmsConnFactory).createQueueConnection(managedConnectionFactory.getUserName(), new String(managedConnectionFactory.getPassword()))) : (managedConnectionFactory == null ? ((TopicConnectionFactory)this.jmsConnFactory).createTopicConnection() : ((TopicConnectionFactory)this.jmsConnFactory).createTopicConnection(managedConnectionFactory.getUserName(), new String(managedConnectionFactory.getPassword()))));
            if (!this.isQueue && this.jmsConnFactory instanceof JMSConnectionFactoryHandle && (object2 = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getManagedConnectionFactory()) instanceof GenericJMSManagedConnectionFactory && (string = ((Properties)(object3 = ((GenericJMSManagedConnectionFactory)object2).getDataSourceProperties())).getProperty("durable.subscriber.name")) != null) {
                this.mdbConfig.inputPort.JMSSubscriptionName = string;
                Tr.event(tc, "Set durable subscriber name property to " + string);
            }
            if (this.jmsWrapper) {
                object2 = this.mdbMgr;
                synchronized (object2) {
                    object3 = this.jmsConn.getExceptionListener();
                    if (object3 == null) {
                        this.jmsConn.setExceptionListener((ExceptionListener)new JMSExceptionListener(this));
                    } else if (object3 instanceof JMSExceptionListener) {
                        ((JMSExceptionListener)object3).addMDBListener(this);
                    }
                }
            }
            if (this.nonASFListener && !this.isQueue) {
                this.serverSessionPool = new ServerSessionPool(this, this.jmsConn, this.jmsDestination, this.listenerMDBPool, this.mdbConfig, 1, this.mdbConfig.msgListenerPort.getMaxRetries(), this.threadPool);
            } else {
                int n2;
                int n3 = this.mdbConfig.msgListenerPort.getMaxSessions();
                if (this.jmsWrapper && (n2 = ((JMSConnectionFactoryHandle)this.jmsConnFactory).getSessionPoolMaxConnections()) < n3 && n2 > 0) {
                    Tr.warning(tc, "SessionPoolMaxConnectionsTooSmall", new Object[]{this.mdbConfig.msgListenerPort.getName(), new Integer(n3), this.mdbConfig.msgListenerPort.getJmsConnJNDIName(), String.valueOf(n2)});
                    n3 = n2;
                }
                this.serverSessionPool = new ServerSessionPool(this, this.jmsConn, this.jmsDestination, this.listenerMDBPool, this.mdbConfig, n3, this.mdbConfig.msgListenerPort.getMaxRetries(), this.threadPool);
            }
            if (this.nonASFListener) {
                this.serverSessionPool.putServerSession((ServerSession)this.serverSessionPool.getServerSession());
            }
            if (this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                this.asyncMessageConsumer = new AsyncMessageConsumer(this.asyncMessageLog, this.mdbConfig, this.serverSessionPool);
            } else if (this.nonASFListener) {
                this.nonASFConnectionConsumer = new NonASFConnectionConsumer(this.serverSessionPool, n);
            } else {
                this.jmsConnConsumer = this.isUnifiedCF ? (this.isQueue || this.mdbConfig.inputPort.JMSSubscriptionDurability == 0 ? this.jmsConn.createConnectionConsumer(this.jmsDestination, this.mdbConfig.inputPort.JMSMessageSelector, (javax.jms.ServerSessionPool)this.serverSessionPool, this.mdbConfig.msgListenerPort.getMaxMessages()) : this.jmsConn.createDurableConnectionConsumer((Topic)this.jmsDestination, this.mdbConfig.inputPort.JMSSubscriptionName, this.mdbConfig.inputPort.JMSMessageSelector, (javax.jms.ServerSessionPool)this.serverSessionPool, this.mdbConfig.msgListenerPort.getMaxMessages())) : (this.isQueue ? ((QueueConnection)this.jmsConn).createConnectionConsumer((Queue)this.jmsDestination, this.mdbConfig.inputPort.JMSMessageSelector, (javax.jms.ServerSessionPool)this.serverSessionPool, this.mdbConfig.msgListenerPort.getMaxMessages()) : (this.mdbConfig.inputPort.JMSSubscriptionDurability == 0 ? ((TopicConnection)this.jmsConn).createConnectionConsumer((Topic)this.jmsDestination, this.mdbConfig.inputPort.JMSMessageSelector, (javax.jms.ServerSessionPool)this.serverSessionPool, this.mdbConfig.msgListenerPort.getMaxMessages()) : ((TopicConnection)this.jmsConn).createDurableConnectionConsumer((Topic)this.jmsDestination, this.mdbConfig.inputPort.JMSSubscriptionName, this.mdbConfig.inputPort.JMSMessageSelector, (javax.jms.ServerSessionPool)this.serverSessionPool, this.mdbConfig.msgListenerPort.getMaxMessages())));
            }
        }
        finally {
            try {
                LocalTransactionCoordinator localTransactionCoordinator;
                if (bl && (localTransactionCoordinator = localTransactionCurrent.getLocalTranCoord()) != null) {
                    localTransactionCoordinator.complete(0);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "277", this);
                Tr.event(tc, "Exception completing local transaction:", exception);
            }
            if (componentMetaDataAccessorImpl != null) {
                componentMetaDataAccessorImpl.endContext();
            }
            if (object != null) {
                object.endContext();
            }
        }
        Tr.exit(tc, "createResources");
    }

    public void close() {
        Tr.entry(tc, "close");
        if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
            this.mdbConfig.pmiBean = null;
        }
        this.stop();
        Tr.exit(tc, "close");
    }

    public synchronized void start() throws MDBRuntimeException, IllegalStateException {
        Tr.entry(tc, "start");
        this.requiredToBeStarted = true;
        if (this.recoveryAlarm != null) {
            this.recoveryAlarm.cancel();
            this.recoveryAlarm = null;
        }
        this.recoveryCount = 0;
        this.internalStart();
        Tr.exit(tc, "start");
    }

    public synchronized void stop() {
        Tr.entry(tc, "stop");
        this.requiredToBeStarted = false;
        if (this.recoveryAlarm != null) {
            this.recoveryAlarm.cancel();
            this.recoveryAlarm = null;
        }
        this.recoveryCount = 0;
        this.internalStop(false);
        Tr.exit(tc, "stop");
    }

    protected synchronized void restart() throws MDBRuntimeException, IllegalStateException {
        Tr.entry(tc, "restart");
        if (!this.started && this.requiredToBeStarted) {
            this.internalStart();
        }
        Tr.exit(tc, "restart");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void internalStart() throws MDBRuntimeException, IllegalStateException {
        block21: {
            Tr.entry(tc, "internalStart");
            if (this.started) {
                Tr.exit(tc, "internalStart");
                throw new IllegalStateException("Already started");
            }
            boolean bl = false;
            try {
                try {
                    ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(this.mdbConfig.ejbConfigData.getEJBComponentMetaData());
                    this.createResources();
                    if (!this.quiescing) {
                        if (this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                            this.asyncMessageConsumer.start();
                        } else if (this.nonASFListener) {
                            this.nonASFConnectionConsumer.start();
                        }
                        this.jmsConn.start();
                    }
                    this.started = true;
                }
                catch (MDBStartRescheduledException mDBStartRescheduledException) {
                    Object var5_3 = null;
                    ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
                    if (!this.started) {
                        this.internalStop(false);
                        if (!bl) {
                            this.startRecoveryAlarm();
                        }
                        break block21;
                    }
                    if (!this.isQueue && this.mdbConfig.inputPort.JMSSubscriptionDurability == 1) {
                        Vector<DurableSubscription> vector = new Vector<DurableSubscription>();
                        DurableSubscription durableSubscription = new DurableSubscription(this.mdbConfig.inputPort.JMSSubscriptionName, this.jmsConn);
                        vector.add(durableSubscription);
                        this.durableSubscriptionMgr.setCurrentSubscriptionsForModule(this.mdbConfig.applicationName, 0, vector);
                    }
                    Tr.info(tc, "MDBListenerStarted", new Object[]{this.mdbConfig.msgListenerPort.getName(), this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
                    this.recoveryCount = 0;
                    break block21;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof MDBInvalidConfigException) {
                        bl = true;
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.internalStart", "281", this);
                    Tr.warning(tc, "MDBListenerStartException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    if (tc.isEventEnabled() && exception instanceof JMSException && (exception2 = ((JMSException)((Object)exception)).getLinkedException()) != null) {
                        Tr.event(tc, "Linked exception", exception2);
                    }
                    Tr.exit(tc, "internalStart");
                    throw new MDBRuntimeException(MDBListenerManagerImpl.getNestedException(exception).getMessage(), exception);
                }
                Object var5_2 = null;
                ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
                if (!this.started) {
                    this.internalStop(false);
                    if (bl) throw throwable;
                    this.startRecoveryAlarm();
                    throw throwable;
                }
                if (!this.isQueue && this.mdbConfig.inputPort.JMSSubscriptionDurability == 1) {
                    Vector<DurableSubscription> vector = new Vector<DurableSubscription>();
                    DurableSubscription durableSubscription = new DurableSubscription(this.mdbConfig.inputPort.JMSSubscriptionName, this.jmsConn);
                    vector.add(durableSubscription);
                    this.durableSubscriptionMgr.setCurrentSubscriptionsForModule(this.mdbConfig.applicationName, 0, vector);
                }
                Tr.info(tc, "MDBListenerStarted", new Object[]{this.mdbConfig.msgListenerPort.getName(), this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
                this.recoveryCount = 0;
                throw throwable;
            }
            if (!this.started) {
                this.internalStop(false);
                if (!bl) {
                    this.startRecoveryAlarm();
                }
            } else {
                if (!this.isQueue && this.mdbConfig.inputPort.JMSSubscriptionDurability == 1) {
                    Vector<DurableSubscription> vector = new Vector<DurableSubscription>();
                    DurableSubscription durableSubscription = new DurableSubscription(this.mdbConfig.inputPort.JMSSubscriptionName, this.jmsConn);
                    vector.add(durableSubscription);
                    this.durableSubscriptionMgr.setCurrentSubscriptionsForModule(this.mdbConfig.applicationName, 0, vector);
                }
                Tr.info(tc, "MDBListenerStarted", new Object[]{this.mdbConfig.msgListenerPort.getName(), this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
                this.recoveryCount = 0;
            }
        }
        Tr.exit(tc, "internalStart");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalStop(boolean bl) {
        boolean bl2;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "internalStop", bl);
            }
            boolean bl3 = bl2 = !this.internalStopInProgressCompareAndSet(false, true);
            if (bl && bl2) break block30;
            MDBListenerImpl mDBListenerImpl = this;
            synchronized (mDBListenerImpl) {
                boolean bl4;
                if (this.started) {
                    this.started = false;
                }
                if (bl && this.serverSessionPool != null) {
                    this.serverSessionPool.setClosing();
                }
                try {
                    if (this.asyncMessageConsumer != null) {
                        this.asyncMessageConsumer.stop();
                    }
                    if (this.nonASFConnectionConsumer != null) {
                        this.nonASFConnectionConsumer.stop();
                    }
                    try {
                        if (this.jmsConnConsumer != null) {
                            this.jmsConnConsumer.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.internalStop", "358", this);
                        Tr.event(tc, "Exception stopping JMSConnectionConsumer", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    }
                    try {
                        if (this.serverSessionPool != null) {
                            if (bl) {
                                this.serverSessionPool.softClose();
                            } else {
                                this.serverSessionPool.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.internalStop", "344", this);
                        Tr.event(tc, "Exception stopping ServerSessionPool", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    }
                    MDBListenerManagerImpl mDBListenerManagerImpl = this.mdbMgr;
                    synchronized (mDBListenerManagerImpl) {
                        try {
                            ExceptionListener exceptionListener;
                            if (this.jmsConn != null && (exceptionListener = this.jmsConn.getExceptionListener()) != null && exceptionListener instanceof JMSExceptionListener && ((JMSExceptionListener)exceptionListener).removeMDBListener(this) == 0) {
                                this.jmsConn.setExceptionListener(null);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.internalStop", "332", this);
                            Tr.event(tc, "Exception removing JMS exception listener", exception);
                        }
                    }
                    try {
                        if (this.jmsConn != null) {
                            this.jmsConn.close();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.internalStop", "372", this);
                        Tr.event(tc, "Exception stopping JMSConnection", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    }
                    Object var8_11 = null;
                    boolean bl5 = bl4 = this.asyncMessageConsumer == null && this.nonASFConnectionConsumer == null && this.jmsConnConsumer == null && this.serverSessionPool == null && this.jmsConn == null;
                }
                catch (Throwable throwable) {
                    boolean bl6;
                    Object var8_12 = null;
                    boolean bl7 = bl6 = this.asyncMessageConsumer == null && this.nonASFConnectionConsumer == null && this.jmsConnConsumer == null && this.serverSessionPool == null && this.jmsConn == null;
                    if (!bl6) {
                        this.asyncMessageConsumer = null;
                        this.nonASFConnectionConsumer = null;
                        this.jmsConnConsumer = null;
                        this.serverSessionPool = null;
                        this.jmsConn = null;
                        Tr.info(tc, "MDBListenerStopped", new Object[]{this.mdbConfig.msgListenerPort.getName(), this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
                    }
                    this.internalStopInProgressSet(false);
                    throw throwable;
                }
                if (!bl4) {
                    this.asyncMessageConsumer = null;
                    this.nonASFConnectionConsumer = null;
                    this.jmsConnConsumer = null;
                    this.serverSessionPool = null;
                    this.jmsConn = null;
                    Tr.info(tc, "MDBListenerStopped", new Object[]{this.mdbConfig.msgListenerPort.getName(), this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
                }
                this.internalStopInProgressSet(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "internalStop", bl2);
        }
        return bl2;
    }

    public MDBConfigData getMDBConfig() {
        return this.mdbConfig;
    }

    public String getListenerPortName() {
        return this.mdbConfig.msgListenerPort.getName();
    }

    public AsyncMessageLog getAsyncMessageLog() {
        return this.asyncMessageLog;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isNonASFListener() {
        return this.nonASFListener;
    }

    public boolean getNonASFBMTRollbackEnabled() {
        return this.nonASFBMTRollbackEnabled;
    }

    public Connection getConnection() {
        return this.jmsConn;
    }

    public synchronized void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        this.recoveryAlarm = null;
        this.restart();
        Tr.exit(tc, "alarm");
    }

    public void quiesce() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce");
        }
        if (this.quiescing) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Quiesce already in progress");
            }
        } else {
            block14: {
                try {
                    block13: {
                        try {
                            if (this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                                if (this.asyncMessageConsumer != null) {
                                    this.asyncMessageConsumer.stop();
                                }
                            } else if (this.nonASFListener && this.nonASFConnectionConsumer != null) {
                                this.nonASFConnectionConsumer.stop();
                            }
                        }
                        catch (Throwable throwable) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block13;
                            Tr.event(tc, "Exception stopping consumer", throwable);
                        }
                    }
                    Thread thread = new Thread(){

                        public void run() {
                            block3: {
                                try {
                                    if (MDBListenerImpl.this.jmsWrapper && MDBListenerImpl.this.jmsConn != null) {
                                        MDBListenerImpl.this.jmsConn.stop();
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                                    Tr.event(tc, "Exception stopping JMS Connection", throwable);
                                }
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (Throwable throwable) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                    Tr.event(tc, "Exception quiescing MDB listener", throwable);
                }
            }
            this.quiescing = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce");
        }
    }

    public void quiesceComplete() {
        Tr.entry(tc, "quiesceComplete");
        this.quiesceComplete = true;
        Tr.exit(tc, "quiesceComplete");
    }

    public boolean isQuiesceComplete() {
        Tr.entry(tc, "isQuiesceComplete");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isQuiesceComplete", new Boolean(this.quiesceComplete));
        }
        return this.quiesceComplete;
    }

    public int getActiveSessionCount() {
        Tr.entry(tc, "getActiveSessionCount");
        int n = 0;
        try {
            if (this.serverSessionPool != null) {
                n = this.serverSessionPool.getActiveSessionCount();
            }
        }
        catch (Throwable throwable) {
            Tr.event(tc, "Exception getting server session pool active count", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveSessionCount", new Integer(n));
        }
        return n;
    }

    public synchronized void startRecoveryAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startRecoveryAlarm");
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "RecoveryCount=", new Integer(this.recoveryCount));
            Tr.event(tc, "Max Recovery Retries=", new Integer(this.mdbMgr.getMaxRecoveryRetries()));
        }
        if (this.recoveryAlarm == null) {
            ++this.recoveryCount;
            if (this.recoveryCount > this.mdbMgr.getMaxRecoveryRetries()) {
                Tr.event(tc, "Exceeded MDB Listener recovery maximum retries:", new Integer(this.mdbMgr.getMaxRecoveryRetries()));
                Tr.error(tc, "MDBListenerRetryLimitReached", new Object[]{new Integer(this.mdbMgr.getMaxRecoveryRetries()), this.mdbConfig.msgListenerPort.getName()});
                this.requiredToBeStarted = false;
                this.stopLPAsynch();
            } else {
                Tr.event(tc, "Scheduling a MDB Listener recovery alarm for awakening in seconds:", new Integer(this.mdbMgr.getRecoveryRetryInterval()));
                Tr.info(tc, "MDBListenerRestartScheduled", new Object[]{this.mdbConfig.msgListenerPort.getName(), new Integer(this.mdbMgr.getRecoveryRetryInterval())});
                this.recoveryAlarm = AlarmManager.createNonDeferrable(this.mdbMgr.getRecoveryRetryInterval() * 1000, this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startRecoveryAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForInactiveSIBMQClientLink(String string) throws MDBStartRescheduledException {
        block17: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForInactiveSIBMQClientLink");
            }
            ContextManager contextManager = ContextManagerFactory.getInstance();
            Subject subject = null;
            try {
                object = contextManager.getServerSubject();
                subject = WSSubject.getRunAsSubject();
                WSSubject.setRunAsSubject((Subject)object);
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception when trying to acquire and set run as security Subject", exception);
            }
            try {
                object = AdminServiceFactory.getAdminService();
                String string2 = object.getCellName();
                String string3 = object.getNodeName();
                String string4 = object.getProcessName();
                String string5 = JMSQueueManagerName.getQueueManagerName(string2, string3, string4);
                if (!string.trim().equals(string5)) break block17;
                boolean bl = true;
                try {
                    String string6 = "WebSphere:type=SIBMQClientLink,node=" + string3 + ",process=" + string4 + ",*";
                    ObjectName objectName = new ObjectName(string6);
                    Iterator iterator = object.queryNames(objectName, null).iterator();
                    while (bl && iterator.hasNext()) {
                        objectName = (ObjectName)iterator.next();
                        try {
                            String string7;
                            String string8 = (String)object.invoke(objectName, "getQueueManagerName", null, null);
                            if (string8 == null || !string8.trim().equals(string.trim()) || (string7 = (String)object.invoke(objectName, "getOverallStatus", null, null)).equals("STOPPED")) continue;
                            bl = false;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.checkForInactiveSIBMQClientLink", "1147", this);
                            Tr.debug(tc, "Exception invoking SIBMQClientLink MBean", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.checkForInactiveSIBMQClientLink", "1157", this);
                    Tr.debug(tc, "Exception querying SIBMQClientLink MBean", exception);
                }
                if (bl) {
                    Tr.debug(tc, "SIB MQ Client Link for the SIB emulated embedded v5 JMSServer is not active yet, rescheduling start of MDB " + this.mdbConfig.mdbName);
                    Tr.exit(tc, "checkForInactiveSIBMQClientLink");
                    throw new MDBStartRescheduledException("SIB MQ Client Link for the SIB emulated embedded v5 JMSServer is not active yet, rescheduling start of MDB " + this.mdbConfig.mdbName);
                }
            }
            finally {
                try {
                    WSSubject.setRunAsSubject(subject);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Exception when trying to set run as security Subject", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForInactiveSIBMQClientLink");
        }
    }

    protected void stopLPAsynch() {
        Thread thread = new Thread(){

            public void run() {
                MDBListenerImpl.this.mdbConfig.msgListenerPort.stop();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private synchronized boolean internalStopInProgressCompareAndSet(boolean bl, boolean bl2) {
        if (this.internalStopInProgress == bl) {
            this.internalStopInProgress = bl2;
            return true;
        }
        return false;
    }

    private synchronized void internalStopInProgressSet(boolean bl) {
        this.internalStopInProgress = bl;
    }

    public synchronized void checkForOldSessions(Long l, long l2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForOldSessions", new Object[]{l, new Long(l2)});
        }
        if (this.serverSessionPool != null) {
            this.serverSessionPool.checkForOldSessions(l, l2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForOldSessions");
        }
    }
}

