/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.jms.DurableSubscriptionManager;
import com.ibm.ejs.jms.JMSDiagnosticModule;
import com.ibm.ejs.jms.JMSRegistration;
import com.ibm.ejs.jms.listener.AsyncMessageLog;
import com.ibm.ejs.jms.listener.AsyncMessageRepository;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListener;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBListenerManager;
import com.ibm.ejs.jms.listener.MDBPool;
import com.ibm.ejs.jms.listener.MDBRuntimeException;
import com.ibm.ejs.jms.listener.MsgListenerPort;
import com.ibm.ejs.jms.listener.ServerSessionPoolTimeoutManager;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Message;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.ejb.AcknowledgeMode;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.SubscriptionDurabilityKind;
import org.eclipse.jst.j2ee.internal.model.translator.ejb.AcknowledgeModeTranslator;
import org.eclipse.jst.j2ee.internal.model.translator.ejb.MessageDrivenDestinationTypeTranslator;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class MDBListenerManagerImpl
implements MDBListenerManager,
DeployedObjectListener,
IWorkloadRegulator,
ConfigChangeListener {
    protected static final TraceComponent tc = Tr.register(MDBListenerManagerImpl.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private int workloadState = 0;
    public static final int WLC_STARTING = 0;
    public static final int WLC_STARTED = 1;
    public static final int WLC_QUIESCING = 2;
    public static final int WLC_QUIESCECOMPLETE = 3;
    public static final String ACTIVATION_CONFIG_DESTINATION_TYPE = "destinationType";
    public static final String ACTIVATION_CONFIG_ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final String ACTIVATION_CONFIG_MESSAGE_SELECTOR = "messageSelector";
    public static final String ACTIVATION_CONFIG_SUBSCRIPTION_NAME = "subscriptionName";
    public static final String ACTIVATION_CONFIG_SUBSCRIPTION_DURABILITY = "subscriptionDurability";
    MessageListenerService messageListenerServiceCopy = null;
    Object extendedMessaging = null;
    DurableSubscriptionManager durableSubscriptionMgr = null;
    protected Hashtable msgListenerPorts = null;
    protected Hashtable mdbListenerHT = null;
    protected ThreadPool sessionThreadPool = null;
    protected PmiBeanFactory pmiFactory = null;
    protected String containerName = "";
    protected Object MQcm = null;
    protected long mqJMSPoolingTimeout;
    protected int mqJMSPoolingThreshold;
    protected int maxRecoveryRetries;
    protected int recoveryRetryInterval;
    protected int nonASFReceiveTimeout;
    protected boolean nonASFBMTRollbackEnabled;
    protected boolean lowThresholdEquHighEnabled;
    protected AsyncMessageLog asyncMessageLog = null;
    protected String serverUri = null;
    protected Repository repository = null;
    protected boolean dynamicConfigurationEnabled = false;
    private int globalServerSessionPoolTimeout = -1;
    private final HashMap serverSessionPoolTimeoutMap = new HashMap();
    private int serverSessionPoolReapInterval = -1;
    private final ServerSessionPoolTimeoutManager timeoutManager = new ServerSessionPoolTimeoutManager();

    public MDBListenerManagerImpl() {
        Tr.entry(tc, "MDBListenerManagerImpl");
        Tr.exit(tc, "MDBListenerManagerImpl");
    }

    public void initialize(Object object, Object object2, Object object3, Object object4, Object object5, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, object2, object3, object4, object5, string, new Boolean(bl)});
        }
        MessageListenerService messageListenerService = (MessageListenerService)object2;
        this.messageListenerServiceCopy = (MessageListenerService)EtoolsCopyUtility.createCopy((EObject)messageListenerService);
        this.repository = (Repository)object;
        this.serverUri = messageListenerService.eResource().getURI().toString();
        String string2 = this.repository.getConfigRoot().getConfigRootPath().replace('\\', '/');
        string2 = new File(string2).toURI().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The serverUri is: " + this.serverUri);
            Tr.debug(tc, "The configRoot is: " + string2);
        }
        if (this.serverUri.indexOf(string2) >= 0) {
            this.serverUri = this.serverUri.substring(this.serverUri.indexOf(string2) + string2.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The serverUri has now changed to: " + this.serverUri);
            }
        }
        this.dynamicConfigurationEnabled = bl;
        this.extendedMessaging = object3;
        this.sessionThreadPool = (ThreadPool)object4;
        this.durableSubscriptionMgr = (DurableSubscriptionManager)object5;
        JMSDiagnosticModule.register();
        this.initializeProperties((List)messageListenerService.getProperties());
        if (this.nonASFReceiveTimeout <= 0) {
            this.timeoutManager.initialize(this.globalServerSessionPoolTimeout, this.serverSessionPoolTimeoutMap, this.serverSessionPoolReapInterval);
        }
        this.asyncMessageLog = new AsyncMessageLog(string);
        this.msgListenerPorts = new Hashtable();
        this.loadListenerPorts(messageListenerService, true);
        this.mdbListenerHT = new Hashtable();
        Tr.exit(tc, "initialize");
    }

    public void startManager() {
        Tr.entry(tc, "startManager");
        if (JMSRegistration.isRegistered()) {
            this.initializeMQJMSConnectionPooling();
        }
        WorkloadController.registerRegulator(this);
        Tr.exit(tc, "startManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDBListener create(MDBPool mDBPool, Object object) throws MDBException {
        Object object2;
        String string;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{mDBPool, object});
        }
        EJBConfigData eJBConfigData = (EJBConfigData)object;
        MDBConfigData mDBConfigData = new MDBConfigData();
        MessageDriven messageDriven = (MessageDriven)eJBConfigData.getDeploymentData();
        mDBConfigData.mdbName = messageDriven.getName();
        mDBConfigData.applicationName = eJBConfigData.getJ2EEName().getApplication();
        mDBConfigData.j2eeName = ((Object)eJBConfigData.getJ2EEName()).toString();
        mDBConfigData.containerName = this.containerName;
        mDBConfigData.pmiFactory = this.pmiFactory;
        mDBConfigData.ejbConfigData = eJBConfigData;
        if (messageDriven.getTransactionType().getValue() == 0) {
            mDBConfigData.transactionType = 0;
        } else {
            mDBConfigData.transactionType = 1;
            mDBConfigData.onMessageTransactionAttr = this.getOnMessageTransactionAttr(eJBConfigData);
        }
        EnterpriseBeanBinding enterpriseBeanBinding = eJBConfigData.getDeploymentBinding();
        if (enterpriseBeanBinding instanceof MessageDrivenBeanBinding) {
            mDBConfigData.msgListenerPort = null;
            object3 = (MessageDrivenBeanBinding)eJBConfigData.getDeploymentBinding();
            string = object3.getListenerInputPortName();
            object2 = this.msgListenerPorts;
            synchronized (object2) {
                if (string != null) {
                    mDBConfigData.msgListenerPort = (MsgListenerPort)this.msgListenerPorts.get(string);
                }
                if (mDBConfigData.msgListenerPort == null) {
                    Tr.warning(tc, "MDBListenerPortNotFound", new Object[]{mDBConfigData.mdbName, string});
                    if (!this.dynamicConfigurationEnabled) {
                        MDBException mDBException = new MDBException("Creation of MDB " + mDBConfigData.mdbName + " unable to find ListenerPort '" + string + "'");
                        Tr.exit(tc, "create");
                        throw mDBException;
                    }
                    mDBConfigData.msgListenerPort = new MsgListenerPort(this, this.extendedMessaging, null, string);
                    this.msgListenerPorts.put(string, mDBConfigData.msgListenerPort);
                }
            }
        } else {
            Tr.warning(tc, "NoMDBBinding", new Object[]{mDBConfigData.mdbName});
            MDBException mDBException = new MDBException("MDB " + mDBConfigData.mdbName + " has no MessageDrivenBeanBinding in ibm-ejb-jar-bnd.xmi");
            Tr.exit(tc, "create");
            throw mDBException;
        }
        if (messageDriven.getActivationConfig() == null) {
            object3 = messageDriven.getDestination();
            mDBConfigData.inputPort.JMSDestinationType = object3 != null && object3.getType().getValue() == 1 ? 1 : 0;
            if (object3 != null) {
                string = object3.getSubscriptionDurability();
                if (string != null && string.getValue() == 0) {
                    mDBConfigData.inputPort.JMSSubscriptionDurability = 1;
                    mDBConfigData.inputPort.JMSSubscriptionName = new String(((Object)eJBConfigData.getJ2EEName()).toString());
                } else {
                    mDBConfigData.inputPort.JMSSubscriptionDurability = 0;
                }
            } else {
                mDBConfigData.inputPort.JMSSubscriptionDurability = 0;
            }
            mDBConfigData.inputPort.JMSMessageSelector = messageDriven.getMessageSelector();
            string = messageDriven.getAcknowledgeMode();
            mDBConfigData.inputPort.JMSAcknowledgement = string != null && string.getValue() == 1 ? 1 : 0;
        } else {
            Object object4;
            MessageDrivenBeanBinding messageDrivenBeanBinding;
            Object object5;
            object3 = null;
            string = null;
            object2 = null;
            String string2 = null;
            String string3 = null;
            ActivationConfig activationConfig = messageDriven.getActivationConfig();
            Iterator iterator = activationConfig.getConfigProperties().iterator();
            while (iterator.hasNext()) {
                object5 = iterator.next();
                if (object5 instanceof ActivationConfigProperty) {
                    boolean bl = true;
                    messageDrivenBeanBinding = (ActivationConfigProperty)object5;
                    object4 = messageDrivenBeanBinding.getName();
                    if (ACTIVATION_CONFIG_MESSAGE_SELECTOR.equals(object4)) {
                        string = messageDrivenBeanBinding.getValue();
                        bl = false;
                    }
                    if (ACTIVATION_CONFIG_ACKNOWLEDGE_MODE.equals(object4)) {
                        object2 = messageDrivenBeanBinding.getValue();
                        bl = false;
                    }
                    if (ACTIVATION_CONFIG_DESTINATION_TYPE.equals(object4)) {
                        object3 = messageDrivenBeanBinding.getValue();
                        bl = false;
                    }
                    if (ACTIVATION_CONFIG_SUBSCRIPTION_DURABILITY.equals(object4)) {
                        string2 = messageDrivenBeanBinding.getValue();
                        bl = false;
                    }
                    if (ACTIVATION_CONFIG_SUBSCRIPTION_NAME.equals(object4)) {
                        string3 = messageDrivenBeanBinding.getValue();
                        bl = false;
                    }
                    if (!bl) continue;
                    Tr.warning(tc, "MDBUnknownActivationSpecParam", new Object[]{mDBConfigData.mdbName, object4});
                    continue;
                }
                Tr.error(tc, "MDBUnknownProperty", new Object[]{mDBConfigData.mdbName, object5, ActivationConfigProperty.class.getName()});
                MDBException mDBException = new MDBException("Creation of MDB " + mDBConfigData.mdbName + " expected a ActivationConfigProperty but received a '" + object5 + "'");
                Tr.exit(tc, "create");
                throw mDBException;
            }
            object5 = mDBConfigData.msgListenerPort.getJmsDestJNDIName();
            String string4 = null;
            messageDrivenBeanBinding = (MessageDrivenBeanBinding)eJBConfigData.getDeploymentBinding();
            if (messageDrivenBeanBinding != null) {
                string4 = messageDrivenBeanBinding.getDestinationJndiName();
            }
            if (messageDrivenBeanBinding != null && messageDrivenBeanBinding.getDestinationJndiName() != null && !messageDrivenBeanBinding.getDestinationJndiName().equals(object5)) {
                Tr.error(tc, "MDBDestinationJndiNameError", new Object[]{mDBConfigData.mdbName, object5, string4});
                object4 = new MDBException("Creation of MDB " + mDBConfigData.mdbName + " destination jndi name in the activation config ('" + string4 + "') and the listener port ('" + object5 + "') do not match");
                Tr.exit(tc, "create");
                throw object4;
            }
            object4 = new MessageDrivenDestinationTypeTranslator();
            mDBConfigData.inputPort.JMSDestinationType = object3 != null && ((DestinationType)object4.convertStringToValue((String)object3, null)).getValue() == 1 ? 1 : 0;
            SubscriptionDurabilityKind subscriptionDurabilityKind = SubscriptionDurabilityKind.get(string2);
            if (subscriptionDurabilityKind != null && subscriptionDurabilityKind.getValue() == 0) {
                mDBConfigData.inputPort.JMSSubscriptionDurability = 1;
                mDBConfigData.inputPort.JMSSubscriptionName = string3 != null ? string3 : new String(((Object)eJBConfigData.getJ2EEName()).toString());
            } else {
                mDBConfigData.inputPort.JMSSubscriptionDurability = 0;
            }
            mDBConfigData.inputPort.JMSMessageSelector = string;
            AcknowledgeModeTranslator acknowledgeModeTranslator = new AcknowledgeModeTranslator();
            mDBConfigData.inputPort.JMSAcknowledgement = object2 != null && ((AcknowledgeMode)acknowledgeModeTranslator.convertStringToValue((String)object2, null)).getValue() == 1 ? 1 : 0;
        }
        MDBListener mDBListener = this.createMDBListener(mDBPool, mDBConfigData);
        object3 = this.msgListenerPorts;
        synchronized (object3) {
            mDBConfigData.msgListenerPort.incMDBRef();
        }
        if (this.nonASFReceiveTimeout <= 0) {
            this.timeoutManager.startMonitoringLP((MDBListenerImpl)mDBListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", mDBListener);
        }
        return mDBListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MDBListener createMDBListener(MDBPool mDBPool, MDBConfigData mDBConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMDBListener", new Object[]{mDBPool, mDBConfigData});
        }
        MDBListenerImpl mDBListenerImpl = null;
        try {
            mDBListenerImpl = new MDBListenerImpl(this, this.durableSubscriptionMgr, mDBPool, this.sessionThreadPool, mDBConfigData, this.asyncMessageLog);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.createMDBListener", "328", this);
            Tr.warning(tc, "MDBListenerCreateError", new Object[]{mDBConfigData.mdbName, mDBConfigData.msgListenerPort.getJmsDestJNDIName(), exception});
            Tr.exit(tc, "createMDBListener");
            throw new MDBRuntimeException(MDBListenerManagerImpl.getNestedException(exception).getMessage(), exception);
        }
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            if (this.mdbListenerHT.contains(mDBListenerImpl)) {
                MDBRuntimeException mDBRuntimeException = new MDBRuntimeException("MDBListener already defined", null);
                Tr.warning(tc, "MDBListenerDuplicate", new Object[]{mDBConfigData.mdbName, mDBConfigData.msgListenerPort.getJmsDestJNDIName()});
                Tr.exit(tc, "createMDBListener");
                throw mDBRuntimeException;
            }
            this.mdbListenerHT.put(mDBListenerImpl, mDBListenerImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMDBListener", mDBListenerImpl);
        }
        return mDBListenerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MDBListener mDBListener) {
        MsgListenerPort msgListenerPort;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", mDBListener);
        }
        if ((msgListenerPort = (MsgListenerPort)this.msgListenerPorts.get(((MDBListenerImpl)mDBListener).getListenerPortName())) != null) {
            msgListenerPort.remove(mDBListener);
        }
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            this.mdbListenerHT.remove(mDBListener);
        }
        try {
            ((MDBListenerImpl)mDBListener).close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.remove", "392", this);
            Tr.warning(tc, "MDBListenerCloseException", new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, ((MDBListenerImpl)mDBListener).getMDBConfig().msgListenerPort.getJmsDestJNDIName(), exception});
        }
        hashtable = this.msgListenerPorts;
        synchronized (hashtable) {
            if (msgListenerPort != null && msgListenerPort.decMDBRef() <= 0 && !msgListenerPort.hasListenerPortConfig()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Listener port removed.", msgListenerPort.getName());
                }
                this.msgListenerPorts.remove(msgListenerPort.getName());
            }
        }
        if (this.nonASFReceiveTimeout <= 0) {
            this.timeoutManager.stopMonitoringLP((MDBListenerImpl)mDBListener);
        }
        Tr.exit(tc, "remove");
    }

    public void start(MDBListener mDBListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", mDBListener);
        }
        ((MDBListenerImpl)mDBListener).start();
        Tr.exit(tc, "start");
    }

    public void stop(MDBListener mDBListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", mDBListener);
        }
        ((MDBListenerImpl)mDBListener).stop();
        Tr.exit(tc, "stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object;
        Tr.entry(tc, "terminate");
        Object object2 = this.mdbListenerHT;
        synchronized (object2) {
            object = this.mdbListenerHT.elements();
            while (object.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = null;
                try {
                    mDBListenerImpl = (MDBListenerImpl)object.nextElement();
                    this.remove(mDBListenerImpl);
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "453", this);
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "458", this);
                    Tr.warning(tc, "MDBListenerTerminateException", new Object[]{mDBListenerImpl.getMDBConfig().mdbName, mDBListenerImpl.getMDBConfig().msgListenerPort.getJmsDestJNDIName(), MDBListenerManagerImpl.getNestedException(exception).getMessage()});
                    Tr.debug(tc, "Exception:", object);
                }
            }
        }
        this.mdbListenerHT = null;
        object2 = this.msgListenerPorts.elements();
        while (object2.hasMoreElements()) {
            object = null;
            try {
                object = ((MsgListenerPort)object2.nextElement()).getMBeanID();
                AdminServiceFactory.getMBeanFactory().deactivateMBean((String)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminate", "480", this);
                Tr.event(tc, "Exception deactivating ListenerPortMbean " + (String)object, exception);
            }
        }
        this.msgListenerPorts = null;
        if (JMSRegistration.isRegistered()) {
            this.terminateMQJMSConnectionPooling();
        }
        this.durableSubscriptionMgr = null;
        this.sessionThreadPool = null;
        this.messageListenerServiceCopy = null;
        this.serverUri = null;
        this.repository = null;
        Tr.exit(tc, "terminate");
    }

    public static Throwable getNestedException(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (true) {
            Exception exception;
            if (throwable2 instanceof RemoteException) {
                exception = (RemoteException)throwable2;
                if (((RemoteException)exception).detail == null) break;
                throwable2 = ((RemoteException)exception).detail;
                continue;
            }
            if (!(throwable2 instanceof NamingException) || ((NamingException)(exception = (NamingException)throwable2)).getRootCause() == null) break;
            throwable2 = ((NamingException)exception).getRootCause();
        }
        return throwable2;
    }

    protected int getOnMessageTransactionAttr(EJBConfigData eJBConfigData) throws MDBException {
        int n;
        EJBMethodInfo[] eJBMethodInfoArray;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOnMessageTransactionAttr", eJBConfigData);
        }
        TransactionAttribute transactionAttribute = null;
        String string = null;
        try {
            object = Class.forName("javax.jms.MessageListener");
            eJBMethodInfoArray = ((Class)object).getMethod("onMessage", Message.class);
            string = MethodAttribUtils.methodSignature((Method)eJBMethodInfoArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.getOnMessageTransactionAttr", "548", this);
            Tr.exit(tc, "getOnMessageTransactionAttr");
            throw new MDBException("Unable to determine onMessage method signature");
        }
        object = eJBConfigData.getEJBComponentMetaData();
        eJBMethodInfoArray = object.getEJBMethodMetaData(MethodInterface.MESSAGE_LISTENER);
        for (n = 0; n < eJBMethodInfoArray.length; ++n) {
            if (!eJBMethodInfoArray[n].getMethodSignature().equals(string)) continue;
            transactionAttribute = eJBMethodInfoArray[n].getTransactionAttribute();
            break;
        }
        if (transactionAttribute == null) {
            n = 0;
        } else if (transactionAttribute.getValue() == TransactionAttribute.TX_NOT_SUPPORTED.getValue()) {
            n = 1;
        } else if (transactionAttribute.getValue() == TransactionAttribute.TX_REQUIRED.getValue()) {
            n = 0;
        } else {
            MDBException mDBException = new MDBException("Invalid MDB onMessage() transaction attribute");
            FFDCFilter.processException((Throwable)mDBException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.getOnMessageTransactionAttr", "574", this);
            Tr.exit(tc, "getOnMessageTransactionAttr");
            throw mDBException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOnMessageTransactionAttr", new Integer(n));
        }
        return n;
    }

    public void setPmiData(Object object, String string) {
        this.pmiFactory = (PmiBeanFactory)object;
        this.containerName = string;
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged", deployedObjectEvent);
        }
        if (deployedObjectEvent.getNewValue() == "STARTED") {
            DeployedObject deployedObject2 = (DeployedObject)deployedObjectEvent.getSource();
            if (deployedObject2.getModuleFile().isEARFile()) {
                this.startApplicationMDBs(deployedObject2.getName());
            }
        } else if (deployedObjectEvent.getNewValue() == "STOPPING" && (deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            this.stopApplicationMDBs(deployedObject.getName());
        }
        Tr.exit(tc, "stateChanged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startApplicationMDBs(String string) {
        Tr.entry(tc, "startApplicationMDBs", string);
        Hashtable hashtable = null;
        Object object = this.mdbListenerHT;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Cloning mdbListenerHT hashtable");
            }
            hashtable = (Hashtable)this.mdbListenerHT.clone();
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)object.nextElement();
            MDBConfigData mDBConfigData = mDBListenerImpl.getMDBConfig();
            if (!mDBConfigData.applicationName.equals(string)) continue;
            mDBConfigData.msgListenerPort.add(mDBListenerImpl);
        }
        Tr.exit(tc, "startApplicationMDBs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopApplicationMDBs(String string) {
        Tr.entry(tc, "stopApplicationMDBs", string);
        Hashtable hashtable = null;
        Object object = this.mdbListenerHT;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Cloning mdbListenerHT hashtable");
            }
            hashtable = (Hashtable)this.mdbListenerHT.clone();
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)object.nextElement();
            MDBConfigData mDBConfigData = mDBListenerImpl.getMDBConfig();
            if (!mDBConfigData.applicationName.equals(string)) continue;
            mDBConfigData.msgListenerPort.remove(mDBListenerImpl);
        }
        Tr.exit(tc, "stopApplicationMDBs");
    }

    private void initializeMQJMSConnectionPooling() {
        Tr.entry(tc, "initializeMQJMSConnectionPooling");
        try {
            Class<?> clazz = Class.forName("com.ibm.mq.MQSimpleConnectionManager");
            this.MQcm = clazz.newInstance();
            Method method2 = clazz.getMethod("setTimeout", Long.TYPE);
            Object[] objectArray = new Object[]{new Long(this.mqJMSPoolingTimeout)};
            method2.invoke(this.MQcm, objectArray);
            Method method3 = clazz.getMethod("setHighThreshold", Integer.TYPE);
            Object[] objectArray2 = new Object[]{new Integer(this.mqJMSPoolingThreshold)};
            method3.invoke(this.MQcm, objectArray2);
            Field field = clazz.getField("MODE_AUTO");
            Method method4 = clazz.getMethod("setActive", Integer.TYPE);
            Object[] objectArray3 = new Object[]{field.get(this.MQcm)};
            method4.invoke(this.MQcm, objectArray3);
            Class<?> clazz2 = Class.forName("com.ibm.mq.MQEnvironment");
            Method method5 = clazz2.getMethod("setDefaultConnectionManager", Class.forName("com.ibm.mq.MQConnectionManager"));
            Object[] objectArray4 = new Object[]{this.MQcm};
            method5.invoke(null, objectArray4);
            Tr.event(tc, "MQSeries JMS Connection pooling configured successfully");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeMQJMSConnectionPooling", "705", this);
            Tr.event(tc, "Failed to find class for MQSeries JMS connection pooling");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeMQJMSConnectionPooling", "710", this);
            Tr.event(tc, "Exception initializing MQSeries JMS connection pooling", throwable);
        }
        Tr.exit(tc, "initializeMQJMSConnectionPooling");
    }

    private void terminateMQJMSConnectionPooling() {
        Tr.entry(tc, "terminateMQJMSConnectionPooling");
        try {
            if (this.MQcm != null) {
                Class<?> clazz = Class.forName("com.ibm.mq.MQSimpleConnectionManager");
                Field field = clazz.getField("MODE_INACTIVE");
                Method method2 = clazz.getMethod("setActive", Integer.TYPE);
                Object[] objectArray = new Object[]{field.get(this.MQcm)};
                method2.invoke(this.MQcm, objectArray);
            }
            this.MQcm = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminateMQJMSConnectionPooling", "740", this);
            Tr.event(tc, "Failed to find class for MQSeries JMS connection pooling");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.terminateMQJMSConnectionPooling", "745", this);
            Tr.event(tc, "Exception terminating MQSeries JMS connection pooling", throwable);
        }
        Tr.exit(tc, "terminateMQJMSConnectionPooling");
    }

    public AsyncMessageRepository getAsyncMessageLog() {
        return this.asyncMessageLog;
    }

    private void initializeProperties(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeProperties", list);
        }
        this.mqJMSPoolingTimeout = 300000L;
        this.mqJMSPoolingThreshold = 10;
        this.maxRecoveryRetries = 5;
        this.recoveryRetryInterval = 60;
        this.nonASFReceiveTimeout = 0;
        this.nonASFBMTRollbackEnabled = false;
        this.lowThresholdEquHighEnabled = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                Property property = (Property)list.get(i);
                if (property.getName().equalsIgnoreCase("MQJMS.POOLING.TIMEOUT")) {
                    try {
                        this.mqJMSPoolingTimeout = Long.parseLong(property.getValue());
                        Tr.event(tc, "Set MQSeries JMS Connection pooling timeout property to " + this.mqJMSPoolingTimeout);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "793", this);
                        Tr.event(tc, "Exception parsing MQSeries JMS pooling timeout property, setting to default value", exception);
                        this.mqJMSPoolingTimeout = 300000L;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("MQJMS.POOLING.THRESHOLD")) {
                    try {
                        this.mqJMSPoolingThreshold = Integer.parseInt(property.getValue());
                        Tr.event(tc, "Set MQSeries JMS Connection pooling threshold property to " + this.mqJMSPoolingThreshold);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "807", this);
                        Tr.event(tc, "Exception parsing MQSeries JMS pooling threshold property, setting to default value", exception);
                        this.mqJMSPoolingThreshold = 10;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("MAX.RECOVERY.RETRIES")) {
                    try {
                        this.maxRecoveryRetries = Integer.parseInt(property.getValue());
                        Tr.event(tc, "Set max recovery retries property to " + this.maxRecoveryRetries);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "821", this);
                        Tr.event(tc, "Exception parsing max recovery retries property, setting to default value", exception);
                        this.maxRecoveryRetries = 5;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("RECOVERY.RETRY.INTERVAL")) {
                    try {
                        this.recoveryRetryInterval = Integer.parseInt(property.getValue());
                        Tr.event(tc, "Set recovery retry interval property to " + this.recoveryRetryInterval);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "835", this);
                        Tr.event(tc, "Exception parsing recovery retry interval property, setting to default value", exception);
                        this.recoveryRetryInterval = 60;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("NON.ASF.RECEIVE.TIMEOUT")) {
                    try {
                        this.nonASFReceiveTimeout = Integer.parseInt(property.getValue());
                        Tr.event(tc, "Set non-ASF receive timeout property to " + this.nonASFReceiveTimeout);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "849", this);
                        Tr.event(tc, "Exception parsing non-ASF receieve timeout property, setting to default value", exception);
                        this.nonASFReceiveTimeout = 0;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("NON.ASF.BMT.ROLLBACK.ENABLED")) {
                    try {
                        this.nonASFBMTRollbackEnabled = Boolean.valueOf(property.getValue()) != false;
                        Tr.event(tc, "Set non-ASF BMT rollback enabled property to " + this.nonASFBMTRollbackEnabled);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "851", this);
                        Tr.event(tc, "Exception parsing non-ASF BMT rollback enabled property, setting to default value", exception);
                        this.nonASFBMTRollbackEnabled = false;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("MDB.THROTTLE.THRESHOLD.LOW.EQUALS.HIGH")) {
                    try {
                        string = property.getValue();
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "LowThreshold equals HighThreshold property value read as", string);
                        }
                        this.lowThresholdEquHighEnabled = string != null && string.equalsIgnoreCase("TRUE");
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "LowThreshold equals HighThreshold property value set to ", new Boolean(this.lowThresholdEquHighEnabled));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "850", this);
                        Tr.event(tc, "Exception parsing lowThreshold equals highTreshold property, setting to default value of false", exception);
                        this.lowThresholdEquHighEnabled = false;
                    }
                    continue;
                }
                if (property.getName().equalsIgnoreCase("SERVER.SESSION.POOL.REAP.TIME")) {
                    try {
                        this.serverSessionPoolReapInterval = Integer.parseInt(property.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Server session pool reap interval is: " + this.serverSessionPoolReapInterval);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "1:1231:1.52.2.5", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception caught parsing server session pool reap interval.", exception);
                    }
                    continue;
                }
                if (!property.getName().startsWith("SERVER.SESSION.POOL.UNUSED.TIMEOUT")) continue;
                try {
                    string = property.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing the following property: " + string);
                    }
                    if (string.equals("SERVER.SESSION.POOL.UNUSED.TIMEOUT")) {
                        this.globalServerSessionPoolTimeout = Integer.parseInt(property.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Default server session pool timeout is: " + this.globalServerSessionPoolTimeout);
                        continue;
                    }
                    String string2 = string.substring("SERVER.SESSION.POOL.UNUSED.TIMEOUT".length() + 1);
                    int n = Integer.parseInt(property.getValue());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Customised server session pool timeout for lp: " + string2 + " is: " + n);
                    }
                    this.serverSessionPoolTimeoutMap.put(string2, new Integer(n));
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.initializeProperties", "1:1262:1.52.2.5", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception caught parsing ServerSessionPool timeout.", exception);
                }
            }
        }
        Tr.exit(tc, "initializeProperties");
    }

    public int getMaxRecoveryRetries() {
        return this.maxRecoveryRetries;
    }

    public int getRecoveryRetryInterval() {
        return this.recoveryRetryInterval;
    }

    public int getNonASFReceiveTimeout() {
        return this.nonASFReceiveTimeout;
    }

    public boolean getNonASFBMTRollbackEnabled() {
        return this.nonASFBMTRollbackEnabled;
    }

    public boolean getlowThresholdEquHighEnabled() {
        return this.lowThresholdEquHighEnabled;
    }

    public boolean starting() {
        Tr.entry(tc, "starting");
        this.workloadState = 0;
        Tr.exit(tc, "starting");
        return true;
    }

    public boolean started() {
        Tr.entry(tc, "started");
        this.workloadState = 1;
        Tr.exit(tc, "started");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quiesce() {
        Tr.entry(tc, "quiesce");
        this.workloadState = 2;
        int n = 0;
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            Enumeration enumeration = this.mdbListenerHT.elements();
            while (enumeration.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
                mDBListenerImpl.quiesce();
                n += mDBListenerImpl.getActiveSessionCount();
            }
        }
        boolean bl = n == 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quiesceComplete() {
        Tr.entry(tc, "quiesceComplete");
        this.workloadState = 3;
        Hashtable hashtable = this.mdbListenerHT;
        synchronized (hashtable) {
            Enumeration enumeration = this.mdbListenerHT.elements();
            while (enumeration.hasMoreElements()) {
                MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)enumeration.nextElement();
                mDBListenerImpl.quiesceComplete();
            }
        }
        Tr.exit(tc, "quiesceComplete");
        return true;
    }

    public String getTypeName() {
        return "MSGQ";
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return "MSGQ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadListenerPorts(MessageListenerService messageListenerService, boolean bl) {
        Hashtable hashtable = this.msgListenerPorts;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            EList eList = messageListenerService.getListenerPorts();
            for (int i = 0; i < eList.size(); ++i) {
                object2 = (ListenerPort)eList.get(i);
                if (object2 == null || object2.getName() == null) continue;
                hashtable2.put(object2.getName(), object2);
                object = (MsgListenerPort)this.msgListenerPorts.get(object2.getName());
                if (object == null || !((MsgListenerPort)object).hasListenerPortConfig()) {
                    String string;
                    block24: {
                        String string2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New Listener port being dynamically created.", object2.getName());
                        }
                        if (object == null) {
                            object = new MsgListenerPort(this, this.extendedMessaging, (ListenerPort)object2, object2.getName());
                            this.msgListenerPorts.put(object2.getName(), object);
                        } else {
                            ((MsgListenerPort)object).setListenerPortConfig((ListenerPort)object2);
                        }
                        string = string2 = object2.getName();
                        try {
                            string = AdminServiceFactory.getMBeanFactory().getConfigId(object2);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.loadListenerPorts", "1359", this);
                            Tr.warning(tc, "ListenerPortMBeanActivateException", new Object[]{string, exception});
                            if (!tc.isDebugEnabled()) break block24;
                            Tr.debug(tc, "Exception getting MBeanID, using: " + string, exception);
                        }
                    }
                    ((MsgListenerPort)object).setMBeanID(string);
                    try {
                        StateManageable stateManageable;
                        ExecutionState executionState;
                        ObjectName objectName = AdminServiceFactory.getMBeanFactory().activateMBean("ListenerPort", (RuntimeCollaborator)object, string, null);
                        ((RuntimeCollaborator)object).setObjectName(objectName);
                        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                        if (platformHelper.isZOS() && bl || (executionState = (stateManageable = object2.getStateManagement()).getInitialState()).getValue() != 0) continue;
                        AdminServiceFactory.getAdminService().invoke(objectName, "start", null, null);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.laodListenerPorts", "1394", this);
                        Tr.warning(tc, "ListenerPortMBeanActivateException", new Object[]{string, exception});
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception activating ListenerPort MBean " + string, exception);
                    }
                    continue;
                }
                boolean bl2 = ((MsgListenerPort)object).setListenerPortConfig((ListenerPort)object2);
            }
            Iterator iterator = this.msgListenerPorts.values().iterator();
            while (iterator.hasNext()) {
                object2 = (MsgListenerPort)iterator.next();
                if (hashtable2.get(((MsgListenerPort)object2).getName()) != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Listener port does not exist in configuration.", ((MsgListenerPort)object2).getName());
                }
                if (((RuntimeCollaborator)object2).getObjectName() != null) {
                    block25: {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Stopping and deactivating Listener port MBean.", ((MsgListenerPort)object2).getName());
                            }
                            if (((Boolean)(object = (Boolean)AdminServiceFactory.getAdminService().getAttribute(((RuntimeCollaborator)object2).getObjectName(), "started"))).booleanValue()) {
                                AdminServiceFactory.getAdminService().invoke(((RuntimeCollaborator)object2).getObjectName(), "stop", null, null);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Listener port MBean already stopped.", ((MsgListenerPort)object2).getName());
                            }
                            AdminServiceFactory.getMBeanFactory().deactivateMBean(((RuntimeCollaborator)object2).getObjectName());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.loadListenerPort", "1434", this);
                            if (!tc.isDebugEnabled()) break block25;
                            Tr.debug(tc, "Listener port MBean exception", exception);
                        }
                    }
                    ((DefaultRuntimeCollaborator)object2).setObjectName(null);
                }
                if (((MsgListenerPort)object2).getMDBRef() <= 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Listener port removed.", ((MsgListenerPort)object2).getName());
                    }
                    iterator.remove();
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Listener port config unset, but still has MDB references.", new Object[]{((MsgListenerPort)object2).getName(), new Integer(((MsgListenerPort)object2).getMDBRef())});
                }
                ((MsgListenerPort)object2).setListenerPortConfig(null);
            }
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        block11: {
            Object var2_2 = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configChanged", configRepositoryEvent);
            }
            try {
                ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configChanged: change count=" + configChangeNotifierArray.length);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "this MDBListenerManager serverUri: " + this.serverUri);
                }
                for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                    MessageListenerService messageListenerService;
                    Object object;
                    String string = configChangeNotifierArray[i].getUri();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged event: " + string);
                    }
                    if (!string.equals(this.serverUri)) continue;
                    Resource resource = this.repository.getConfigRoot().getResource(4, "server.xml");
                    EList eList = resource.getContents();
                    Server server2 = (Server)resource.getContents().get(0);
                    EList eList2 = server2.getComponents();
                    ApplicationServer applicationServer = null;
                    Iterator iterator = eList2.iterator();
                    while (iterator.hasNext() && applicationServer == null) {
                        object = iterator.next();
                        if (!(object instanceof ApplicationServer)) continue;
                        applicationServer = (ApplicationServer)object;
                    }
                    if (applicationServer == null) continue;
                    eList2 = applicationServer.getComponents();
                    object = null;
                    iterator = eList2.iterator();
                    while (iterator.hasNext() && object == null) {
                        messageListenerService = (MessageListenerService)iterator.next();
                        if (!(messageListenerService instanceof EJBContainer)) continue;
                        object = (EJBContainer)messageListenerService;
                    }
                    if (object == null) continue;
                    messageListenerService = null;
                    EList eList3 = object.getServices();
                    iterator = eList3.iterator();
                    while (iterator.hasNext() && messageListenerService == null) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof MessageListenerService)) continue;
                        messageListenerService = (MessageListenerService)e2;
                    }
                    if (messageListenerService == null) continue;
                    this.loadListenerPorts(messageListenerService, false);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerManagerImpl.configChanged", "1258", this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "configChanged exception:", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void applicationManagerStopping() {
    }
}

