/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class MDBWrapper
implements MessageListener {
    protected static final TraceComponent tc = Tr.register(MDBWrapper.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private MDBConfigData mdbConfig;
    private MessageListener mdbRef;
    private MessageListener messageListener = null;
    private Message deliveredMsg = null;
    private int jmsXDeliveryCount = 0;
    private int lastFailedDeliveryCount = 0;
    private boolean preRunEnlist = false;
    private Destination jmsDest = null;
    private PriviledgedOnMessage priviledgedOnMessage = null;
    private Session jmsSession = null;
    private Object rmObject = null;
    private String destinationName = null;

    public MDBWrapper(MDBConfigData mDBConfigData, MessageListener messageListener, boolean bl, Destination destination, Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MDBWrapper", new Object[]{mDBConfigData, messageListener, new Boolean(bl)});
        }
        this.mdbConfig = mDBConfigData;
        this.mdbRef = messageListener;
        this.preRunEnlist = bl;
        this.jmsDest = destination;
        this.jmsSession = session;
        this.priviledgedOnMessage = new PriviledgedOnMessage();
        Tr.exit(tc, "MDBWrapper");
    }

    public void setMessageListener(MessageListener messageListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", messageListener);
        }
        this.messageListener = messageListener;
        Tr.exit(tc, "setMessageListener");
    }

    public int getJMSXDeliveryCount() {
        Tr.entry(tc, "getJMSXDeliveryCount");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMSXDeliveryCount", new Integer(this.jmsXDeliveryCount));
        }
        return this.jmsXDeliveryCount;
    }

    public int getLastFailedDeliveryCount() {
        Tr.entry(tc, "getLastFailedDeliveryCount");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLastFailedDeliveryCount", new Integer(this.lastFailedDeliveryCount));
        }
        return this.lastFailedDeliveryCount;
    }

    public void setLastFailedDeliveryCount(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLastFailedDeliveryCount", new Integer(n));
        }
        this.lastFailedDeliveryCount = n;
        Tr.exit(tc, "setLastFailedDeliveryCount");
    }

    public void onMessage(Message message) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onMessage", message);
        }
        try {
            this.jmsXDeliveryCount = message.getIntProperty("JMSXDeliveryCount");
        }
        catch (Exception exception) {
            Tr.event(tc, "Exception {0} getting JMS Message property JMSXDeliveryCount", exception);
            this.jmsXDeliveryCount = 0;
        }
        if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
            this.mdbConfig.pmiBean.messageDelivered();
        }
        boolean bl2 = bl = this.jmsSession instanceof JMSSessionHandle && ((JMSSessionHandle)this.jmsSession).isMQSession();
        if (bl && JMSRequestMetrics.isRMEnabledForMDB()) {
            Object object;
            Object var3_4 = null;
            try {
                object = message.getJMSDestination();
                if (object != null) {
                    this.destinationName = object instanceof Queue ? ((Queue)object).getQueueName() : ((Topic)object).getTopicName();
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.MDBWrapper.onMessage", "103", this);
                Tr.event(tc, "Exception {0} getting destination name from the destination", (Object)jMSException);
            }
            object = this.mdbConfig.inputPort.JMSMessageSelector;
            String[] stringArray = new String[]{this.destinationName, object, "WMQ"};
            this.setRMObject(JMSRequestMetrics.preMDBConsumeMessage(message, stringArray));
        }
        try {
            this.deliveredMsg = message;
            if (this.preRunEnlist) {
                this.callOnMessage();
            } else {
                this.mdbRef.onMessage(null);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.jmsXDeliveryCount > this.lastFailedDeliveryCount) {
                this.lastFailedDeliveryCount = this.jmsXDeliveryCount;
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onMessage");
        }
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    protected void callOnMessage() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callOnMessage");
        }
        AccessController.doPrivileged((PrivilegedAction)this.priviledgedOnMessage);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callOnMessage");
        }
    }

    public Object getRMObject() {
        return this.rmObject;
    }

    public void setRMObject(Object object) {
        this.rmObject = object;
    }

    class PriviledgedOnMessage
    implements PrivilegedAction {
        PriviledgedOnMessage() {
        }

        public Object run() {
            MDBWrapper.this.messageListener.onMessage(MDBWrapper.this.deliveredMsg);
            return null;
        }
    }
}

