/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtension;
import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtensionAccessor;
import com.ibm.ejs.jms.listener.AsyncMessageConsumerExtensionAccessorFactory;
import com.ibm.ejs.jms.listener.MDBListener;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBListenerManager;
import com.ibm.ejs.jms.listener.MDBRuntimeException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanException;
import javax.management.Notification;

public class MsgListenerPort
extends DefaultRuntimeCollaborator {
    protected static TraceComponent tc = Tr.register(MsgListenerPort.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private boolean started = false;
    private MDBListenerManager mdbMgr = null;
    private Object extendedMessaging = null;
    private String name;
    private String mBeanId = "";
    private int maxSessions;
    private int maxRetries;
    private int maxMessages;
    private String jmsConnJNDIName;
    private String jmsDestJNDIName;
    private boolean asyncMessageConsumerEnabled;
    private int asyncMessageConsumerRequestInterval;
    private int asyncMessageConsumerRequestTimeout;
    private int liveMaxSessions = 0;
    private int liveMaxRetries = 0;
    private int liveMaxMessages = 0;
    private String liveJmsConnJNDIName = "";
    private String liveJmsDestJNDIName = "";
    private boolean liveAsyncMessageConsumerEnabled = false;
    private int liveAsyncMessageConsumerRequestInterval = 0;
    private int liveAsyncMessageConsumerRequestTimeout = 0;
    private Hashtable mdbListeners = new Hashtable();
    private long ntfySeqNum = 0L;
    private boolean hasListenerPortConfig = false;
    private int mdbRefCount = 0;

    public MsgListenerPort(MDBListenerManager mDBListenerManager, Object object, ListenerPort listenerPort, String string) {
        super(string);
        Tr.entry(tc, "MsgListenerPort");
        this.mdbMgr = mDBListenerManager;
        this.extendedMessaging = object;
        this.mBeanId = this.name = string;
        this.setListenerPortConfig(listenerPort);
        this.liveMaxSessions = this.maxSessions;
        this.liveMaxRetries = this.maxRetries;
        this.liveMaxMessages = this.maxMessages;
        this.liveJmsConnJNDIName = this.jmsConnJNDIName;
        this.liveJmsDestJNDIName = this.jmsDestJNDIName;
        this.liveAsyncMessageConsumerEnabled = this.asyncMessageConsumerEnabled;
        this.liveAsyncMessageConsumerRequestInterval = this.asyncMessageConsumerRequestInterval;
        this.liveAsyncMessageConsumerRequestTimeout = this.asyncMessageConsumerRequestTimeout;
        Tr.exit(tc, "MsgListenerPort");
    }

    public synchronized boolean setListenerPortConfig(ListenerPort listenerPort) {
        boolean bl = false;
        if (listenerPort == null) {
            this.hasListenerPortConfig = false;
        } else {
            this.hasListenerPortConfig = true;
            if (listenerPort.getMaxSessions() != this.maxSessions || listenerPort.getMaxRetries() != this.maxRetries || listenerPort.getMaxMessages() != this.maxMessages || !listenerPort.getConnectionFactoryJNDIName().equals(this.jmsConnJNDIName) || !listenerPort.getDestinationJNDIName().equals(this.jmsDestJNDIName)) {
                bl = true;
            }
            this.maxSessions = listenerPort.getMaxSessions();
            this.maxRetries = listenerPort.getMaxRetries();
            this.maxMessages = listenerPort.getMaxMessages();
            this.jmsConnJNDIName = listenerPort.getConnectionFactoryJNDIName();
            this.jmsDestJNDIName = listenerPort.getDestinationJNDIName();
            this.loadAsyncMessageConsumerExtension(listenerPort);
        }
        return bl;
    }

    public synchronized boolean hasListenerPortConfig() {
        return this.hasListenerPortConfig;
    }

    public synchronized int incMDBRef() {
        return this.mdbRefCount++;
    }

    public synchronized int decMDBRef() {
        return this.mdbRefCount--;
    }

    public synchronized int getMDBRef() {
        return this.mdbRefCount;
    }

    public synchronized void add(MDBListener mDBListener) {
        Tr.entry(tc, "add");
        this.mdbListeners.put(mDBListener, mDBListener);
        if (this.started) {
            try {
                this.mdbMgr.start(mDBListener);
            }
            catch (MDBRuntimeException mDBRuntimeException) {
                FFDCFilter.processException((Throwable)mDBRuntimeException, "com.ibm.ejs.jms.listener.MsgListenerPort.add", "140", this);
                Tr.warning(tc, "MDBListenerStartFailed", new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, this.name});
                Tr.debug(tc, "Exception starting MDB Listener", mDBRuntimeException);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.listener.MsgListenerPort.add", "146", this);
                Tr.event(tc, "MDB Listener already started", illegalStateException);
            }
        }
        Tr.exit(tc, "add");
    }

    public synchronized void remove(MDBListener mDBListener) {
        Tr.entry(tc, "remove");
        this.mdbListeners.remove(mDBListener);
        this.mdbMgr.stop(mDBListener);
        Tr.exit(tc, "remove");
    }

    public Boolean isStarted() {
        Tr.entry(tc, "isStarted");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStarted", new Boolean(this.started));
        }
        return new Boolean(this.started);
    }

    public String getName() {
        Tr.entry(tc, "getName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName", this.name);
        }
        return this.name;
    }

    public synchronized void start() {
        Tr.entry(tc, "start");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Emitting J2EE Starting");
        }
        this.sendStateNotification("j2ee.state.starting");
        this.liveMaxSessions = this.maxSessions;
        this.liveMaxRetries = this.maxRetries;
        this.liveMaxMessages = this.maxMessages;
        this.liveJmsConnJNDIName = this.jmsConnJNDIName;
        this.liveJmsDestJNDIName = this.jmsDestJNDIName;
        this.liveAsyncMessageConsumerEnabled = this.asyncMessageConsumerEnabled;
        this.liveAsyncMessageConsumerRequestInterval = this.asyncMessageConsumerRequestInterval;
        this.liveAsyncMessageConsumerRequestTimeout = this.asyncMessageConsumerRequestTimeout;
        Enumeration enumeration = this.mdbListeners.keys();
        while (enumeration.hasMoreElements()) {
            MDBListener mDBListener = (MDBListener)this.mdbListeners.get(enumeration.nextElement());
            try {
                this.mdbMgr.start(mDBListener);
            }
            catch (MDBRuntimeException mDBRuntimeException) {
                FFDCFilter.processException((Throwable)mDBRuntimeException, "com.ibm.ejs.jms.listener.MsgListenerPort.start", "223", this);
                Tr.warning(tc, "MDBListenerStartFailed", new Object[]{((MDBListenerImpl)mDBListener).getMDBConfig().mdbName, this.name});
                Tr.debug(tc, "Exception starting MDB Listener", mDBRuntimeException);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.listener.MsgListenerPort.start", "229", this);
                Tr.event(tc, "MDB Listener already started", illegalStateException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Emitting J2EE Running");
        }
        this.sendStateNotification("j2ee.state.running");
        this.started = true;
        Tr.exit(tc, "start");
    }

    public synchronized void stop() {
        Tr.entry(tc, "stop");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Emitting J2EE Stopping");
        }
        this.sendStateNotification("j2ee.state.stopping");
        this.started = false;
        Enumeration enumeration = this.mdbListeners.keys();
        while (enumeration.hasMoreElements()) {
            MDBListener mDBListener = (MDBListener)this.mdbListeners.get(enumeration.nextElement());
            try {
                this.mdbMgr.stop(mDBListener);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MsgListenerPort.stop", "259", this);
                Tr.event(tc, "Exception stopping MDB Listener", exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Emitting J2EE Stopped");
        }
        this.sendStateNotification("j2ee.state.stopped");
        Tr.exit(tc, "stop");
    }

    public int getMaxSessions() {
        return this.liveMaxSessions;
    }

    public int getMaxRetries() {
        return this.liveMaxRetries;
    }

    public int getMaxMessages() {
        return this.liveMaxMessages;
    }

    public String getJmsConnJNDIName() {
        return this.liveJmsConnJNDIName;
    }

    public String getJmsDestJNDIName() {
        return this.liveJmsDestJNDIName;
    }

    public boolean getAsyncMessageConsumerEnabled() {
        return this.liveAsyncMessageConsumerEnabled;
    }

    public int getAsyncMessageConsumerRequestInterval() {
        return this.liveAsyncMessageConsumerRequestInterval;
    }

    public int getAsyncMessageConsumerRequestTimeout() {
        return this.liveAsyncMessageConsumerRequestTimeout;
    }

    public void setMaxSessions(int n) {
        this.maxSessions = n;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setMaxMessages(int n) {
        this.maxMessages = n;
    }

    public void setJmsConnJNDIName(String string) {
        this.jmsConnJNDIName = string;
    }

    public void setJmsDestJNDIName(String string) {
        this.jmsDestJNDIName = string;
    }

    public void setAsyncMessageConsumerEnabled(boolean bl) {
        this.asyncMessageConsumerEnabled = bl;
    }

    public void setAsyncMessageConsumerRequestInterval(int n) {
        this.asyncMessageConsumerRequestInterval = n;
    }

    public void setAsyncMessageConsumerRequestTimeout(int n) {
        this.asyncMessageConsumerRequestTimeout = n;
    }

    private void loadAsyncMessageConsumerExtension(ListenerPort listenerPort) {
        Tr.entry(tc, "loadAsyncMessageConsumerExtension", listenerPort);
        if (this.extendedMessaging == null) {
            Tr.event(tc, "Extended Messaging not installed");
            this.asyncMessageConsumerEnabled = false;
        } else {
            AsyncMessageConsumerExtensionAccessor asyncMessageConsumerExtensionAccessor = AsyncMessageConsumerExtensionAccessorFactory.create();
            if (asyncMessageConsumerExtensionAccessor == null) {
                Tr.event(tc, "AsyncMessageConsumerExtension not installed");
                this.asyncMessageConsumerEnabled = false;
            } else {
                Tr.event(tc, "AsyncMessageConsumerExtension installed");
                AsyncMessageConsumerExtension asyncMessageConsumerExtension = asyncMessageConsumerExtensionAccessor.get(this.extendedMessaging, listenerPort);
                if (asyncMessageConsumerExtension == null) {
                    Tr.event(tc, "ListenerPort has no AsyncMessageConsumerExtension");
                    this.asyncMessageConsumerEnabled = false;
                } else {
                    Tr.event(tc, "ListenerPort AsyncMessageConsumerExtension found", asyncMessageConsumerExtension);
                    this.asyncMessageConsumerEnabled = asyncMessageConsumerExtension.getAsyncMessageConsumerEnabled();
                    this.asyncMessageConsumerRequestInterval = asyncMessageConsumerExtension.getAsyncMessageConsumerRequestInterval();
                    this.asyncMessageConsumerRequestTimeout = asyncMessageConsumerExtension.getAsyncMessageConsumerRequestTimeout();
                }
            }
        }
        Tr.exit(tc, "loadAsyncMessageConsumerExtension");
    }

    void setMBeanID(String string) {
        this.mBeanId = string;
    }

    String getMBeanID() {
        return this.mBeanId;
    }

    private void sendStateNotification(String string) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendStateNotification", string);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Src: " + this.getObjectName());
                }
                super.sendNotification(new Notification(string, this.getObjectName(), this.ntfySeqNum++));
            }
            catch (MBeanException mBeanException) {
                if (!tc.isEntryEnabled()) break block5;
                Tr.debug(tc, "Error occured sending Notification:", mBeanException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendStateNotification", string);
        }
    }
}

