/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.JMSException;

public class NonASFConnectionConsumer
implements Runnable {
    protected static TraceComponent tc = Tr.register(NonASFConnectionConsumer.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private boolean started = false;
    private final Object lock = new Object();
    private ServerSessionPool serverSessionPool;
    private int timeout;

    public NonASFConnectionConsumer(ServerSessionPool serverSessionPool, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonASFConnectionConsumer", new Object[]{serverSessionPool, new Integer(n)});
        }
        this.serverSessionPool = serverSessionPool;
        this.timeout = n;
        Tr.exit(tc, "NonASFConnectionConsumer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Tr.entry(tc, "start");
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            this.started = true;
            thread.start();
        }
        Tr.exit(tc, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Tr.entry(tc, "stop");
        Object object = this.lock;
        synchronized (object) {
            this.started = false;
            this.lock.notify();
        }
        Tr.exit(tc, "stop");
    }

    public void run() {
        Tr.entry(tc, "run");
        boolean bl = false;
        while (!bl) {
            ServerSession serverSession = null;
            try {
                serverSession = (ServerSession)this.serverSessionPool.getServerSession();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.NonASFConnectionConsumer.run", "106", this);
                Tr.event(tc, "Exception calling getServerSession", (Object)jMSException);
                serverSession = null;
            }
            if (serverSession != null) {
                try {
                    serverSession.startReceiveMsg(this.timeout);
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.NonASFConnectionConsumer.run", "128", this);
                    Tr.event(tc, "Exception starting non-ASF connection consumer ServerSession", (Object)jMSException);
                }
            } else {
                Tr.event(tc, "No ServerSessions available");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.started) continue;
            bl = true;
            Tr.event(tc, "Terminating NonASFConnectionConsumer thread");
        }
        Tr.exit(tc, "run");
    }
}

