/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.AsyncMessageRequest;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RequestLog
implements Serializable {
    private static final long serialVersionUID = -2389077433250237839L;
    protected static TraceComponent tc = Tr.register(RequestLog.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private int idCounter = 0;
    private Hashtable requestsByID = new Hashtable();
    private Hashtable requestsByListenerPort = new Hashtable();

    public RequestLog() {
        Tr.entry(tc, "RequestLog");
        Tr.exit(tc, "RequestLog");
    }

    public void commitAllRequests() {
        Tr.entry(tc, "commitAllRequests");
        Iterator iterator = this.requestsByID.values().iterator();
        while (iterator.hasNext()) {
            AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)iterator.next();
            if (asyncMessageRequest.isCommitted()) continue;
            asyncMessageRequest.setRegisterTime();
            asyncMessageRequest.setStateCommitted();
        }
        Tr.exit(tc, "commitAllRequests");
    }

    public String addRequest(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry(tc, "addRequest", asyncMessageRequest);
        String string = this.getUniqueRequestID();
        asyncMessageRequest.setRequestID(string);
        this.requestsByID.put(string, asyncMessageRequest);
        this.addToListenerPortList(asyncMessageRequest);
        Tr.exit(tc, "addRequest", string);
        return string;
    }

    public void commitRequest(String string) {
        Tr.entry(tc, "commitRequest", string);
        AsyncMessageRequest asyncMessageRequest = (AsyncMessageRequest)this.requestsByID.get(string);
        if (asyncMessageRequest == null) {
            Tr.event(tc, "Prepared async message request not found", string);
        } else {
            asyncMessageRequest.setRegisterTime();
            asyncMessageRequest.setStateCommitted();
        }
        Tr.exit(tc, "commitRequest");
    }

    public void removeRequest(String string) {
        Tr.entry(tc, "removeRequest", string);
        Object v = this.requestsByID.remove(string);
        if (v == null) {
            Tr.event(tc, "request not found in log", string);
        } else {
            this.removeFromListenerPortList((AsyncMessageRequest)v);
        }
        Tr.exit(tc, "removeRequest");
    }

    public synchronized List getListenerPortListClone(String string) {
        Tr.entry(tc, "getListenerPortListClone", string);
        List list = null;
        Vector vector = (Vector)this.requestsByListenerPort.get(string);
        if (vector != null) {
            list = (List)vector.clone();
        }
        Tr.exit(tc, "getListenerPortListClone", list);
        return list;
    }

    private synchronized void addToListenerPortList(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry(tc, "addToListenerPortList", asyncMessageRequest);
        Vector<AsyncMessageRequest> vector = (Vector<AsyncMessageRequest>)this.requestsByListenerPort.get(asyncMessageRequest.getListenerPortName());
        if (vector == null) {
            vector = new Vector<AsyncMessageRequest>();
            this.requestsByListenerPort.put(asyncMessageRequest.getListenerPortName(), vector);
        }
        vector.add(asyncMessageRequest);
        Tr.exit(tc, "addToListenerPortList");
    }

    private synchronized void removeFromListenerPortList(AsyncMessageRequest asyncMessageRequest) {
        Tr.entry(tc, "removeFromListenerPortList", asyncMessageRequest);
        List list = (List)this.requestsByListenerPort.get(asyncMessageRequest.getListenerPortName());
        if (list == null) {
            Tr.event(tc, "no listener port list for request", asyncMessageRequest.getListenerPortName());
        } else {
            list.remove(asyncMessageRequest);
            if (list.size() == 0) {
                this.requestsByListenerPort.remove(asyncMessageRequest.getListenerPortName());
            }
        }
        Tr.exit(tc, "removeFromListenerPortList");
    }

    private synchronized String getUniqueRequestID() {
        Tr.entry(tc, "getUniqueRequestID");
        this.idCounter = (this.idCounter + 1) % Integer.MAX_VALUE;
        String string = Integer.toString(this.idCounter);
        while (this.requestsByID.contains(string)) {
            this.idCounter = (this.idCounter + 1) % Integer.MAX_VALUE;
            string = Integer.toString(this.idCounter);
        }
        Tr.exit(tc, "getUniqueRequestID", string);
        return string;
    }
}

