/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.container.MessageDrivenBeanO;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.jms.AccessorForNonASFMessageListener;
import com.ibm.ejs.jms.JMSConnectionHandle;
import com.ibm.ejs.jms.JMSQueueConnectionHandle;
import com.ibm.ejs.jms.JMSRequestMetrics;
import com.ibm.ejs.jms.JMSSessionHandle;
import com.ibm.ejs.jms.JMSTopicConnectionHandle;
import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListenerManagerImpl;
import com.ibm.ejs.jms.listener.MDBWrapper;
import com.ibm.ejs.jms.listener.ServerSessionPool;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ConnectionHandleAccessorImpl;
import com.ibm.ws.util.ThreadPool;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.transaction.Synchronization;

public class ServerSession
implements javax.jms.ServerSession,
Synchronization,
Runnable {
    protected static final TraceComponent tc = Tr.register(ServerSession.class, "Messaging", "com.ibm.ejs.jms.messaging");
    protected static final TraceComponent ltc_tc = Tr.register("ServerSessionMDBLTCtrace", "MDB", "com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    private static boolean zOS = System.getProperty("os.name").equals("OS/390") || System.getProperty("os.name").equals("z/OS");
    ServerSessionPool serverSessionPool = null;
    boolean isQueue;
    boolean isUnifiedConn;
    boolean globalTransRequired;
    boolean nonASFLocalTransRequired = false;
    int ackMode;
    int maxRetries = 0;
    boolean runException;
    boolean transRolledback;
    Connection jmsConn = null;
    Destination jmsDest = null;
    Session jmsSession = null;
    MDBWrapper mdbWrapper = null;
    MessageListener mdbRef = null;
    MDBConfigData mdbConfig = null;
    ThreadPool sessionThreadPool = null;
    protected static ThreadLocal thisServerSession = new ThreadLocal();
    protected String msgSelector = null;
    protected Hashtable requestIDs = null;
    private boolean nonASFListener = false;
    private int nonASFReceiveTimeout;
    private MessageConsumer nonASFConsumer = null;
    private JMSException nonASFFailure = null;
    protected boolean preRunEnlist = true;
    protected boolean zOSBMT = false;
    private boolean jmsWrapper = true;
    private long timeOfLastRun = System.currentTimeMillis();
    private final Object timeOfLastRunLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession(ServerSessionPool serverSessionPool, Connection connection, Destination destination, MessageListener messageListener, MDBConfigData mDBConfigData, int n, ThreadPool threadPool) throws MDBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ServerSession", new Object[]{serverSessionPool, connection, destination, messageListener, mDBConfigData, new Integer(n), threadPool});
        }
        this.serverSessionPool = serverSessionPool;
        this.jmsDest = destination;
        this.mdbRef = messageListener;
        this.mdbConfig = mDBConfigData;
        this.maxRetries = n;
        this.sessionThreadPool = threadPool;
        this.jmsConn = connection;
        try {
            Object object;
            this.jmsWrapper = connection instanceof JMSConnectionHandle;
            this.nonASFListener = serverSessionPool.getMDBListener().isNonASFListener();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "nonASFListener is set to " + this.nonASFListener);
            }
            this.isQueue = this.jmsDest instanceof Queue && this.jmsDest instanceof Topic ? this.mdbConfig.inputPort.JMSDestinationType == 0 : this.jmsDest instanceof Queue;
            this.isUnifiedConn = !(connection instanceof QueueConnection) && !(connection instanceof TopicConnection);
            if (this.mdbConfig.transactionType == 1) {
                this.globalTransRequired = this.mdbConfig.onMessageTransactionAttr == 0;
                this.ackMode = zOS && !this.globalTransRequired ? -2 : 1;
            } else {
                this.globalTransRequired = false;
                boolean bl = serverSessionPool.getMDBListener().getNonASFBMTRollbackEnabled();
                if (this.nonASFListener && bl) {
                    this.nonASFLocalTransRequired = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "nonASFLocalTransRequired is set to " + this.nonASFLocalTransRequired);
                    Tr.debug(tc, "nonASFBMTRollbackEnabled is set to " + bl);
                }
                this.ackMode = !this.nonASFListener && zOS ? -1 : (this.mdbConfig.inputPort.JMSAcknowledgement == 1 ? 3 : 1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ackMode is set to " + this.ackMode);
            }
            LocalTransactionCurrent localTransactionCurrent = null;
            boolean bl = false;
            try {
                localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                object = localTransactionCurrent.getLocalTranCoord();
                if (object == null) {
                    localTransactionCurrent.begin();
                    bl = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.MDBListenerImpl.createResources", "152", this);
                Tr.event(tc, "Exception beginning local transaction:", exception);
                throw exception;
            }
            object = ConnectionHandleAccessorImpl.getConnectionHandleAccessor().getThreadContext();
            object.beginContext(new HandleList());
            try {
                this.jmsSession = this.jmsWrapper ? (this.isUnifiedConn ? ((JMSConnectionHandle)connection).createListenerSession(this.ackMode, this.globalTransRequired, this.nonASFLocalTransRequired) : (this.isQueue ? ((JMSQueueConnectionHandle)connection).createListenerQueueSession(this.ackMode, this.globalTransRequired, this.nonASFLocalTransRequired) : ((JMSTopicConnectionHandle)connection).createListenerTopicSession(this.ackMode, this.globalTransRequired, this.nonASFLocalTransRequired))) : (this.isUnifiedConn ? connection.createSession(this.globalTransRequired, this.ackMode) : (this.isQueue ? ((QueueConnection)connection).createQueueSession(this.globalTransRequired, this.ackMode) : ((TopicConnection)connection).createTopicSession(this.globalTransRequired, this.ackMode)));
                if (zOS && this.mdbConfig.transactionType == 0) {
                    this.zOSBMT = true;
                    this.preRunEnlist = false;
                } else {
                    this.preRunEnlist = !this.jmsWrapper || this.nonASFListener || this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled() ? true : ((JMSSessionHandle)this.jmsSession).isPreASFRunEnlist();
                }
                this.mdbWrapper = new MDBWrapper(this.mdbConfig, this.mdbRef, this.preRunEnlist, this.jmsDest, this.jmsSession);
                if (!this.nonASFListener && !this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                    this.jmsSession.setMessageListener((MessageListener)this.mdbWrapper);
                }
                if (this.nonASFListener) {
                    this.nonASFConsumer = this.isUnifiedConn ? (this.isQueue || this.mdbConfig.inputPort.JMSSubscriptionDurability == 0 ? this.jmsSession.createConsumer(this.jmsDest, this.mdbConfig.inputPort.JMSMessageSelector) : this.jmsSession.createDurableSubscriber((Topic)this.jmsDest, this.mdbConfig.inputPort.JMSSubscriptionName, this.mdbConfig.inputPort.JMSMessageSelector, false)) : (this.isQueue ? ((QueueSession)this.jmsSession).createReceiver((Queue)this.jmsDest, this.mdbConfig.inputPort.JMSMessageSelector) : (this.mdbConfig.inputPort.JMSSubscriptionDurability == 0 ? ((TopicSession)this.jmsSession).createSubscriber((Topic)this.jmsDest, this.mdbConfig.inputPort.JMSMessageSelector, false) : ((TopicSession)this.jmsSession).createDurableSubscriber((Topic)this.jmsDest, this.mdbConfig.inputPort.JMSSubscriptionName, this.mdbConfig.inputPort.JMSMessageSelector, false)));
                }
            }
            finally {
                try {
                    LocalTransactionCoordinator localTransactionCoordinator;
                    if (bl && (localTransactionCoordinator = localTransactionCurrent.getLocalTranCoord()) != null) {
                        localTransactionCoordinator.complete(0);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession", "216", this);
                    Tr.event(tc, "Exception completing local transaction:", exception);
                }
                if (object != null) {
                    object.endContext();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.ServerSession", "173", this);
            Tr.warning(tc, "ServerSessionCreateException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), MDBListenerManagerImpl.getNestedException(exception).getMessage()});
            Tr.debug(tc, "Exception:", exception);
            MDBException mDBException = new MDBException(MDBListenerManagerImpl.getNestedException(exception).getMessage(), exception);
            Tr.exit(tc, "ServerSession");
            throw mDBException;
        }
        Tr.exit(tc, "ServerSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Tr.entry(tc, "close");
        try {
            try {
                if (this.nonASFConsumer != null) {
                    this.nonASFConsumer.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.close", "271", this);
            }
            try {
                if (this.jmsSession != null) {
                    this.jmsSession.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.close", "201", this);
            }
        }
        finally {
            this.nonASFConsumer = null;
            this.jmsSession = null;
        }
        Tr.exit(tc, "close");
    }

    public Session getSession() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSession");
        }
        Session session = ((JMSSessionHandle)this.jmsSession).getSession();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSession", session);
        }
        return session;
    }

    public static Session getSessionHandle() {
        Tr.entry(tc, "getSessionHandle");
        Session session = null;
        ServerSession serverSession = (ServerSession)thisServerSession.get();
        if (serverSession != null) {
            session = serverSession.jmsSession;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionHandle", session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            String string;
            String string2;
            Properties properties;
            Object object;
            Tr.entry(tc, "run");
            this.runException = false;
            this.nonASFFailure = null;
            this.transRolledback = false;
            this.mdbWrapper.setLastFailedDeliveryCount(0);
            this.mdbWrapper.setRMObject(null);
            try {
                try {
                    thisServerSession.set(this);
                    if (this.preRunEnlist) {
                        this.mdbRef.onMessage(null);
                    } else {
                        this.connectionConsumerOnMessage(null);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.run", "283", this);
                    if (!this.runException) {
                        Tr.warning(tc, "JMSSessionRunException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
                    }
                    this.runException = true;
                }
                Object var3_4 = null;
                thisServerSession.set(null);
                this.msgSelector = null;
                this.requestIDs = null;
                object = this.mdbWrapper.getRMObject();
                if (object == null) break block24;
                properties = new Properties();
                string2 = this.mdbWrapper.getDestinationName();
                string = this.mdbConfig.inputPort.JMSMessageSelector;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                thisServerSession.set(null);
                this.msgSelector = null;
                this.requestIDs = null;
                Object object2 = this.mdbWrapper.getRMObject();
                if (object2 != null) {
                    Properties properties2 = new Properties();
                    String string3 = this.mdbWrapper.getDestinationName();
                    String string4 = this.mdbConfig.inputPort.JMSMessageSelector;
                    int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_MDB_ID);
                    switch (n) {
                        case 2: 
                        case 3: {
                            properties2.put("DestinationName", string3);
                            properties2.put("MethodSelector", string4);
                        }
                    }
                    int n2 = this.transRolledback || this.runException ? 2 : 0;
                    JMSRequestMetrics.postMDBConsumeMessage(object2, n2, properties2);
                }
                throw throwable;
            }
            int n = JMSRequestMetrics.getTransactionTraceLevel(JMSRequestMetrics.JMS_COMPONENT_MDB_ID);
            switch (n) {
                case 2: 
                case 3: {
                    properties.put("DestinationName", string2);
                    properties.put("MethodSelector", string);
                }
            }
            int n3 = this.transRolledback || this.runException ? 2 : 0;
            JMSRequestMetrics.postMDBConsumeMessage(object, n3, properties);
            {
            }
        }
        if ((this.transRolledback || this.runException) && this.mdbWrapper.getLastFailedDeliveryCount() > this.maxRetries) {
            this.serverSessionPool.markPoolAsClosed();
            if (zOS) {
                Tr.audit(tc, "JMSRetryLimitReached", new Object[]{new Integer(this.maxRetries), this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
            } else {
                Tr.warning(tc, "JMSRetryLimitReached", new Object[]{new Integer(this.maxRetries), this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName()});
            }
            this.stopLPAsynch();
        }
        if (this.nonASFFailure != null) {
            try {
                ExceptionListener exceptionListener = this.jmsConn.getExceptionListener();
                if (exceptionListener != null) {
                    exceptionListener.onException(this.nonASFFailure);
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.listener.ServerSession.run", "420", this);
                Tr.debug(tc, "Unable to enter recovery mode", (Object)this.nonASFFailure);
            }
            finally {
                this.nonASFFailure = null;
            }
        }
        this.serverSessionPool.putServerSession(this);
        Tr.exit(tc, "run");
    }

    public static void dispatch(Object object) throws Exception {
        Tr.entry(tc, "Dispatch");
        MessageDrivenBeanO messageDrivenBeanO = (MessageDrivenBeanO)object;
        ServerSession serverSession = (ServerSession)thisServerSession.get();
        serverSession.onMessage(messageDrivenBeanO);
        Tr.exit(tc, "Dispatch");
    }

    public void onMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onMessage", messageDrivenBeanO);
        }
        if (!this.nonASFListener) {
            ((JMSSessionHandle)this.jmsSession).enlist();
        }
        if (this.preRunEnlist) {
            if (this.mdbConfig.msgListenerPort.getAsyncMessageConsumerEnabled()) {
                this.asyncMessageConsumerOnMessage(messageDrivenBeanO);
            } else if (this.nonASFListener) {
                this.nonASFConsumerOnMessage(messageDrivenBeanO);
            } else {
                this.connectionConsumerOnMessage(messageDrivenBeanO);
            }
        } else {
            if (this.globalTransRequired) {
                TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
            }
            this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
            this.mdbWrapper.callOnMessage();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onMessage");
        }
    }

    public void asyncMessageConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "asyncMessageConsumerOnMessage", messageDrivenBeanO);
        }
        if (!this.isQueue) {
            Tr.event(tc, "Illegal use of async message consumer for a JMS Topic");
            if (this.globalTransRequired) {
                messageDrivenBeanO.setRollbackOnly();
            }
        } else {
            try {
                QueueReceiver queueReceiver = ((QueueSession)this.jmsSession).createReceiver((Queue)this.jmsDest, this.msgSelector);
                Message message = queueReceiver.receiveNoWait();
                if (message != null) {
                    if (this.globalTransRequired) {
                        TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                    }
                    this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
                    this.mdbWrapper.onMessage(message);
                    this.serverSessionPool.getMDBListener().getAsyncMessageLog().removeRequest((String)this.requestIDs.get(message.getJMSCorrelationID()));
                } else if (this.globalTransRequired) {
                    messageDrivenBeanO.setRollbackOnly();
                }
                queueReceiver.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.asyncMessageConsumerOnMessage", "418", this);
                Tr.warning(tc, "JMSSessionRunException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                this.runException = true;
                try {
                    if (this.globalTransRequired) {
                        messageDrivenBeanO.setRollbackOnly();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.asyncMessageConsumerOnMessage", "434", this);
                    Tr.warning(tc, "RollbackException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                }
                if (!this.globalTransRequired && this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                    this.mdbConfig.pmiBean.messageBackedOut();
                }
                Tr.exit(tc, "asyncMessageConsumerOnMessage");
                throw exception;
            }
        }
        Tr.exit(tc, "asyncMessageConsumerOnMessage");
    }

    /*
     * Loose catch block
     */
    public void nonASFConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        block31: {
            boolean bl;
            block29: {
                block30: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "nonASFConsumerOnMessage", messageDrivenBeanO);
                    }
                    bl = false;
                    Message message = null;
                    message = this.nonASFLocalTransRequired ? AccessorForNonASFMessageListener.receiveWithoutEnlist(this.nonASFConsumer, this.nonASFReceiveTimeout) : this.nonASFConsumer.receive((long)this.nonASFReceiveTimeout);
                    if (message != null) {
                        if (this.globalTransRequired) {
                            TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                        }
                        this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
                        this.mdbWrapper.onMessage(message);
                    }
                    bl = true;
                    Object var7_4 = null;
                    if (!this.nonASFLocalTransRequired) break block29;
                    if (!bl) break block30;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Committing the transacted session");
                        }
                        AccessorForNonASFMessageListener.commitInAnyContext(this.jmsSession);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "586", this);
                        Tr.warning(tc, "PostInvokeException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    }
                    break block29;
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Rolling back the transacted session");
                    }
                    AccessorForNonASFMessageListener.rollbackInAnyContext(this.jmsSession);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "587", this);
                    Tr.warning(tc, "RollbackException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nonASFConsumerOnMessage");
            }
            break block31;
            {
                catch (Exception exception) {
                    if (exception instanceof JMSException) {
                        this.nonASFFailure = (JMSException)((Object)exception);
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "569", this);
                    Tr.warning(tc, "JMSSessionRunException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    this.runException = true;
                    try {
                        if (this.globalTransRequired) {
                            messageDrivenBeanO.setRollbackOnly();
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "585", this);
                        Tr.warning(tc, "RollbackException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                    }
                    if (!this.globalTransRequired && this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                        this.mdbConfig.pmiBean.messageBackedOut();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (this.nonASFLocalTransRequired) {
                    if (bl) {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Committing the transacted session");
                            }
                            AccessorForNonASFMessageListener.commitInAnyContext(this.jmsSession);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "586", this);
                            Tr.warning(tc, "PostInvokeException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                        }
                    } else {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Rolling back the transacted session");
                            }
                            AccessorForNonASFMessageListener.rollbackInAnyContext(this.jmsSession);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.nonASFConsumerOnMessage", "587", this);
                            Tr.warning(tc, "RollbackException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "nonASFConsumerOnMessage");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionConsumerOnMessage(MessageDrivenBeanO messageDrivenBeanO) throws Exception {
        block27: {
            LocalTransactionCoordinator localTransactionCoordinator;
            LocalTransactionCoordinator localTransactionCoordinator2;
            block28: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "connectionConsumerOnMessage", messageDrivenBeanO);
                }
                LocalTransactionCurrent localTransactionCurrent = null;
                localTransactionCoordinator2 = null;
                localTransactionCoordinator = null;
                boolean bl = false;
                try {
                    try {
                        if (this.preRunEnlist) {
                            if (this.globalTransRequired) {
                                TransactionManagerFactory.getTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
                            }
                            this.mdbWrapper.setMessageListener((MessageListener)messageDrivenBeanO.messageDrivenBean);
                        }
                        if (this.zOSBMT) {
                            localTransactionCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                            localTransactionCoordinator2 = localTransactionCurrent.getLocalTranCoord();
                            if (localTransactionCoordinator2 == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Begin LTC for message consume");
                                }
                                localTransactionCurrent.begin();
                                localTransactionCoordinator2 = localTransactionCurrent.getLocalTranCoord();
                                bl = true;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Throwing IllegalStateException.");
                                }
                                Tr.error(ltc_tc, "ERR_BEGIN_LTC_ACT");
                                throw new IllegalStateException("LTC already active in ServerSession.connectionConsumerOnMessage()");
                            }
                        }
                        this.jmsSession.run();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSession.connectionConsumerOnMessage", "450", this);
                        Tr.warning(tc, "JMSSessionRunException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                        this.runException = true;
                        if (this.preRunEnlist) {
                            try {
                                if (this.globalTransRequired) {
                                    messageDrivenBeanO.setRollbackOnly();
                                }
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.connectionConsumerOnMessage", "466", this);
                                Tr.warning(tc, "RollbackException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), exception});
                            }
                        }
                        if (!this.globalTransRequired && this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                            this.mdbConfig.pmiBean.messageBackedOut();
                        }
                        Tr.exit(tc, "connectionConsumerOnMessage");
                        throw exception;
                    }
                    Object var9_6 = null;
                    if (!bl) break block27;
                    localTransactionCoordinator = localTransactionCurrent.getLocalTranCoord();
                    if (localTransactionCoordinator != null) break block28;
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    if (bl) {
                        localTransactionCoordinator = localTransactionCurrent.getLocalTranCoord();
                        if (localTransactionCoordinator == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "LTC for message consume doesn't exist. Throw IllegalStateException");
                            }
                            Tr.error(ltc_tc, "ERR_NO_LTC_COMPLETE");
                            throw new IllegalStateException("LTC not present at end of ServerSession.connectionConsumerOnMessage()");
                        }
                        if (!localTransactionCoordinator.equals(localTransactionCoordinator2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "LTC present at end of message consume is not the right one. Throw IllegalStateException");
                            }
                            Tr.error(ltc_tc, "ERR_NP_ILLEGAL");
                            throw new IllegalStateException("LTC: present at end of ServerSession.connectionConsumerOnMessage() is not the right one. LTC present at end =" + localTransactionCoordinator);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Complete LTC for message consume");
                        }
                        localTransactionCoordinator.complete(1);
                    }
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LTC for message consume doesn't exist. Throw IllegalStateException");
                }
                Tr.error(ltc_tc, "ERR_NO_LTC_COMPLETE");
                throw new IllegalStateException("LTC not present at end of ServerSession.connectionConsumerOnMessage()");
            }
            if (!localTransactionCoordinator.equals(localTransactionCoordinator2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LTC present at end of message consume is not the right one. Throw IllegalStateException");
                }
                Tr.error(ltc_tc, "ERR_NP_ILLEGAL");
                throw new IllegalStateException("LTC: present at end of ServerSession.connectionConsumerOnMessage() is not the right one. LTC present at end =" + localTransactionCoordinator);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Complete LTC for message consume");
            }
            localTransactionCoordinator.complete(1);
        }
        Tr.exit(tc, "connectionConsumerOnMessage");
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Integer(n));
        }
        if (n != 3) {
            this.transRolledback = true;
            if (this.mdbWrapper.getJMSXDeliveryCount() > this.mdbWrapper.getLastFailedDeliveryCount()) {
                this.mdbWrapper.setLastFailedDeliveryCount(this.mdbWrapper.getJMSXDeliveryCount());
            }
            if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                this.mdbConfig.pmiBean.messageBackedOut();
            }
        }
        Tr.exit(tc, "afterCompletion");
    }

    public void start() throws JMSException {
        Tr.entry(tc, "start");
        try {
            this.sessionThreadPool.execute(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.start", "521", this);
            Tr.warning(tc, "JMSServerSessionStartException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit(tc, "start");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit(tc, "start");
    }

    public void startReceiveMsgNoWait(String string, Hashtable hashtable) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startReceiveMsgNoWait", new Object[]{string, hashtable});
        }
        try {
            this.msgSelector = string;
            this.requestIDs = hashtable;
            this.sessionThreadPool.execute(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.startReceiveMsgNoWait", "552", this);
            Tr.warning(tc, "JMSServerSessionStartException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit(tc, "startReceiveMsgNoWait");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit(tc, "startReceiveMsgNoWait");
    }

    public void startReceiveMsg(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startReceiveMsg", new Integer(n));
        }
        try {
            this.nonASFReceiveTimeout = n;
            this.sessionThreadPool.execute(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.listener.ServerSession.startReceiveMsg", "787", this);
            Tr.warning(tc, "JMSServerSessionStartException", new Object[]{this.mdbConfig.mdbName, this.mdbConfig.msgListenerPort.getJmsDestJNDIName(), throwable});
            Tr.exit(tc, "startReceiveMsgNoWait");
            throw new JMSException(MDBListenerManagerImpl.getNestedException(throwable).getMessage());
        }
        Tr.exit(tc, "startReceiveMsg");
    }

    public void stopLPAsynch() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stopping listener port on seperate thread");
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    ServerSession.this.mdbConfig.msgListenerPort.stop();
                }
                catch (Throwable throwable) {
                    Tr.debug(tc, "Exception stopping Listener Port", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeOfLastRun() {
        Object object = this.timeOfLastRunLock;
        synchronized (object) {
            return this.timeOfLastRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeOfLastRun(long l) {
        Object object = this.timeOfLastRunLock;
        synchronized (object) {
            this.timeOfLastRun = l;
        }
    }
}

