/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.MDBConfigData;
import com.ibm.ejs.jms.listener.MDBException;
import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.jms.listener.MDBPool;
import com.ibm.ejs.jms.listener.ServerSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.WSThreadLocal;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public class ServerSessionPool
implements javax.jms.ServerSessionPool {
    protected static final TraceComponent tc = Tr.register(ServerSessionPool.class, "Messaging", "com.ibm.ejs.jms.messaging");
    MDBListenerImpl mdbListener = null;
    boolean closed = false;
    boolean closing = false;
    int maxSessions = 0;
    int maxRetries = 0;
    Connection jmsConn = null;
    Destination jmsDest = null;
    MDBPool mdbPool = null;
    MessageListener mdbRef = null;
    MDBConfigData mdbConfig = null;
    ThreadPool sessionThreadPool = null;
    Vector serverSessions = new Vector();
    Stack freeSessions = new Stack();
    private static WSThreadLocal inFlightNewServerSessions = new WSThreadLocal();
    Object newServerSessionLock = new Object();
    int numberOfNewServerSessionWaiters = 0;
    boolean closeWaiting = false;

    public ServerSessionPool(MDBListenerImpl mDBListenerImpl, Connection connection, Destination destination, MDBPool mDBPool, MDBConfigData mDBConfigData, int n, int n2, ThreadPool threadPool) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ServerSessionPool", new Object[]{mDBListenerImpl, connection, destination, mDBPool, mDBConfigData, new Integer(n), new Integer(n2), threadPool});
        }
        this.mdbListener = mDBListenerImpl;
        this.closed = false;
        this.jmsConn = connection;
        this.jmsDest = destination;
        this.mdbPool = mDBPool;
        this.mdbRef = mDBPool.getMDB();
        this.mdbConfig = mDBConfigData;
        this.maxSessions = n;
        this.maxRetries = n2;
        this.sessionThreadPool = threadPool;
        Tr.exit(tc, "ServerSessionPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Tr.entry(tc, "close");
        Vector vector = this.serverSessions;
        synchronized (vector) {
            this.closed = true;
            this.serverSessions.notifyAll();
            this.closeWaiting = true;
            while (this.serverSessions.size() > 0) {
                while (!this.freeSessions.empty()) {
                    ServerSession serverSession = (ServerSession)this.freeSessions.pop();
                    serverSession.close();
                    this.serverSessions.remove(serverSession);
                }
                if (this.mdbListener.isQuiesceComplete()) break;
                if (this.serverSessions.size() <= 0) continue;
                try {
                    this.serverSessions.wait(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.closeWaiting = false;
            try {
                if (this.mdbRef != null) {
                    this.mdbPool.returnMDB(this.mdbRef);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSessionPool.close", "140", this);
                Tr.event(tc, "Exception returning MDB reference", exception);
            }
            this.mdbRef = null;
        }
        Tr.exit(tc, "close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void softClose() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "softClose");
        }
        boolean bl = true;
        Object object2 = this.newServerSessionLock;
        synchronized (object2) {
            this.closed = true;
            bl = this.anotherThreadInNewServerSession();
        }
        boolean bl2 = true;
        while (bl) {
            try {
                if (bl2) {
                    try {
                        this.jmsConn.wait(1000L);
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        bl2 = false;
                    }
                } else {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = this.newServerSessionLock;
            synchronized (object) {
                bl = this.anotherThreadInNewServerSession();
            }
        }
        object = this.serverSessions;
        synchronized (object) {
            this.serverSessions.notifyAll();
        }
        this.closeFreeSessions();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "softClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFreeSessions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeFreeSessions");
        }
        Vector vector = this.serverSessions;
        synchronized (vector) {
            while (!this.freeSessions.empty()) {
                ServerSession serverSession = (ServerSession)this.freeSessions.pop();
                serverSession.close();
                this.serverSessions.remove(serverSession);
            }
            if (this.serverSessions.size() == 0) {
                try {
                    if (this.mdbRef != null) {
                        this.mdbPool.returnMDB(this.mdbRef);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.listener.ServerSessionPool.closeFreeSessions", "213", this);
                    Tr.event(tc, "Exception returning MDB reference", exception);
                }
                this.mdbRef = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeFreeSessions");
        }
    }

    public MDBListenerImpl getMDBListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMDBListener");
            Tr.exit(tc, "getMDBListener");
        }
        return this.mdbListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jms.ServerSession getServerSession() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSession");
        }
        ServerSession serverSession = null;
        Vector vector = this.serverSessions;
        synchronized (vector) {
            long l = 0L;
            if (this.closed || this.closing) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerSession");
                }
                throw new IllegalStateException("ServerSessionPool closed or closing");
            }
            if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                l = this.mdbConfig.pmiBean.waitingForServerSession();
            }
            if (!this.freeSessions.empty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting a free ServerSession from the pool");
                }
                serverSession = (ServerSession)this.freeSessions.pop();
            } else {
                if (this.serverSessions.size() < this.maxSessions) {
                    if (this.closed || this.closing) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getServerSession");
                        }
                        throw new IllegalStateException("ServerSessionPool closed or closing");
                    }
                    this.newServerSessionBegin();
                    try {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Allocating a new ServerSession");
                            }
                            serverSession = this.createServerSession();
                        }
                        catch (MDBException mDBException) {
                            FFDCFilter.processException((Throwable)mDBException, "com.ibm.ejs.jms.listener.ServerSessionPool.getServerSession", "181", this);
                            throw new JMSException(mDBException.getMessage());
                        }
                        this.serverSessions.add(serverSession);
                    }
                    finally {
                        this.newServerSessionEnd();
                    }
                }
                while (this.freeSessions.empty()) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for a new ServerSession to become available");
                        }
                        this.serverSessions.wait();
                        if (!this.closed && !this.closing) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getServerSession");
                        }
                        throw new IllegalStateException("ServerSessionPool closed or closing");
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.jms.listener.ServerSessionPool.getServerSession", "203", this);
                    }
                }
                serverSession = (ServerSession)this.freeSessions.pop();
            }
            if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                this.mdbConfig.pmiBean.gotServerSession(l);
                int n = this.serverSessions.size();
                this.mdbConfig.pmiBean.serverSessionRetrieve(n - this.freeSessions.size(), n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerSession", serverSession);
        }
        return serverSession;
    }

    public ServerSession createServerSession() throws MDBException {
        return new ServerSession(this, this.jmsConn, this.jmsDest, this.mdbRef, this.mdbConfig, this.maxRetries, this.sessionThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putServerSession(ServerSession serverSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putServerSession", serverSession);
        }
        serverSession.setTimeOfLastRun(System.currentTimeMillis());
        Vector vector = this.serverSessions;
        synchronized (vector) {
            this.freeSessions.push(serverSession);
            if (this.mdbConfig.pmiFactory != null && this.mdbConfig.pmiBean != null) {
                int n = this.serverSessions.size();
                this.mdbConfig.pmiBean.serverSessionReturn(n - this.freeSessions.size(), n);
            }
            this.serverSessions.notifyAll();
            if (this.closed && !this.closeWaiting) {
                this.closeFreeSessions();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putServerSession");
        }
    }

    public int getActiveSessionCount() {
        Tr.entry(tc, "getActiveSessionCount");
        int n = this.serverSessions.size() - this.freeSessions.size();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveSessionCount", new Integer(n));
        }
        return n;
    }

    public void markPoolAsClosed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markPoolAsClosed");
        }
        this.closed = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markPoolAsClosed");
        }
    }

    private boolean anotherThreadInNewServerSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "anotherThreadInNewServerSession", new Integer(this.numberOfNewServerSessionWaiters));
        }
        boolean bl = this.numberOfNewServerSessionWaiters != 0 && (this.numberOfNewServerSessionWaiters != 1 || inFlightNewServerSessions.get() == null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "anotherThreadInNewServerSession", new Boolean(bl));
        }
        return bl;
    }

    protected void newServerSessionBegin() {
        ++this.numberOfNewServerSessionWaiters;
        inFlightNewServerSessions.set(Boolean.TRUE);
    }

    protected void newServerSessionEnd() {
        --this.numberOfNewServerSessionWaiters;
        inFlightNewServerSessions.set((Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForOldSessions(Long l, long l2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForOldSessions", new Object[]{l, new Long(l2)});
        }
        long l3 = l;
        Vector vector = this.serverSessions;
        synchronized (vector) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server session pool contents: ", this.serverSessions);
            }
            Iterator iterator = this.freeSessions.iterator();
            while (iterator.hasNext()) {
                ServerSession serverSession = (ServerSession)iterator.next();
                long l4 = l2 - serverSession.getTimeOfLastRun();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking at server session:", new Object[]{serverSession, new Long(l4)});
                }
                if (l4 < l3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timing out server session.");
                }
                iterator.remove();
                this.serverSessions.remove(serverSession);
                serverSession.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForOldSessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setClosing");
        }
        Vector vector = this.serverSessions;
        synchronized (vector) {
            this.closing = true;
            this.serverSessions.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setClosing");
        }
    }
}

