/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.jms.listener.MDBListenerImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServerSessionPoolTimeoutManager
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(ServerSessionPoolTimeoutManager.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private int globalServerSessionPoolTimeout = -1;
    private HashMap serverSessionPoolTimeoutMap = new HashMap();
    private long serverSessionPoolReapInterval = -1L;
    private final HashMap lpToTimoutMap = new HashMap();
    private boolean started = false;
    private Alarm currentAlarm = null;

    public synchronized void initialize(int n, HashMap hashMap, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{new Integer(n), hashMap, new Integer(n2)});
        }
        this.globalServerSessionPoolTimeout = 1000 * n;
        this.serverSessionPoolTimeoutMap = hashMap;
        this.serverSessionPoolReapInterval = 1000 * n2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public synchronized void startMonitoringLP(MDBListenerImpl mDBListenerImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startMonitoringLP", mDBListenerImpl);
        }
        if (this.serverSessionPoolReapInterval > 0L) {
            String string = mDBListenerImpl.getListenerPortName();
            Integer n = (Integer)this.serverSessionPoolTimeoutMap.get(string);
            Long l = null;
            if (n == null) {
                if (this.globalServerSessionPoolTimeout >= 0) {
                    l = new Long(this.globalServerSessionPoolTimeout);
                }
            } else if (n >= 0) {
                l = new Long(n * 1000);
            }
            if (l != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enabled timeout for listener port: ", new Object[]{string, l});
                }
                this.lpToTimoutMap.put(mDBListenerImpl, l);
                if (!this.started) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Starting timer.");
                    }
                    this.currentAlarm = AlarmManager.createNonDeferrable(this.serverSessionPoolReapInterval, this);
                    this.started = true;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No timeout information found. Not monitoring listener port: ", string);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ignoring listener port as reap interval is not set.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitoringLP");
        }
    }

    public synchronized void stopMonitoringLP(MDBListenerImpl mDBListenerImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopMonitoringLP", mDBListenerImpl);
        }
        this.lpToTimoutMap.remove(mDBListenerImpl);
        if (this.lpToTimoutMap.size() == 0 && this.started && this.currentAlarm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stopping timer.");
            }
            this.currentAlarm.cancel();
            this.currentAlarm = null;
            this.started = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitoringLP");
        }
    }

    public synchronized void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        long l = System.currentTimeMillis();
        Set set = this.lpToTimoutMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MDBListenerImpl mDBListenerImpl = (MDBListenerImpl)entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking for timed-out server sessions for: ", mDBListenerImpl.getListenerPortName());
            }
            mDBListenerImpl.checkForOldSessions((Long)entry.getValue(), l);
        }
        if (this.started) {
            this.currentAlarm = AlarmManager.createNonDeferrable(this.serverSessionPoolReapInterval, this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

