/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mbmigrator;

import com.ibm.ejs.jms.mbmigrator.JMSConfigData;
import com.ibm.ejs.jms.mbmigrator.JMSListenerConfig;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JMSXMLConfigHandler
extends DefaultHandler {
    protected static TraceComponent tc = Tr.register(JMSXMLConfigHandler.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private static ResourceBundle msgBundle = null;
    private JMSListenerConfig jmsConfig = new JMSListenerConfig();
    private Locator docLocator = null;
    private JMSConfigData currentListener = null;
    private Stack currentElements = new Stack();
    private static final String HOME_JNDI_NAME = "HomeJNDIName";
    private static final String HOME_CLASS_NAME = "HomeClassName";
    private static final String REMOTE_CLASS_NAME = "RemoteClassName";
    private static final String JMS_CONNECTION_FACTORY = "JMSConnectionFactory";
    private static final String JMS_DESTINATION = "JMSDestination";
    private static final String JMS_DESTINATION_TYPE = "JMSDestinationType";
    private static final String STR_QUEUE_DESTINATION = "javax.jms.Queue";
    private static final String STR_TOPIC_DESTINATION = "javax.jms.Topic";
    private static final String JMS_SUBSCRIPTION_DURABILITY = "JMSSubscriptionDurability";
    private static final String STR_NON_DURABLE = "nondurable";
    private static final String STR_DURABLE = "durable";
    private static final String JMS_SUBSCRIPTION_NAME = "JMSSubscriptionName";
    private static final String JMS_MESSAGE_SELECTOR = "JMSMessageSelector";
    private static final String JMS_ACKNOWLEDGE_MODE = "JMSAcknowledgeMode";
    private static final String STR_AUTO_ACKNOWLEDGE = "auto-acknowledge";
    private static final String STR_DUPS_OK_ACKNOWLEDGE = "dups-ok-acknowledge";
    private static final String MAX_RETRIES = "MaxRetries";
    private static final String MAX_SESSIONS = "MaxSessions";
    private static final String TRANSACTIONAL = "Transactional";
    private static final String CONFIG = "Config";
    private static final String WORKER = "Worker";
    private static final String LISTENER = "Listener";
    private static final String POOLING = "Pooling";
    private static final String TIMEOUT = "Timeout";
    private static final String THRESHOLD = "Threshold";
    private String currentValue = null;
    private static final String[] TopLevelElements = new String[]{"Config"};
    private static final String[] ConfigElements = new String[]{"Listener", "Worker", "Pooling"};
    private static final String[] ListenerElements = new String[]{"HomeJNDIName", "HomeClassName", "RemoteClassName", "JMSConnectionFactory", "JMSDestination", "JMSDestinationType", "JMSSubscriptionDurability", "JMSSubscriptionName", "JMSMessageSelector", "JMSAcknowledgeMode", "MaxRetries", "MaxSessions", "Transactional"};
    private static final String[] PoolingElements = new String[]{"Timeout", "Threshold"};
    private Vector fatalErrors = new Vector();
    private Vector warnings = new Vector();
    private Vector errors = new Vector();

    public void characters(char[] cArray, int n, int n2) {
        Tr.entry(tc, "characters");
        String string = new String(cArray, n, n2);
        this.currentValue = string.trim();
        if (!this.currentElements.empty() && (this.currentElements.peek().equals(LISTENER) || this.currentElements.peek().equals(WORKER)) && this.currentListener.ListenerName.equals("")) {
            this.currentListener.ListenerName = this.currentValue;
        }
        Tr.exit(tc, "characters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXParseException {
        Tr.entry(tc, "endElement");
        if (!string2.equals("") && !this.validElement(string2)) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLUnknownEndElement", string2), this.docLocator);
        }
        if (this.currentElements.empty()) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLMissingStartElement", string2), this.docLocator);
        }
        if (!string2.equals("") && !string2.equals(this.currentElements.peek())) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLMissingStartElement", string2), this.docLocator);
        }
        string2 = (String)this.currentElements.peek();
        try {
            try {
                if (string2.equals(HOME_JNDI_NAME)) {
                    this.currentListener.EJBHomeJNDIName = this.currentValue;
                }
                if (string2.equals(HOME_CLASS_NAME)) {
                    this.currentListener.EJBHomeClassName = this.currentValue;
                }
                if (string2.equals(REMOTE_CLASS_NAME)) {
                    this.currentListener.EJBRemoteClassName = this.currentValue;
                }
                if (string2.equals(JMS_CONNECTION_FACTORY)) {
                    this.currentListener.JMSConnectionFactoryEnvRef = this.currentValue;
                }
                if (string2.equals(JMS_DESTINATION)) {
                    this.currentListener.JMSDestinationEnvRef = this.currentValue;
                }
                if (string2.equals(JMS_DESTINATION_TYPE)) {
                    if (this.currentValue.equals(STR_QUEUE_DESTINATION)) {
                        this.currentListener.destinationType = 0;
                    } else if (this.currentValue.equals(STR_TOPIC_DESTINATION)) {
                        this.currentListener.destinationType = 1;
                    } else {
                        throw new RuntimeException("invalid JMSDestinationType");
                    }
                }
                if (string2.equals(JMS_SUBSCRIPTION_DURABILITY)) {
                    if (this.currentValue.equals(STR_NON_DURABLE)) {
                        this.currentListener.subscriptionDurability = 0;
                    } else if (this.currentValue.equals(STR_DURABLE)) {
                        this.currentListener.subscriptionDurability = 1;
                    } else {
                        throw new RuntimeException("invalid JMSSubscriptionDurability");
                    }
                }
                if (string2.equals(JMS_SUBSCRIPTION_NAME)) {
                    this.currentListener.subscriptionName = this.currentValue;
                }
                if (string2.equals(JMS_MESSAGE_SELECTOR)) {
                    this.currentListener.messageSelector = this.currentValue;
                }
                if (string2.equals(JMS_ACKNOWLEDGE_MODE)) {
                    if (this.currentValue.equals(STR_AUTO_ACKNOWLEDGE)) {
                        this.currentListener.acknowledgement = 0;
                    } else if (this.currentValue.equals(STR_DUPS_OK_ACKNOWLEDGE)) {
                        this.currentListener.acknowledgement = 1;
                    } else {
                        throw new RuntimeException("invalid JMSAcknowledgeMode");
                    }
                }
                if (string2.equals(MAX_RETRIES)) {
                    this.currentListener.maxRetries = Integer.valueOf(this.currentValue);
                }
                if (string2.equals(MAX_SESSIONS)) {
                    this.currentListener.maxSessions = Integer.valueOf(this.currentValue);
                }
                if (string2.equals(TRANSACTIONAL)) {
                    if (this.currentValue.compareToIgnoreCase("true") != 0 && this.currentValue.compareToIgnoreCase("false") != 0) {
                        throw new RuntimeException("invalid Transactional");
                    }
                    this.currentListener.transactional = Boolean.valueOf(this.currentValue);
                }
                if (string2.equals(TIMEOUT)) {
                    if (Integer.valueOf(this.currentValue) < 0) {
                        throw new RuntimeException("invalid Timeout");
                    }
                    this.jmsConfig.setPoolingTimeout(Integer.valueOf(this.currentValue));
                }
                if (string2.equals(THRESHOLD)) {
                    if (Integer.valueOf(this.currentValue) < 0) {
                        throw new RuntimeException("invalid Threshold");
                    }
                    this.jmsConfig.setPoolingThreshold(Integer.valueOf(this.currentValue));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mbmigrator.JMSXMLConfigHandler.endElement", "197", this);
                throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLInvalidValue", new Object[]{this.currentValue, string2}), this.docLocator);
            }
            if (string2.equals(LISTENER) || string2.equals(WORKER)) {
                String string4 = new String("");
                if (this.currentListener.EJBHomeJNDIName == null) {
                    string4 = string4 + "<HomeJNDIName>, ";
                }
                if (this.currentListener.JMSConnectionFactoryEnvRef == null) {
                    string4 = string4 + "<JMSConnectionFactory>, ";
                }
                if (this.currentListener.JMSDestinationEnvRef == null) {
                    string4 = string4 + "<JMSDestination>, ";
                }
                if (this.currentListener.subscriptionDurability == 1 && this.currentListener.subscriptionName == null) {
                    string4 = string4 + "<JMSSubscriptionName>, ";
                }
                if (!string4.equals("")) {
                    this.currentListener = null;
                    throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLMustSpecify", string4), this.docLocator);
                }
                this.jmsConfig.add(this.currentListener);
                this.currentListener = null;
            }
        }
        finally {
            this.currentValue = null;
            this.currentElements.pop();
        }
        Tr.exit(tc, "endElement");
    }

    public JMSListenerConfig getJMSConfig() {
        Tr.entry(tc, "getJMSConfig");
        Tr.exit(tc, "getJMSConfig");
        return this.jmsConfig;
    }

    public void setDocumentLocator(Locator locator) {
        Tr.entry(tc, "setDocumentLocator");
        this.docLocator = locator;
        Tr.exit(tc, "setDocumentLocator");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXParseException {
        Tr.entry(tc, "startElement");
        if (!this.validElement(string3)) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLUnknownStartElement", string3), this.docLocator);
        }
        if (this.currentElements.empty() && !string3.equals(CONFIG)) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLConfigStart", new Object[]{CONFIG, string3}), this.docLocator);
        }
        if (this.currentElements.size() == 1 && !this.validSubElement(string3, ConfigElements)) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLInvalidSyntax", string3), this.docLocator);
        }
        if (this.currentElements.size() == 2 && (this.currentElements.peek().equals(LISTENER) && !this.validSubElement(string3, ListenerElements) || this.currentElements.peek().equals(WORKER) && !this.validSubElement(string3, ListenerElements) || this.currentElements.peek().equals(POOLING) && !this.validSubElement(string3, PoolingElements))) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLInvalidSyntax", string3), this.docLocator);
        }
        if (this.currentElements.size() >= 3) {
            throw new SAXParseException(JMSXMLConfigHandler.getMessage("XMLMissingEndElement", new Object[]{this.currentElements.peek(), string3}), this.docLocator);
        }
        this.currentElements.push(string3);
        this.currentValue = null;
        if (string3.equals(LISTENER) || string3.equals(WORKER)) {
            this.currentListener = new JMSConfigData();
        }
        Tr.exit(tc, "startElement");
    }

    private boolean validElement(String string) {
        Tr.entry(tc, "validElement", string);
        boolean bl = false;
        bl = this.validSubElement(string, TopLevelElements) || this.validSubElement(string, ConfigElements) || this.validSubElement(string, ListenerElements) || this.validSubElement(string, PoolingElements);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validElement", new Boolean(bl));
        }
        return bl;
    }

    private boolean validSubElement(String string, String[] stringArray) {
        int n;
        Tr.entry(tc, "validSubElement", string);
        boolean bl = false;
        for (n = 0; n < stringArray.length && !stringArray[n].equals(string); ++n) {
        }
        bl = n != stringArray.length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validSubElement", new Boolean(bl));
        }
        return bl;
    }

    private static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return JMSXMLConfigHandler.getMessage(string, objectArray);
    }

    private static String getMessage(String string, Object[] objectArray) {
        if (msgBundle == null) {
            msgBundle = ResourceBundle.getBundle("com.ibm.ejs.jms.messaging");
        }
        String string2 = msgBundle.getString(string);
        if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = new String("line: " + sAXParseException.getLineNumber() + " column: " + sAXParseException.getColumnNumber());
        string = string + " : " + sAXParseException.getMessage();
        this.errors.add(string);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = new String("line: " + sAXParseException.getLineNumber() + " column: " + sAXParseException.getColumnNumber());
        string = string + " : " + sAXParseException.getMessage();
        this.fatalErrors.add(string);
        throw sAXParseException;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public Vector getFatalErrors() {
        return this.fatalErrors;
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = new String("line: " + sAXParseException.getLineNumber() + " column: " + sAXParseException.getColumnNumber());
        string = string + " : " + sAXParseException.getMessage();
        this.warnings.add(string);
    }
}

