/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mbmigrator;

import com.ibm.ejs.jms.mbmigrator.JMSConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MBEJBJarMigratorHandler
extends DefaultHandler {
    protected static TraceComponent tc = Tr.register(MBEJBJarMigratorHandler.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private static ResourceBundle msgBundle = null;
    private OutputStreamWriter out = null;
    private Locator docLocator = null;
    private boolean inEnterpriseBeans = false;
    private boolean inMessageBean = false;
    private String messageBeanID = null;
    private Stack currentElements = new Stack();
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String SESSION = "session";
    private static final String MESSAGE_DRIVEN = "message-driven";
    private static final String HOME = "home";
    private static final String REMOTE = "remote";
    private static final String EJB_CLASS = "ejb-class";
    private static final String TRANSACTION_TYPE = "transaction-type";
    private static final String SESSION_TYPE = "session-type";
    private static final String SECURITY_ROLE_REF = "security-role-ref";
    private static final String MESSAGE_DRIVEN_DESTINATION = "message-driven-destination";
    private static final String DESTINATION_TYPE = "destination-type";
    private static final String SUBSCRIPTION_DURABILITY = "subscription-durability";
    private static final String MESSAGE_SELECTOR = "message-selector";
    private static final String ACKNOWLEDGE_MODE = "acknowledge-mode";
    private String currentValue = null;
    private int indent = 0;
    private boolean firstElement = true;
    private Hashtable messageBeans;
    private Hashtable mappings;
    private Vector jmsListeners;
    private Vector messageBeanClasses;
    private static final String XMLDoc = "<?xml version='1.0' encoding='UTF-8'?>";
    private static final String EJB20DTD = "<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN\" \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\">";

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: MBEJBJarMigratorHandler <input-ejb-jar.xml> <output-ejb-jar.xml>");
            System.exit(1);
        }
        try {
            InputSource inputSource = new InputSource(new FileInputStream(stringArray[0]));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("myMDB/MyMDB", "");
            Hashtable hashtable2 = new Hashtable();
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(stringArray[1]), "UTF8");
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MBEJBJarMigratorHandler mBEJBJarMigratorHandler = new MBEJBJarMigratorHandler(hashtable, hashtable2, vector, vector2, outputStreamWriter);
            sAXParser.parse(inputSource, (DefaultHandler)mBEJBJarMigratorHandler);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.jms.mbmigrator.MBEJBJarMigratorHandler.main", "121");
            throwable.printStackTrace();
        }
        System.exit(0);
    }

    public MBEJBJarMigratorHandler(Hashtable hashtable, Hashtable hashtable2, Vector vector, Vector vector2, OutputStreamWriter outputStreamWriter) {
        this.messageBeans = hashtable;
        this.mappings = hashtable2;
        this.jmsListeners = vector;
        this.messageBeanClasses = vector2;
        this.out = outputStreamWriter;
    }

    public void startDocument() throws SAXParseException {
        this.rewrite(XMLDoc);
        this.newline();
        this.rewrite(EJB20DTD);
        this.newline();
    }

    public void endDocument() throws SAXParseException {
        try {
            this.newline();
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.jms.mbmigrator.MBEJBJarMigratorHandler.endDocument", "169", this);
            throw new SAXParseException("I/O Error", this.docLocator, iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXParseException {
        ++this.indent;
        if (string3.equals(ENTERPRISE_BEANS)) {
            this.inEnterpriseBeans = true;
        }
        if (!this.inEnterpriseBeans) {
            this.inIndent();
            this.rewriteNamePlusAtts(string3, attributes2);
            this.currentElements.push(new String(string3));
            return;
        }
        if (this.inMessageBean) {
            if (!(string3.equals(HOME) || string3.equals(REMOTE) || string3.equals(SESSION_TYPE) || string3.equals(SECURITY_ROLE_REF))) {
                this.inIndent();
                this.rewriteNamePlusAtts(string3, attributes2);
            }
        } else if (string3.equals(SESSION)) {
            String string4 = null;
            if (attributes2 != null) {
                for (int i = 0; i < attributes2.getLength() && string4 == null; ++i) {
                    if (!attributes2.getQName(i).equals("id")) continue;
                    string4 = attributes2.getValue(i);
                }
            }
            if (string4 != null && this.isMessageBean(string4)) {
                this.inMessageBean = true;
                this.messageBeanID = string4;
                this.inIndent();
                this.rewriteNamePlusAtts(MESSAGE_DRIVEN, attributes2);
            } else {
                this.inIndent();
                this.rewriteNamePlusAtts(string3, attributes2);
            }
        } else {
            this.inIndent();
            this.rewriteNamePlusAtts(string3, attributes2);
        }
        this.currentElements.push(new String(string3));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXParseException {
        String string = new String(cArray, n, n2);
        this.currentValue = string.trim();
        String string2 = (String)this.currentElements.peek();
        if (this.inMessageBean && string2 != null) {
            if (string2.equals(HOME) || string2.equals(REMOTE) || string2.equals(SESSION_TYPE) || string2.equals(SECURITY_ROLE_REF)) {
                string = null;
            } else if (string2.equals(EJB_CLASS)) {
                string = this.MBMDBWrapperName(string);
            }
        }
        if (string != null) {
            this.rewrite(this.handleSpecialCharacters(string));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXParseException {
        --this.indent;
        if (string2.equals("")) {
            string2 = (String)this.currentElements.peek();
        }
        if (!this.inEnterpriseBeans) {
            this.outIndent();
            this.rewrite("</" + string2 + ">");
            this.currentElements.pop();
            this.currentValue = null;
            return;
        }
        if (this.inMessageBean) {
            if (string2.equals(SESSION)) {
                this.outIndent();
                this.rewrite("</message-driven>");
                this.inMessageBean = false;
                this.messageBeanID = null;
            } else if (string2.equals(TRANSACTION_TYPE)) {
                this.outIndent();
                this.rewrite("</" + string2 + ">");
                this.writeJMSConfig();
            } else if (!(string2.equals(HOME) || string2.equals(REMOTE) || string2.equals(SESSION_TYPE) || string2.equals(SECURITY_ROLE_REF))) {
                if (string2.equals(EJB_CLASS)) {
                    this.messageBeanClasses.add(this.currentValue);
                }
                this.outIndent();
                this.rewrite("</" + string2 + ">");
            }
        } else {
            this.outIndent();
            this.rewrite("</" + string2 + ">");
        }
        if (string2.equals(ENTERPRISE_BEANS)) {
            this.inEnterpriseBeans = false;
        }
        this.currentElements.pop();
        this.currentValue = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    private static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return MBEJBJarMigratorHandler.getMessage(string, objectArray);
    }

    private static String getMessage(String string, Object[] objectArray) {
        if (msgBundle == null) {
            msgBundle = ResourceBundle.getBundle("com.ibm.ejs.jms.messaging");
        }
        String string2 = msgBundle.getString(string);
        if (objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    private void rewrite(String string) throws SAXParseException {
        try {
            this.out.write(string);
            this.out.flush();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.jms.mbmigrator.MBEJBJarMigratorHandler.rewrite", "403", this);
            throw new SAXParseException("I/O error", this.docLocator, iOException);
        }
    }

    private void rewriteNamePlusAtts(String string, Attributes attributes2) throws SAXParseException {
        this.rewrite("<" + string);
        if (attributes2 != null) {
            for (int i = 0; i < attributes2.getLength(); ++i) {
                this.rewrite(" ");
                this.rewrite(attributes2.getQName(i) + "=\"" + attributes2.getValue(i) + "\"");
            }
        }
        this.rewrite(">");
    }

    private void newline() throws SAXParseException {
        String string = System.getProperty("line.separator");
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.jms.mbmigrator.MBEJBJarMigratorHandler.newline", "440", this);
            throw new SAXParseException("I/O error", this.docLocator, iOException);
        }
    }

    private void inIndent() throws SAXParseException {
        if (this.firstElement) {
            this.firstElement = false;
        } else {
            this.newline();
        }
        for (int i = 1; i < this.indent; ++i) {
            this.rewrite("  ");
        }
    }

    private void outIndent() throws SAXParseException {
        if (this.currentValue == null) {
            this.newline();
            for (int i = 0; i < this.indent; ++i) {
                this.rewrite("  ");
            }
        }
    }

    private String handleSpecialCharacters(String string) {
        int n;
        String string2 = new String(string);
        int n2 = 0;
        String string3 = new String("");
        while ((n = string2.indexOf("&", n2)) != -1) {
            string3 = string3 + string2.substring(n2, n) + "&amp.";
            n2 = n + 1;
        }
        if (n2 < string2.length()) {
            string3 = string3 + string2.substring(n2);
        }
        string2 = string3;
        n2 = 0;
        string3 = new String("");
        while ((n = string2.indexOf("<", n2)) != -1) {
            string3 = string3 + string2.substring(n2, n) + "&lt.";
            n2 = n + 1;
        }
        if (n2 < string2.length()) {
            string3 = string3 + string2.substring(n2);
        }
        string2 = string3;
        return string2;
    }

    private boolean isMessageBean(String string) {
        boolean bl = this.messageBeans.containsValue("META-INF/ejb-jar.xml#" + string);
        return bl;
    }

    private void writeJMSConfig() throws SAXParseException {
        Object object;
        Object object2 = null;
        Enumeration enumeration = this.messageBeans.keys();
        while (object2 == null && enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.messageBeans.get(object).equals(this.messageBeanID)) continue;
            object2 = object;
        }
        if (object2 != null) {
            if (this.mappings.containsValue(object2)) {
                object = this.mappings.keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    if (!this.mappings.get(string).equals(object2)) continue;
                    object2 = string;
                    break;
                }
            }
            object = null;
            for (int i = 0; object == null && i < this.jmsListeners.size(); ++i) {
                JMSConfigData jMSConfigData = (JMSConfigData)this.jmsListeners.get(i);
                if (!jMSConfigData.EJBHomeJNDIName.equals(object2)) continue;
                object = jMSConfigData;
            }
            if (object != null) {
                ++this.indent;
                if (((JMSConfigData)object).messageSelector != null) {
                    this.inIndent();
                    this.rewrite("<message-selector>");
                    this.rewrite(((JMSConfigData)object).messageSelector);
                    this.rewrite("</message-selector>");
                }
                this.inIndent();
                this.rewrite("<acknowledge-mode>");
                if (((JMSConfigData)object).acknowledgement == 0) {
                    this.rewrite("Auto-acknowledge");
                } else {
                    this.rewrite("Dups-ok-acknowledge");
                }
                this.rewrite("</acknowledge-mode>");
                this.inIndent();
                this.rewrite("<message-driven-destination>");
                ++this.indent;
                this.inIndent();
                this.rewrite("<destination-type>");
                if (((JMSConfigData)object).destinationType == 0) {
                    this.rewrite("javax.jms.Queue");
                } else {
                    this.rewrite("javax.jms.Topic");
                }
                this.rewrite("</destination-type>");
                if (((JMSConfigData)object).destinationType == 1) {
                    this.inIndent();
                    this.rewrite("<subscription-durability>");
                    if (((JMSConfigData)object).subscriptionDurability == 0) {
                        this.rewrite("NonDurable");
                    } else {
                        this.rewrite("Durable");
                    }
                    this.rewrite("</subscription-durability>");
                }
                --this.indent;
                this.inIndent();
                this.rewrite("</message-driven-destination>");
                --this.indent;
            }
        }
    }

    private String MBMDBWrapperName(String string) {
        String string2 = new String(string + "MBMDBWrapper");
        return string2;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        int n = string2.lastIndexOf("/");
        String string3 = string2.substring(n + 1);
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
        if (inputStream == null) {
            String string4 = "Error: DTD file not found - " + string3;
            throw new SAXException(string4);
        }
        return new InputSource(inputStream);
    }
}

