/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.pcf.CommandServer;
import com.ibm.ejs.jms.mq.pcf.CommunicationException;
import com.ibm.ejs.jms.mq.pcf.InvalidArgumentException;
import com.ibm.ejs.jms.mq.pcf.QueueData;
import com.ibm.ejs.jms.mq.pcf.QueueDefinerConstants;
import com.ibm.ejs.jms.mq.pcf.QueueDefinitionException;
import com.ibm.ejs.jms.mq.pcf.QueueDeletionException;
import com.ibm.ejs.jms.mq.pcf.QueueLookupException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class CommandInputServer
implements CommandServer,
QueueDefinerConstants {
    private Integer ccsid = new Integer(500);
    private Locale locale = Locale.getDefault();
    private MQQueue commandInputQueue = null;
    private MQQueue replyQueue = null;
    private MQQueueManager queueMgr = null;
    private String commandInputQueueName = null;
    private static final String SPACE = " ";
    private static final String OPEN_PAR = "(";
    private static final String CLOSE_PAR = ")";
    private static final String QUOTE = "'";
    private static final int START_COUNT = 17;
    private static final int END_COUNT = 25;
    private static final String ALTER_QUEUE = "ALTER";
    private static final String DEFINE_QUEUE = "DEFINE";
    private static final String DELETE_QUEUE = "DELETE";
    private static final String DISQL = "DISPLAY QLOCAL('";
    private static final String MODEL_QUEUE = "SYSTEM.DEFAULT.MODEL.QUEUE";
    private static final String QLOCAL = "QLOCAL";
    private static final String REQUIRED_ATTRIBUTES = "') QTYPE DESCR PUT DEFPRTY DEFPSIST GET MAXDEPTH MAXMSGL BOTHRESH BOQNAME SHARE DEFSOPT HARDENBO MSGDLVSQ CLUSTER CLUSNL DEFBIND";
    private static final String ALL_REQUIRED = "') ALL";
    private static final String QUEUE_DETAILS = "CSQM401I";
    private static final String NO_QUEUE = "CSQM297I";
    private static final String NO_DELETE = "CSQ9023E";
    private static final String DISABLED = "DISABLED";
    private static final String ENABLED = "ENABLED";
    private static final String EXCL = "EXCL";
    private static final String SHARED = "SHARED";
    private static final String OPEN = "OPEN";
    private static final String NOTFIXED = "NOTFIXED";
    private static final String PRIORITY = "PRIORITY";
    private static final String FIFO = "FIFO";
    private static final String SHARE = "SHARE";
    private static final String HARDENBO = "HARDENBO";
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String QUEUE = "QUEUE";
    private static final String TYPE = "TYPE";
    private static final String CLUSTER = "CLUSTER";
    private static final String CLUSNL = "CLUSNL";
    private static final String DESCR = "DESCR";
    private static final String PUT = "PUT";
    private static final String DEFPRTY = "DEFPRTY";
    private static final String DEFPSIST = "DEFPSIST";
    private static final String MAXDEPTH = "MAXDEPTH";
    private static final String MAXMSGL = "MAXMSGL";
    private static final String BOTHRESH = "BOTHRESH";
    private static final String BOQNAME = "BOQNAME";
    private static final String NOSHARE = "NOSHARE";
    private static final String DEFSOPT = "DEFSOPT";
    private static final String MSGDLVSQ = "MSGDLVSQ";
    private static final String NOHARDENBO = "NOHARDENBO";
    private static final String GET = "GET";
    private static final String DEFBIND = "DEFBIND";
    private static final TraceComponent tc = Tr.register(CommandInputServer.class, "Messaging");

    public CommandInputServer(String string) throws CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommandInputServer", string);
        }
        this.connect(string, new Hashtable());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public CommandInputServer(String string, String string2, int n, String string3) throws CommunicationException {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            objectArray = new Object[]{string, string2, new Integer(n), string3};
            Tr.entry(tc, "CommandInputServer", objectArray);
        }
        objectArray = new Hashtable();
        objectArray.put("hostname", string2);
        objectArray.put("port", new Integer(n));
        objectArray.put("channel", string3);
        this.connect(string, (Hashtable)objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public CommandInputServer(String string, String string2, int n, String string3, String string4, String string5) throws CommunicationException {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            objectArray = new Object[]{string, string2, new Integer(n), string3, string4, string5};
            Tr.entry(tc, "CommandInputServer", objectArray);
        }
        objectArray = new Hashtable();
        objectArray.put("hostname", string2);
        objectArray.put("port", new Integer(n));
        objectArray.put("channel", string3);
        objectArray.put("userID", string4);
        objectArray.put("password", string5);
        this.connect(string, (Hashtable)objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public CommandInputServer(String string, Locale locale) throws CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommandInputServer", new Object[]{string, locale});
        }
        this.locale = locale;
        this.connect(string, new Hashtable());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public CommandInputServer(String string, String string2, int n, String string3, Locale locale) throws CommunicationException {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            objectArray = new Object[]{string, string2, new Integer(n), string3, locale};
            Tr.entry(tc, "CommandInputServer", objectArray);
        }
        this.locale = locale;
        objectArray = new Hashtable();
        objectArray.put("hostname", string2);
        objectArray.put("port", new Integer(n));
        objectArray.put("channel", string3);
        this.connect(string, (Hashtable)objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public CommandInputServer(String string, String string2, int n, String string3, String string4, String string5, Locale locale) throws CommunicationException {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            objectArray = new Object[]{string, string2, new Integer(n), string3, string4, string5, locale};
            Tr.entry(tc, "CommandInputServer");
        }
        this.locale = locale;
        objectArray = new Hashtable();
        objectArray.put("hostname", string2);
        objectArray.put("port", new Integer(n));
        objectArray.put("channel", string3);
        objectArray.put("userID", string4);
        objectArray.put("password", string5);
        this.connect(string, (Hashtable)objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommandInputServer");
        }
    }

    public QueueData lookup(String string) throws CommunicationException, QueueLookupException, QueueDefinitionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup", string);
        }
        QueueData queueData = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup");
        }
        return queueData;
    }

    public Properties lookupProps(String string) throws CommunicationException, QueueLookupException, QueueDefinitionException {
        Properties properties;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "lookupProps", string);
            }
            Object var2_2 = null;
            properties = null;
            MQMessage mQMessage = new MQMessage();
            String string2 = DISQL + string + REQUIRED_ATTRIBUTES;
            try {
                mQMessage.writeString(string2);
                String string3 = this.send(mQMessage);
                if (string3.indexOf(QUEUE_DETAILS) != -1) {
                    if (string3.indexOf(QLOCAL) == -1) {
                        throw new QueueLookupException();
                    }
                    properties = this.getQueueProps(string3);
                    break block10;
                }
                if (!string3.equals(NO_QUEUE)) break block10;
                properties = new Properties();
                properties.setProperty("Exists", "false");
            }
            catch (IOException iOException) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "lookupProps", iOException);
                    }
                    throw new CommunicationException("PCFCommandServerUnexpectedIOError", this.locale);
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "lookupProps", properties);
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupProps", properties);
        }
        return properties;
    }

    public void create(QueueData queueData) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
    }

    public void createProps(Properties properties) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProps");
        }
        String string = this.sendCmd(properties, DEFINE_QUEUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProps");
        }
    }

    public void modify(QueueData queueData) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modify");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modify");
        }
    }

    public void modifyProps(Properties properties) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyProps");
        }
        if (!Boolean.valueOf(properties.getProperty("Exists")).booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifyProps", "Queue Does NOT Exist");
            }
            throw new QueueDefinitionException();
        }
        String string = this.sendCmd(properties, ALTER_QUEUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyProps");
        }
    }

    public void delete(String string) throws QueueDeletionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", string);
        }
        try {
            String string2 = this.sendCmd(string, DELETE_QUEUE);
        }
        catch (QueueDefinitionException queueDefinitionException) {
            throw new QueueDeletionException(queueDefinitionException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
        }
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        this.disconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    private String send(MQMessage mQMessage) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", mQMessage);
        }
        String string = null;
        Object var3_3 = null;
        mQMessage.format = "MQSTR   ";
        mQMessage.messageType = 1;
        mQMessage.replyToQueueName = this.replyQueue.name;
        try {
            this.commandInputQueue.put(mQMessage);
            string = this.getReply(mQMessage.messageId);
        }
        catch (MQException mQException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "send", (Object)mQException);
            }
            throw new CommunicationException("PCFCommandServerUnexpectedMQError", mQException.reasonCode);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send", string);
            }
        }
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendCmd(Object object, String string) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendCmd", new Object[]{object, string});
        }
        String string2 = null;
        String string3 = null;
        MQMessage mQMessage = new MQMessage();
        try {
            string3 = string.equals(DELETE_QUEUE) ? string + SPACE + QLOCAL + OPEN_PAR + QUOTE + (String)object + QUOTE + CLOSE_PAR : string + this.getQueueAttributes((Properties)object);
            mQMessage.writeString(string3);
            string2 = this.send(mQMessage);
        }
        catch (IOException iOException) {
            try {
                if (!tc.isDebugEnabled()) throw new CommunicationException("PCFCommandServerUnexpectedIOError", this.locale);
                Tr.debug(tc, "sendCmd", iOException);
                throw new CommunicationException("PCFCommandServerUnexpectedIOError", this.locale);
                catch (InvalidArgumentException invalidArgumentException) {
                    throw new QueueDefinitionException("PCFCommandServerInvalidQueueSettingsReturned", this.locale);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "sendCmd", string2);
                throw throwable;
            }
        }
        if (!tc.isEntryEnabled()) return string2;
        Tr.exit(tc, "sendCmd", string2);
        return string2;
    }

    private String getReply(byte[] byArray) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReply", byArray);
        }
        String string = null;
        MQMessage mQMessage = new MQMessage();
        String string2 = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 16449;
        mQGetMessageOptions.waitInterval = 60000;
        try {
            mQMessage.correlationId = byArray;
            this.replyQueue.get(mQMessage, mQGetMessageOptions);
            string2 = mQMessage.readString(mQMessage.getMessageLength());
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getReply", string2);
                }
                int n = Integer.valueOf(string2.substring(17, 25).trim()) - 1;
                for (int i = 0; i < n; ++i) {
                    mQMessage = new MQMessage();
                    mQMessage.correlationId = byArray;
                    this.replyQueue.get(mQMessage, mQGetMessageOptions);
                    string2 = mQMessage.readString(mQMessage.getMessageLength());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getReply", string2);
                    }
                    if (string2.indexOf(QUEUE_DETAILS) != -1) {
                        string = string2;
                        continue;
                    }
                    if (string2.indexOf(NO_QUEUE) != -1) {
                        string = NO_QUEUE;
                        continue;
                    }
                    if (string2.indexOf(NO_DELETE) == -1) continue;
                    throw new QueueDefinitionException();
                }
            }
        }
        catch (MQException mQException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getReply", (Object)mQException);
            }
            throw new CommunicationException("PCFCommandServerUnexpectedMQError", mQException.reasonCode);
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getReply", iOException);
            }
            throw new CommunicationException("PCFCommandServerUnexpectedIOError", this.locale);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getReply", string);
            }
        }
        return string;
    }

    private String getParameterValue(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameterValue", string2);
        }
        String string3 = null;
        int n = string.indexOf(string2);
        if (n != -1) {
            if (string2.equals(NOSHARE) || string2.equals(NOHARDENBO)) {
                string3 = "true";
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getParameterValue", string3);
                }
                return string3;
            }
            String string4 = string.substring(n);
            string3 = string4.substring(string4.indexOf(OPEN_PAR) + 1, string4.indexOf(CLOSE_PAR)).trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameterValue", string3);
        }
        return string3;
    }

    private QueueData getQueueData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueueData", string);
        }
        QueueData queueData = null;
        Properties properties = null;
        Object var4_4 = null;
        properties = this.getQueueProps(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQueueData", properties);
        }
        return queueData;
    }

    private Properties getQueueProps(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueueProps", string);
        }
        Properties properties = new Properties();
        properties.setProperty("Queue Description", this.getParameterValue(string, DESCR));
        properties.setProperty("Inhibit Put", this.getParameterValue(string, PUT).equals(ENABLED) ? "Allowed" : "Inhibited");
        properties.setProperty("Default Persistence", this.getParameterValue(string, DEFPSIST).equals(YES) ? "Persistent" : "Not Persistent");
        properties.setProperty("Cluster Name", this.getParameterValue(string, CLUSTER));
        properties.setProperty("Cluster Name List", this.getParameterValue(string, CLUSNL));
        properties.setProperty("Default Bind", this.getParameterValue(string, DEFBIND).equals(OPEN) ? "On Open" : "Not Fixed");
        properties.setProperty("Inhibit Get", this.getParameterValue(string, GET).equals(ENABLED) ? "Allowed" : "Inhibited");
        properties.setProperty("Max Queue Depth", new Integer(this.getParameterValue(string, MAXDEPTH)).toString());
        properties.setProperty("Max Message Length", new Integer(this.getParameterValue(string, MAXMSGL)).toString());
        properties.setProperty("Shareability", Boolean.valueOf(this.getParameterValue(string, NOSHARE)) != false ? "Not Shareable" : "Shareable");
        properties.setProperty("Default Input Open Options", this.getParameterValue(string, DEFSOPT).equals(EXCL) ? "Exclusive" : "Shared");
        properties.setProperty("Message Delivery Sequence", this.getParameterValue(string, MSGDLVSQ).equals(PRIORITY) ? "Priority" : FIFO);
        properties.setProperty("Backout Threshold", new Integer(this.getParameterValue(string, BOTHRESH)).toString());
        properties.setProperty("Backout Requeue Name", this.getParameterValue(string, BOQNAME));
        properties.setProperty("Harden Get Backout", Boolean.valueOf(this.getParameterValue(string, NOHARDENBO)) != false ? "Not Hardened" : "Hardened");
        properties.setProperty("Default Priority", new Integer(this.getParameterValue(string, DEFPRTY)).toString());
        properties.setProperty("Exists", "true");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQueueProps", properties);
        }
        return properties;
    }

    private String getQueueAttributes(Properties properties) throws InvalidArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueueAttributes", properties);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            stringBuffer.append(" QLOCAL('" + properties.getProperty("Queue Name") + QUOTE + CLOSE_PAR + SPACE);
            string = properties.getProperty("Queue Description");
            if (!string.equals("")) {
                stringBuffer.append("DESCR('" + string + QUOTE + CLOSE_PAR + SPACE);
            }
            stringBuffer.append("PUT(" + (properties.getProperty("Inhibit Put").equals("Allowed") ? ENABLED : DISABLED) + CLOSE_PAR + SPACE);
            stringBuffer.append("DEFPSIST(" + (properties.getProperty("Default Persistence").equals("Persistent") ? YES : NO) + CLOSE_PAR + SPACE);
            string = properties.getProperty("Cluster Name");
            if (!string.equals("")) {
                stringBuffer.append("CLUSTER('" + string + QUOTE + CLOSE_PAR + SPACE);
            }
            if (!(string = properties.getProperty("Cluster Name List")).equals("")) {
                stringBuffer.append("CLUSNL('" + string + QUOTE + CLOSE_PAR + SPACE);
            }
            stringBuffer.append("DEFBIND(" + (properties.getProperty("Default Bind").equals("On Open") ? OPEN : NOTFIXED) + CLOSE_PAR + SPACE);
            stringBuffer.append("GET(" + (properties.getProperty("Inhibit Get").equals("Allowed") ? ENABLED : DISABLED) + CLOSE_PAR + SPACE);
            string = properties.getProperty("Max Queue Depth");
            if (!string.equals("")) {
                stringBuffer.append("MAXDEPTH(" + new Integer(string).toString() + CLOSE_PAR + SPACE);
            }
            if (!(string = properties.getProperty("Max Message Length")).equals("")) {
                stringBuffer.append("MAXMSGL(" + new Integer(string).toString() + CLOSE_PAR + SPACE);
            }
            stringBuffer.append((properties.getProperty("Shareability").equals("Not Shareable") ? NOSHARE : SHARE) + SPACE);
            stringBuffer.append("DEFSOPT(" + (properties.getProperty("Default Input Open Options").equals("Exclusive") ? EXCL : SHARED) + CLOSE_PAR + SPACE);
            stringBuffer.append("MSGDLVSQ(" + (properties.getProperty("Message Delivery Sequence").equals("Priority") ? PRIORITY : FIFO) + CLOSE_PAR + SPACE);
            string = properties.getProperty("Backout Threshold");
            if (!string.equals("")) {
                stringBuffer.append("BOTHRESH(" + new Integer(string).toString() + CLOSE_PAR + SPACE);
            }
            if (!(string = properties.getProperty("Backout Requeue Name")).equals("")) {
                stringBuffer.append("BOQNAME('" + string + QUOTE + CLOSE_PAR + SPACE);
            }
            stringBuffer.append((properties.getProperty("Harden Get Backout").equals("Not Hardened") ? NOHARDENBO : HARDENBO) + SPACE);
            string = properties.getProperty("Default Priority");
            if (!string.equals("")) {
                stringBuffer.append("DEFPRTY(" + new Integer(string).toString() + CLOSE_PAR);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getQueueAttributes", numberFormatException);
            }
            throw new InvalidArgumentException("PCFQueueDataValueInvalid", this.locale);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getQueueAttributes");
            }
        }
        return stringBuffer.toString();
    }

    private void connect(String string, Hashtable hashtable) throws CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connect", string);
        }
        try {
            this.queueMgr = new MQQueueManager(string, hashtable);
            this.commandInputQueue = this.queueMgr.accessQueue(this.queueMgr.getCommandInputQueueName(), 16);
            this.replyQueue = this.queueMgr.accessQueue(MODEL_QUEUE, 2);
        }
        catch (MQException mQException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connect", (Object)mQException);
            }
            throw new CommunicationException("PCFCommandServerUnexpectedMQError", mQException.reasonCode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    private void disconnect() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "disconnect");
            }
            if (this.queueMgr != null) {
                try {
                    this.queueMgr.disconnect();
                    this.queueMgr = null;
                    this.commandInputQueue = null;
                    this.replyQueue = null;
                }
                catch (MQException mQException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "disconnect", (Object)mQException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disconnect");
        }
    }
}

