/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.XAConnection;

public abstract class JMSWrapConnection {
    protected Connection connection;
    protected boolean closed = false;
    protected boolean xaCapable;
    protected Vector sessions = new Vector();
    protected int sessionCount = 0;
    private static TraceComponent tc = Tr.register(JMSWrapConnection.class.getName(), "Messaging");

    JMSWrapConnection(Connection connection) {
        Tr.entry(tc, "JMSWrapConnection constructor", connection);
        this.connection = connection;
        this.xaCapable = connection instanceof XAConnection;
        Tr.exit(tc, "JMSWrapConnection constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        Tr.entry(tc, "close");
        if (!this.closed) {
            JMSWrapSession jMSWrapSession = null;
            while (true) {
                Vector vector = this.sessions;
                synchronized (vector) {
                    int n = this.sessions.size();
                    if (n == 0) {
                        break;
                    }
                    jMSWrapSession = (JMSWrapSession)this.sessions.remove(n - 1);
                }
                try {
                    jMSWrapSession._close();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.close", "127", this);
                    Tr.event(tc, "JMSException is close: ", (Object)jMSException);
                    if (jMSException.getLinkedException() == null) continue;
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            if (this.sessionCount == 0) {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.close", "143", this);
                    Tr.event(tc, "JMSException in close: ", (Object)jMSException);
                    if (jMSException.getLinkedException() != null) {
                        Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                    }
                    Tr.exit(tc, "close");
                    throw jMSException;
                }
            }
            this.closed = true;
        }
        Tr.exit(tc, "close");
    }

    public String getClientID() throws JMSException {
        Tr.entry(tc, "getClientID");
        String string = null;
        try {
            string = this.connection.getClientID();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.getClientID", "177", this);
            Tr.event(tc, "JMSException in getClientID: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "getClientID", string);
        }
        return string;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        Tr.entry(tc, "getExceptionListener");
        ExceptionListener exceptionListener = null;
        try {
            exceptionListener = this.connection.getExceptionListener();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.getExceptionListener", "211", this);
            Tr.event(tc, "JMSException in getExceptionListener: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "getExceptionListener", exceptionListener);
        }
        return exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        Tr.entry(tc, "getMetaData");
        ConnectionMetaData connectionMetaData = null;
        try {
            connectionMetaData = this.connection.getMetaData();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.getMetaData", "245", this);
            Tr.event(tc, "JMSException in JMSWrapConnection getMetaData: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "getMetaData", connectionMetaData);
        }
        return connectionMetaData;
    }

    public void start() throws JMSException {
        Tr.entry(tc, "start");
        try {
            this.connection.start();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.start", "275", this);
            Tr.event(tc, "JMSException in start: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            Tr.exit(tc, "start");
            throw jMSException;
        }
        Tr.exit(tc, "start");
    }

    public void setClientID(String string) throws JMSException {
        Tr.entry(tc, "setClientID", string);
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in setClientID: ", (Object)illegalStateException);
        Tr.exit(tc, "setClientID");
        throw illegalStateException;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        Tr.entry(tc, "setExceptionListener", exceptionListener);
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in setExceptionListener: ", (Object)illegalStateException);
        Tr.exit(tc, "setExceptionListener");
        throw illegalStateException;
    }

    public void stop() throws JMSException {
        Tr.entry(tc, "stop");
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in stop:  ", (Object)illegalStateException);
        Tr.exit(tc, "stop");
        throw illegalStateException;
    }

    public void internalSetClientID(String string) throws JMSException {
        Tr.entry(tc, "setClientID", string);
        try {
            this.connection.setClientID(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.internalSetClientID", "357", this);
            Tr.event(tc, "JMSException in setClientID: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "setClientID");
        }
    }

    public void internalSetExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        Tr.entry(tc, "setExceptionListener", exceptionListener);
        try {
            this.connection.setExceptionListener(exceptionListener);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.internalSetExceptionListener", "389", this);
            Tr.event(tc, "JMSException in setExceptionListener: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "setExceptionListener");
        }
    }

    public void internalStop() throws JMSException {
        Tr.entry(tc, "stop");
        try {
            this.connection.stop();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.internalStop", "419", this);
            Tr.event(tc, "JMSException in stop: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "stop");
        }
    }

    public boolean isXACapable() {
        return this.xaCapable;
    }

    boolean isClosed() {
        return this.closed;
    }

    protected void addSession(JMSWrapSession jMSWrapSession) {
        this.sessions.addElement(jMSWrapSession);
    }

    protected boolean removeSession(JMSWrapSession jMSWrapSession) {
        return this.sessions.removeElement(jMSWrapSession);
    }

    synchronized void incrementSessionCount() {
        ++this.sessionCount;
    }

    synchronized void decrementSessionCount() {
        block3: {
            --this.sessionCount;
            if (this.sessionCount == 0 && this.closed) {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapConnection.decrementSessionCount", "514", this);
                    Tr.event(tc, "JMSException when closing connection: ", (Object)jMSException);
                    if (jMSException.getLinkedException() == null) break block3;
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JMSWrapConnection) {
            JMSWrapConnection jMSWrapConnection = (JMSWrapConnection)object;
            return this.connection.equals(jMSWrapConnection.connection) && this.closed == jMSWrapConnection.closed;
        }
        return false;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }
}

