/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class JMSWrapMessageConsumer
implements MessageConsumer {
    protected MessageConsumer consumer = null;
    protected JMSWrapSession parentSession;
    protected boolean closed = false;
    protected boolean consumerType;
    protected static TraceComponent tc = Tr.register(JMSWrapMessageConsumer.class.getName(), "Messaging");
    protected String messageSelector = null;
    protected MessageListener messageListener = null;

    JMSWrapMessageConsumer(JMSWrapSession jMSWrapSession) {
        Tr.entry(tc, "JMSWrapMessageConsumer constructor", jMSWrapSession);
        this.parentSession = jMSWrapSession;
        Tr.exit(tc, "JMSWrapMessageConsumer constructor");
    }

    JMSWrapMessageConsumer(JMSWrapSession jMSWrapSession, String string) {
        this(jMSWrapSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapMessageConsumer constructor", new Object[]{jMSWrapSession, string});
        }
        this.messageSelector = string;
        Tr.exit(tc, "JMSWrapMessageConsumer constructor");
    }

    public void close() throws JMSException {
        Tr.entry(tc, "close");
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.close", "115", this);
            Tr.event(tc, "JMSException in close: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "close");
            this.closed = true;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        Tr.entry(tc, "setMessageListener");
        IllegalStateException illegalStateException = new IllegalStateException("Method Not Allowed Exception");
        Tr.event(tc, "JMSException in setMessageListener: ", (Object)illegalStateException);
        Tr.exit(tc, "setMessageListener");
        throw illegalStateException;
    }

    public MessageListener getMessageListener() throws JMSException {
        Tr.entry(tc, "getMessageListener");
        IllegalStateException illegalStateException = new IllegalStateException("Method Not Allowed Exception");
        Tr.event(tc, "JMSException in getMessageListener: ", (Object)illegalStateException);
        Tr.exit(tc, "getMessageListener");
        throw illegalStateException;
    }

    public String getMessageSelector() throws JMSException {
        Tr.entry(tc, "getMessageSelector");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getMessageSelector: ", (Object)illegalStateException);
            Tr.exit(tc, "getMessageSelector");
            throw illegalStateException;
        }
        Tr.exit(tc, "getMessageSelector", this.messageSelector);
        return this.messageSelector;
    }

    public MessageListener internalGetMessageListener() throws JMSException {
        Tr.entry(tc, "internalGetMessageListener");
        Tr.exit(tc, "internalGetMessageListener", this.messageListener);
        return this.messageListener;
    }

    public void internalSetMessageListener(MessageListener messageListener) throws JMSException {
        Tr.entry(tc, "internalSetMessageListener", messageListener);
        if (this.consumer != null) {
            try {
                this.consumer.setMessageListener(messageListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.internalSetMessageListener", "225", this);
                Tr.event(tc, "JMSException in internalSetMessageListener: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "internalSetMessageListener");
                throw jMSException;
            }
        }
        this.messageListener = messageListener;
        Tr.exit(tc, "internalSetMessageListener");
    }

    protected void initialiseConsumer() throws JMSException {
        Tr.entry(tc, "initialiseConsumer", this.consumer);
        if (this.messageListener != null) {
            try {
                this.consumer.setMessageListener(this.messageListener);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.initialiseConsumer", "259", this);
                Tr.event(tc, "JMSException in initialiseConsumer: ", (Object)jMSException);
                Tr.exit(tc, "initialiseConsumer");
                throw jMSException;
            }
        }
        Tr.exit(tc, "initialiseConsumer");
    }

    protected void setupConsumer() throws JMSException {
        Tr.entry(tc, "setupConsumer");
        try {
            boolean bl;
            if (this.isClosed()) {
                throw new IllegalStateException("Closed");
            }
            int n = JMSWrapSession.getCurrentTransactionType();
            boolean bl2 = bl = n == JMSWrapSession.GLOBAL_TRANSACTION;
            if (this.consumer == null || this.consumerType != bl) {
                if (this.consumer != null) {
                    this.consumer.close();
                    this.consumer = null;
                }
                this.consumer = this.createMessageConsumer(bl);
                this.initialiseConsumer();
                this.consumerType = bl;
            }
            this.parentSession.handleTransaction(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageConsumer.setupConsumer", "313", this);
            Tr.event(tc, "JMSException in setupConsumer: ", (Object)jMSException);
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "setupConsumer");
        }
    }

    boolean isClosed() {
        return this.closed || this.parentSession.isClosed();
    }

    protected abstract MessageConsumer createMessageConsumer(boolean var1) throws JMSException;

    public Message receive() throws JMSException {
        return null;
    }

    public Message receive(long l) throws JMSException {
        return null;
    }

    public Message receiveNoWait() throws JMSException {
        return null;
    }
}

