/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public abstract class JMSWrapMessageProducer
implements MessageProducer {
    protected MessageProducer producer = null;
    protected JMSWrapSession parentSession;
    protected boolean closed = false;
    protected boolean producerType;
    protected static int UNSET_DELIVERY_MODE = -1;
    protected int deliveryMode = UNSET_DELIVERY_MODE;
    protected boolean disableMessageID = false;
    protected boolean disableMessageTimestamp = false;
    protected int priority = 4;
    protected long timeToLive = 0L;
    protected static TraceComponent tc = Tr.register(JMSWrapMessageProducer.class.getName(), "Messaging");

    JMSWrapMessageProducer(JMSWrapSession jMSWrapSession) {
        Tr.entry(tc, "JMSWrapMessageProducer constructor", jMSWrapSession);
        this.parentSession = jMSWrapSession;
        Tr.exit(tc, "JMSWrapMessageProducer constructor");
    }

    public void close() throws JMSException {
        Tr.entry(tc, "close");
        try {
            if (this.producer != null) {
                this.producer.close();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.close", "110", this);
            Tr.event(tc, "JMSException in close: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            this.closed = true;
            Tr.exit(tc, "close");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeliveryMode");
        }
        int n = UNSET_DELIVERY_MODE;
        try {
            this.setupProducer();
            n = this.producer.getDeliveryMode();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.getDeliveryMode", "146", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in getDeliveryMode: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeliveryMode", new Integer(n));
            }
        }
        return n;
    }

    public boolean getDisableMessageID() throws JMSException {
        Tr.entry(tc, "getDisableMessageID");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getDisableMessageID: ", (Object)illegalStateException);
            Tr.exit(tc, "getDisableMessageID");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisableMessageID", new Boolean(this.disableMessageID));
        }
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        Tr.entry(tc, "getDisableMessageTimestamp");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getDisableMessageTimestamp: ", (Object)illegalStateException);
            Tr.exit(tc, "getDisableMessageTimestamp");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisableMessageTimestamp", new Boolean(this.disableMessageTimestamp));
        }
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        Tr.entry(tc, "getPriority");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getPriority: ", (Object)illegalStateException);
            Tr.exit(tc, "getPriority");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPriority", new Integer(this.priority));
        }
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        Tr.entry(tc, "getTimeToLive");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getTimeToLive: ", (Object)illegalStateException);
            Tr.exit(tc, "getTimeToLive");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeToLive", new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public void setDeliveryMode(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeliveryMode", new Integer(n));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in setDeliveryMode: ", (Object)illegalStateException);
            Tr.exit(tc, "setDeliveryMode");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDeliveryMode(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDeliveryMode", "294", this);
                Tr.event(tc, "JMSException in setDeliveryMode: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "setDeliveryMode");
                throw jMSException;
            }
        }
        this.deliveryMode = n;
        Tr.exit(tc, "setDeliveryMode");
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDisableMessageID", new Boolean(bl));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in setDisableMessageID: ", (Object)illegalStateException);
            Tr.exit(tc, "setDisableMessageID");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDisableMessageID(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDisableMessageID", "339", this);
                Tr.event(tc, "JMSException in setDisableMessageID: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "setDisableMessageID");
                throw jMSException;
            }
        }
        this.disableMessageID = bl;
        Tr.exit(tc, "setDisableMessageID");
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        Tr.entry(tc, "setDissableMessageTimestamp", new Boolean(bl));
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in setDisableMessageTimestamp: ", (Object)illegalStateException);
            Tr.exit(tc, "setDisableMessageTimestamp");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setDisableMessageTimestamp(bl);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setDisableMessageTimestamp", "383", this);
                Tr.event(tc, "JMSException in setDisableMessageTimestamp: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "setDisableMessageTimestamp");
                throw jMSException;
            }
        }
        this.disableMessageTimestamp = bl;
        Tr.exit(tc, "setDisableMessageTimestamp");
    }

    public void setPriority(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPriority", new Integer(n));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in setPriority: ", (Object)illegalStateException);
            Tr.exit(tc, "setPriority");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setPriority(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setPriority", "427", this);
                Tr.event(tc, "JMSException in setPriority: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "setPriority");
                throw jMSException;
            }
        }
        this.priority = n;
        Tr.exit(tc, "setPriority");
    }

    public void setTimeToLive(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeToLive", new Long(l));
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in setTimeToLive: ", (Object)illegalStateException);
            Tr.exit(tc, "setTimeToLive");
            throw illegalStateException;
        }
        if (this.producer != null) {
            try {
                this.producer.setTimeToLive(l);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setTimeToLive", "472", this);
                Tr.event(tc, "JMSException in setTimeToLive: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                Tr.exit(tc, "setTimeToLive");
                throw jMSException;
            }
        }
        this.timeToLive = l;
        Tr.exit(tc, "setTimeToLive");
    }

    protected void initialiseProducer() throws JMSException {
        Tr.entry(tc, "initialiseProducer");
        try {
            if (this.deliveryMode != UNSET_DELIVERY_MODE) {
                this.producer.setDeliveryMode(this.deliveryMode);
            }
            this.producer.setDisableMessageID(this.disableMessageID);
            this.producer.setDisableMessageTimestamp(this.disableMessageTimestamp);
            this.producer.setPriority(this.priority);
            this.producer.setTimeToLive(this.timeToLive);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.initialiseProducer", "511", this);
            Tr.event(tc, "JMSException in initialiseProducer: ", (Object)jMSException);
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "initialiseProducer");
        }
    }

    protected void setupProducer() throws JMSException {
        Tr.entry(tc, "setupProducer");
        try {
            boolean bl;
            if (this.isClosed()) {
                throw new IllegalStateException("Closed");
            }
            int n = JMSWrapSession.getCurrentTransactionType();
            boolean bl2 = bl = n == JMSWrapSession.GLOBAL_TRANSACTION;
            if (this.producer == null || this.producerType != bl) {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
                this.producer = this.createMessageProducer(bl);
                this.initialiseProducer();
                this.producerType = bl;
            }
            this.parentSession.handleTransaction(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapMessageProducer.setupProducer", "565", this);
            Tr.event(tc, "JMSException in setupProducer: ", (Object)jMSException);
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "setupProducer");
        }
    }

    boolean isClosed() {
        return this.closed || this.parentSession.isClosed();
    }

    protected abstract MessageProducer createMessageProducer(boolean var1) throws JMSException;

    public Destination getDestination() throws JMSException {
        return null;
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
    }

    public void send(Destination destination, Message message) throws JMSException {
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
    }

    public void send(Message message) throws JMSException {
    }
}

