/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapSession;
import com.ibm.ejs.jms.mq.JMSWrapTopicSubscriber;
import com.ibm.ejs.jms.mq.JMSWrapXATopicSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSWrapNonDurableTopicSubscriber
extends JMSWrapTopicSubscriber
implements TopicSubscriber {
    private static TraceComponent tc = Tr.register(JMSWrapNonDurableTopicSubscriber.class.getName(), "Messaging");

    JMSWrapNonDurableTopicSubscriber(JMSWrapXATopicSession jMSWrapXATopicSession, Topic topic) throws JMSException {
        super(jMSWrapXATopicSession, topic);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapTopicSubscriber constructor", new Object[]{jMSWrapXATopicSession, topic});
        }
        try {
            this.consumerType = JMSWrapSession.isGlobalTransactionActive();
            TopicSession topicSession = jMSWrapXATopicSession.getTopicSession(this.consumerType);
            this.consumer = topicSession.createSubscriber(topic);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapNonDurableTopicSubscriber.JMSWrapNonDurableTopicSubscriber", "60", this);
            Tr.event(tc, "JMSException in JMSWrapTopicSubscriber constructor: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "JMSWrapTopicSubscriber constructor");
        }
    }

    JMSWrapNonDurableTopicSubscriber(JMSWrapXATopicSession jMSWrapXATopicSession, Topic topic, String string, boolean bl) throws JMSException {
        super(jMSWrapXATopicSession, topic, string, bl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapTopicSubscriber constructor", new Object[]{jMSWrapXATopicSession, topic, string, new Boolean(bl)});
        }
        try {
            this.consumerType = JMSWrapSession.isGlobalTransactionActive();
            TopicSession topicSession = jMSWrapXATopicSession.getTopicSession(this.consumerType);
            this.consumer = topicSession.createSubscriber(topic, string, bl);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapNonDurableTopicSubscriber.JMSWrapNonDurableTopicSubscriber", "104", this);
            Tr.event(tc, "JMSException in JMSWrapTopicSubscriber constructor: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "JMSWrapTopicSubscriber constructor");
        }
    }

    protected void setupConsumer() throws JMSException {
        Tr.entry(tc, "setupConsumer");
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        try {
            boolean bl;
            int n = JMSWrapSession.getCurrentTransactionType();
            boolean bl2 = bl = n == JMSWrapSession.GLOBAL_TRANSACTION;
            if (this.consumerType != bl) {
                throw new IllegalStateException("Attempt to use subscriber in different transactional context from that in which it was created");
            }
            this.parentSession.handleTransaction(n);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapNonDurableTopicSubscriber.setupConsumer", "153", this);
            Tr.event(tc, "JMSException in setupConsumer: ", (Object)jMSException);
            Tr.exit(tc, "setupConsumer");
            throw jMSException;
        }
        Tr.exit(tc, "setupConsumer");
    }

    protected MessageConsumer createMessageConsumer(boolean bl) throws JMSException {
        return null;
    }
}

