/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapMessageConsumer;
import com.ibm.ejs.jms.mq.JMSWrapXAQueueSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;

public class JMSWrapQueueReceiver
extends JMSWrapMessageConsumer
implements QueueReceiver {
    private Queue queue;
    private static TraceComponent tc = Tr.register(JMSWrapQueueReceiver.class.getName(), "Messaging");

    JMSWrapQueueReceiver(JMSWrapXAQueueSession jMSWrapXAQueueSession, Queue queue) throws JMSException {
        super(jMSWrapXAQueueSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapQueueReceiver constructor", new Object[]{jMSWrapXAQueueSession, queue});
        }
        try {
            this.queue = queue;
            this.setupConsumer();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.JMSWrapQueueReceiver", "75", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in JMSWrapQueueReceiver constructor: ", (Object)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSWrapQueueReceiver constructor");
            }
        }
    }

    JMSWrapQueueReceiver(JMSWrapXAQueueSession jMSWrapXAQueueSession, Queue queue, String string) throws JMSException {
        super(jMSWrapXAQueueSession, string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapQueueReceiver constructor", new Object[]{jMSWrapXAQueueSession, queue, string});
        }
        try {
            this.queue = queue;
            this.setupConsumer();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.JMSWrapQueueReceiver", "120", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in JMSWrapQueueReceiver constructor: ", (Object)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "JMSWrapQueueReceiver constructor");
            }
        }
    }

    public Queue getQueue() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueue");
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in getQueue: ", (Object)illegalStateException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getQueue");
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQueue", this.queue);
        }
        return this.queue;
    }

    public Message receive() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive");
        }
        Message message = null;
        try {
            this.setupConsumer();
            message = ((QueueReceiver)this.consumer).receive();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.receive", "201", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in receive: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive", "Message contents not traced");
            }
        }
        return message;
    }

    public Message receive(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive", new Long(l));
        }
        Message message = null;
        try {
            this.setupConsumer();
            message = ((QueueReceiver)this.consumer).receive(l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.receive", "251", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in JMSWrapQueueReceiver receive: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive", "Message contents not traced");
            }
        }
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveNoWait");
        }
        Message message = null;
        try {
            this.setupConsumer();
            message = ((QueueReceiver)this.consumer).receiveNoWait();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.receiveNoWait", "297", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in receiveNoWait: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receiveNoWait", "Message contents not traced");
            }
        }
        return message;
    }

    protected MessageConsumer createMessageConsumer(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessageConsumer", new Boolean(bl));
        }
        QueueReceiver queueReceiver = null;
        try {
            QueueSession queueSession = ((JMSWrapXAQueueSession)this.parentSession).getQueueSession(bl);
            queueReceiver = this.messageSelector != null ? queueSession.createReceiver(this.queue, this.messageSelector) : queueSession.createReceiver(this.queue);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueReceiver.createMessageConsumer", "353", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "JMSException in createMessageConsumer: ", (Object)jMSException);
                    if (jMSException.getLinkedException() != null) {
                        Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                    }
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMessageConsumer", queueReceiver);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMessageConsumer", queueReceiver);
        }
        return queueReceiver;
    }
}

