/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapMessageProducer;
import com.ibm.ejs.jms.mq.JMSWrapXAQueueSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSWrapQueueSender
extends JMSWrapMessageProducer
implements QueueSender {
    private Queue queue;
    private static TraceComponent tc = Tr.register(JMSWrapQueueSender.class.getName(), "Messaging");

    JMSWrapQueueSender(JMSWrapXAQueueSession jMSWrapXAQueueSession, Queue queue) {
        super(jMSWrapXAQueueSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapQueueSender constructor", new Object[]{jMSWrapXAQueueSession, queue});
        }
        this.queue = queue;
        Tr.exit(tc, "JMSWrapQueueSender constructor");
    }

    public Queue getQueue() throws JMSException {
        Tr.entry(tc, "getQueue");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getQueue: ", (Object)illegalStateException);
            Tr.exit(tc, "getQueue");
            throw illegalStateException;
        }
        Tr.exit(tc, "getQueue", this.queue);
        return this.queue;
    }

    public void send(Message message) throws JMSException {
        Tr.entry(tc, "send", "Message contents not traced");
        try {
            this.setupProducer();
            ((QueueSender)this.producer).send(message);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueSender.send", "117", this);
            Tr.event(tc, "JMSException in send: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "send");
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{"Message contents not traced", new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            this.setupProducer();
            ((QueueSender)this.producer).send(message, n, n2, l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueSender.send", "161", this);
            Tr.event(tc, "JMSException in send: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "send");
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{queue, "Message contents not traced"});
        }
        try {
            this.setupProducer();
            ((QueueSender)this.producer).send(queue, message);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueSender.send", "202", this);
            Tr.event(tc, "JMSException in send: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "send");
        }
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{queue, "Message contents not traced", new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            this.setupProducer();
            ((QueueSender)this.producer).send(queue, message, n, n2, l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueSender.send", "251", this);
            Tr.event(tc, "JMSException in send: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "send");
        }
    }

    protected MessageProducer createMessageProducer(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessageProducer", new Boolean(bl));
        }
        QueueSender queueSender = null;
        try {
            QueueSession queueSession = ((JMSWrapXAQueueSession)this.parentSession).getQueueSession(bl);
            queueSender = queueSession.createSender(this.queue);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapQueueSender.createMessageProducer", "293", this);
                Tr.event(tc, "JMSException in createMessageProducer: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createMessageProducer", queueSender);
                throw throwable;
            }
        }
        Tr.exit(tc, "createMessageProducer", queueSender);
        return queueSender;
    }
}

