/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.EnlistableResource;
import com.ibm.ejs.jms.mq.JMSWrapConnection;
import com.ibm.ejs.jms.mq.JMSXAResourceInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQXAResource;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.LocalTransaction.LTCSystemException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class JMSWrapSession
implements EnlistableResource {
    protected boolean transacted;
    protected int acknowledgeMode;
    protected boolean closed = false;
    protected boolean enlistedOnePhase = false;
    protected OnePhaseXAResource onePhaseXAResource = null;
    protected boolean enlistedTwoPhase = false;
    protected Transaction transaction = null;
    protected boolean registeredTwoPhase = false;
    protected Session transactedSession = null;
    protected Session nonTransactedSession = null;
    protected XASession xaSession = null;
    protected Session sessionFromXASession = null;
    protected JMSWrapConnection parentConnection;
    protected boolean xaCapable;
    protected List temporaryDestinations = new ArrayList();
    protected List messageConsumers = new ArrayList();
    protected List messageProducers = new ArrayList();
    static int NO_TRANSACTION = 0;
    static int LOCAL_TRANSACTION = 1;
    static int GLOBAL_TRANSACTION = 2;
    private static TraceComponent tc = Tr.register(JMSWrapSession.class.getName(), "Messaging");

    public JMSWrapSession(JMSWrapConnection jMSWrapConnection, boolean bl, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapSession constructor", new Object[]{jMSWrapConnection, new Boolean(bl), new Integer(n)});
        }
        this.parentConnection = jMSWrapConnection;
        this.transacted = bl;
        this.acknowledgeMode = n;
        this.xaCapable = jMSWrapConnection.isXACapable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMSWrapSession constructor");
        }
    }

    public void close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        try {
            if (!this.closed) {
                if (this.parentConnection.removeSession(this)) {
                    this._close();
                }
                this.closed = true;
            }
            this.closeChildren();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.close", "200", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in close: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBytesMessage");
        }
        BytesMessage bytesMessage = null;
        try {
            bytesMessage = this.getAnySession().createBytesMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createBytesMessage", "236", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createBytesMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBytesMessage", "Message contents not traced");
            }
        }
        return bytesMessage;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMapMessage");
        }
        MapMessage mapMessage = null;
        try {
            mapMessage = this.getAnySession().createMapMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createMapMessage", "274", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createMapMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMapMessage", "Message contents not traced");
            }
        }
        return mapMessage;
    }

    public Message createMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessage");
        }
        Message message = null;
        try {
            message = this.getAnySession().createMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createMessage", "312", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMessage", "Message contents not traced");
            }
        }
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectMessage");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.getAnySession().createObjectMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createObjectMessage", "350", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createObjectMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createObjectMessage", "Message contents not traced");
            }
        }
        return objectMessage;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectMessage", serializable);
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = this.getAnySession().createObjectMessage(serializable);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createObjectMessage", "389", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createObjectMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createObjectMessage", "Message contents not traced");
            }
        }
        return objectMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStreamMessage");
        }
        StreamMessage streamMessage = null;
        try {
            streamMessage = this.getAnySession().createStreamMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createStreamMessage", "428", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createStreamMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createStreamMessage", "Message contents not traced");
            }
        }
        return streamMessage;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextMessage");
        }
        TextMessage textMessage = null;
        try {
            textMessage = this.getAnySession().createTextMessage();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createTextMessage", "466", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createTextMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTextMessage", "Message contents not traced");
            }
        }
        return textMessage;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTextMessage", string);
        }
        TextMessage textMessage = null;
        try {
            textMessage = this.getAnySession().createTextMessage(string);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.createTextMessage", "504", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in createTextMessage: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTextMessage", "Message contents not traced");
            }
        }
        return textMessage;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageListener");
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method Not Allowed Exception");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMSException in getMessageListener: ", (Object)illegalStateException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListener");
        }
        throw illegalStateException;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getTransacted() throws JMSException {
        if (JMSWrapSession.tc.isEntryEnabled()) {
            Tr.entry(JMSWrapSession.tc, "getTransacted");
        }
        if (this.closed) {
            var1_1 = new javax.jms.IllegalStateException("Closed");
            if (JMSWrapSession.tc.isEventEnabled()) {
                Tr.event(JMSWrapSession.tc, "JMSException in getTransacted: ", (Object)var1_1);
            }
            if (JMSWrapSession.tc.isEntryEnabled()) {
                Tr.exit(JMSWrapSession.tc, "getTransacted");
            }
            throw var1_1;
        }
        if (!this.transacted) ** GOTO lbl-1000
        if (!this.isGlobalTransactionActive()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_2 = false;
        }
        if (JMSWrapSession.tc.isEntryEnabled()) {
            Tr.exit(JMSWrapSession.tc, "getTransacted", new Boolean(var1_2));
        }
        return var1_2;
    }

    public void recover() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover");
        }
        try {
            block17: {
                block16: {
                    if (this.closed) {
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Closed");
                        throw illegalStateException;
                    }
                    if (this.transacted) break block16;
                    if (!this.isGlobalTransactionActive()) break block17;
                }
                throw new javax.jms.IllegalStateException("Method not allowed Exception");
            }
            Session session = this.getNonXASession();
            if (session != null) {
                session.recover();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.recover", "623", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in recover: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover");
            }
        }
    }

    public void commit() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        try {
            if (this.closed) {
                throw new javax.jms.IllegalStateException("Closed");
            }
            if (this.isGlobalTransactionActive()) {
                throw new TransactionInProgressException("Attempt to call session.commit() in a global transaction");
            }
            if (!this.transacted) {
                throw new javax.jms.IllegalStateException("Method not allowed exception");
            }
            Session session = this.getNonXASession();
            if (session != null) {
                session.commit();
                this.delistFromLocalTransaction();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "684", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in commit: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public void rollback() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        try {
            if (this.closed) {
                throw new javax.jms.IllegalStateException("Closed");
            }
            if (this.isGlobalTransactionActive()) {
                throw new TransactionInProgressException("Attempt to call session.rollback() in a global transaction");
            }
            if (!this.transacted) {
                throw new javax.jms.IllegalStateException("Method not allowed exception");
            }
            Session session = this.getNonXASession();
            if (session != null) {
                session.rollback();
                this.delistFromLocalTransaction();
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "745", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in rollback: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method not allowed exception");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMSException in run: ", (Object)illegalStateException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", messageListener);
        }
        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("Method Not Allowed Exception");
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMSException in setMessageListener: ", (Object)illegalStateException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageListener");
        }
        throw illegalStateException;
    }

    public void internalSetMessageListener(MessageListener messageListener) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalSetMessageListener", messageListener);
        }
        try {
            Session session = this.getNonXASession();
            if (session != null) {
                session.setMessageListener(messageListener);
            } else if (this.sessionFromXASession != null) {
                this.sessionFromXASession.setMessageListener(messageListener);
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.internalSetMessageListener", "848", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in internalSetMessageListener: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "internalSetMessageListener");
            }
        }
    }

    public void enlist() throws JMSException {
        this.handleTransaction(this.getCurrentTransactionType());
    }

    public Session getSession(boolean bl) throws JMSException {
        Session session;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSession", new Boolean(bl));
            }
            session = null;
            try {
                if (this.closed) {
                    throw new javax.jms.IllegalStateException("Attempt to use closed session");
                }
                if (bl) {
                    Session session2;
                    if (this.enlistedOnePhase && (session2 = this.getNonXASession()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Committing outstanding local transaction work before starting global transaction work");
                        }
                        session2.commit();
                        this.delistFromLocalTransaction();
                    }
                    if (this.xaCapable) {
                        if (this.xaSession == null) {
                            this.xaSession = this.createXASession();
                            this.sessionFromXASession = this.retrieveSessionFromXASession(this.xaSession);
                        }
                        session = this.sessionFromXASession;
                    } else {
                        if (this.transactedSession == null) {
                            this.transactedSession = this.createNonXASession(true, this.acknowledgeMode);
                        }
                        session = this.transactedSession;
                    }
                    break block17;
                }
                if (this.enlistedTwoPhase) {
                    throw new javax.jms.IllegalStateException("Attempt to use session outside of global transaction with which it is enlisted");
                }
                session = this.getNonXASession();
                if (session != null) break block17;
                session = this.transacted ? (this.transactedSession = this.createNonXASession(this.transacted, this.acknowledgeMode)) : (this.nonTransactedSession = this.createNonXASession(this.transacted, this.acknowledgeMode));
            }
            catch (JMSException jMSException) {
                try {
                    FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.getSession", "976", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "JMSException in getSession: ", (Object)jMSException);
                    }
                    throw jMSException;
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSession", session);
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSession", session);
        }
        return session;
    }

    synchronized void _close() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_close");
        }
        boolean bl = true;
        boolean bl2 = true;
        try {
            if (this.enlistedOnePhase) {
                if (this.onePhaseXAResource == null) {
                    this.enlistedOnePhase = false;
                    this.getNonXASession().commit();
                } else {
                    bl2 = false;
                }
            } else if (this.enlistedTwoPhase) {
                if (this.xaCapable) {
                    bl = false;
                } else {
                    bl2 = false;
                }
            }
            if (bl2 && this.transactedSession != null) {
                this.transactedSession.close();
                this.transactedSession = null;
            }
            if (this.nonTransactedSession != null) {
                this.nonTransactedSession.close();
                this.nonTransactedSession = null;
            }
            if (this.sessionFromXASession != null) {
                this.sessionFromXASession.close();
                this.sessionFromXASession = null;
            }
            if (bl && this.xaSession != null) {
                this.xaSession.close();
                this.xaSession = null;
            }
            this.closed = true;
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession._close", "1078", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in _close: ", (Object)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_close");
            }
        }
    }

    void handleTransaction(int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleTransaction", new Integer(n));
        }
        try {
            if (n == GLOBAL_TRANSACTION) {
                this.enlistWithGlobalTransaction();
            } else if (this.transacted) {
                if (n == LOCAL_TRANSACTION) {
                    if (ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData() instanceof EJBComponentMetaData) {
                        this.enlistWithLocalTransaction();
                    } else {
                        this.enlistedOnePhase = true;
                    }
                } else {
                    this.enlistedOnePhase = true;
                }
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.handleTransaction", "1147", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in handleTransaction: ", (Object)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleTransaction");
            }
        }
    }

    Session getAnySession() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnySession");
        }
        Session session = null;
        try {
            if (this.closed) {
                throw new javax.jms.IllegalStateException("Attempt to use closed session");
            }
            session = this.getNonXASession();
            if (session == null) {
                session = this.sessionFromXASession != null ? this.sessionFromXASession : this.getSession(this.isGlobalTransactionActive());
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.getAnySession", "1208", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "JMSException in getAnySession: ", (Object)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAnySession", session);
            }
        }
        return session;
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isEnlistedTwoPhase() {
        return this.enlistedTwoPhase;
    }

    Session getNonXASession() {
        Session session = this.transacted ? this.transactedSession : this.nonTransactedSession;
        return session;
    }

    static boolean isGlobalTransactionActive() throws JMSException {
        return JMSWrapSession.getCurrentTransactionType() == GLOBAL_TRANSACTION;
    }

    static int getCurrentTransactionType() throws JMSException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentTransactionType");
        }
        switch (TransactionManagerFactory.getUOWCurrent().getUOWType()) {
            case 2: {
                n = GLOBAL_TRANSACTION;
                break;
            }
            case 1: {
                n = LOCAL_TRANSACTION;
                break;
            }
            default: {
                n = NO_TRANSACTION;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentTransactionType", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enlistWithGlobalTransaction() throws JMSException {
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "enlistWithGlobalTransaction");
            }
            WebSphereTransactionManager webSphereTransactionManager = TransactionManagerFactory.getTransactionManager();
            try {
                Transaction transaction;
                try {
                    transaction = webSphereTransactionManager.getTransaction();
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1377", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException from getTransaction", (Object)systemException);
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                    illegalStateException.setLinkedException((Exception)((Object)systemException));
                    throw illegalStateException;
                }
                if (this.enlistedTwoPhase) {
                    if (!this.transaction.equals(transaction)) {
                        throw new javax.jms.IllegalStateException("Attempt to use JMSWrapSession in global transaction while still active in another global transaction");
                    }
                    break block28;
                }
                if (!this.registeredTwoPhase) {
                    try {
                        transaction.registerSynchronization((javax.transaction.Synchronization)new Synchronization());
                        this.registeredTwoPhase = true;
                    }
                    catch (RollbackException rollbackException) {
                        FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1388", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "RollbackException from register", (Object)rollbackException);
                        }
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("RollbackException");
                        illegalStateException.setLinkedException((Exception)((Object)rollbackException));
                        throw illegalStateException;
                    }
                    catch (SystemException systemException) {
                        FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1400", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "SystemException from register", (Object)systemException);
                        }
                        javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                        illegalStateException.setLinkedException((Exception)((Object)systemException));
                        throw illegalStateException;
                    }
                }
                try {
                    XAResource xAResource;
                    if (this.xaCapable) {
                        xAResource = this.xaSession.getXAResource();
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Using OnePhaseXAResource for last agent optimization");
                        }
                        xAResource = new OnePhaseXAResource();
                        this.parentConnection.incrementSessionCount();
                    }
                    if (xAResource instanceof MQXAResource) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Enlisting MQ XAResource");
                        }
                        String string = ((MQXAResource)xAResource).getResourceString();
                        JMSXAResourceInfo jMSXAResourceInfo = new JMSXAResourceInfo(string);
                        webSphereTransactionManager.enlist(xAResource, "com.ibm.ejs.jms.mq.JMSXAResourceFactory", jMSXAResourceInfo);
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Enlisting non-MQ XAResource - will not be recoverable");
                        }
                        transaction.enlistResource(xAResource);
                    }
                    this.transaction = transaction;
                    this.enlistedTwoPhase = true;
                }
                catch (RollbackException rollbackException) {
                    FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1460", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "RollbackException in enlistWithGlobalTransaction", (Object)rollbackException);
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("RollbackException");
                    illegalStateException.setLinkedException((Exception)((Object)rollbackException));
                    throw illegalStateException;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithGlobalTransaction", "1471", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "SystemException in enlistWithGlobalTransaction", (Object)systemException);
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("SystemException");
                    illegalStateException.setLinkedException((Exception)((Object)systemException));
                    throw illegalStateException;
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistWithGlobalTransaction");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enlistWithLocalTransaction() throws JMSException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "enlistWithLocalTransaction");
            }
            try {
                if (this.enlistedOnePhase) break block10;
                try {
                    LocalTransactionCoordinator localTransactionCoordinator = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
                    this.onePhaseXAResource = new OnePhaseXAResource();
                    localTransactionCoordinator.enlistForCleanup(this.onePhaseXAResource);
                    this.parentConnection.incrementSessionCount();
                    this.enlistedOnePhase = true;
                }
                catch (LTCSystemException lTCSystemException) {
                    FFDCFilter.processException((Throwable)lTCSystemException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithLocalTransaction", "1517", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "LTCSystemException in enlistForCleanup", lTCSystemException);
                    }
                    javax.jms.IllegalStateException illegalStateException = new javax.jms.IllegalStateException("LTCSystemException");
                    illegalStateException.setLinkedException((Exception)lTCSystemException);
                    throw illegalStateException;
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.mq.JMSWrapSession.enlistWithLocalTransaction", "1528", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "IllegalStateException from enlistForCleanup", illegalStateException);
                    }
                    javax.jms.IllegalStateException illegalStateException2 = new javax.jms.IllegalStateException("IllegalStateException");
                    illegalStateException2.setLinkedException((Exception)illegalStateException);
                    throw illegalStateException2;
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "enlistWithLocalTransaction");
                }
            }
        }
    }

    protected synchronized void delistFromLocalTransaction() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delistFromLocalTransaction");
        }
        try {
            if (this.enlistedOnePhase) {
                if (this.onePhaseXAResource != null) {
                    LocalTransactionCoordinator localTransactionCoordinator = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
                    localTransactionCoordinator.delistFromCleanup(this.onePhaseXAResource);
                    this.parentConnection.decrementSessionCount();
                    this.onePhaseXAResource = null;
                }
                this.enlistedOnePhase = false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ejs.jms.mq.JMSWrapSession.delistFromLocalTransaction", "1577", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "IllegalStateException from delistFromCleanup", illegalStateException);
            }
            javax.jms.IllegalStateException illegalStateException2 = new javax.jms.IllegalStateException("IllegalStateException");
            illegalStateException2.setLinkedException((Exception)illegalStateException);
            throw illegalStateException2;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delistFromLocalTransaction");
            }
        }
    }

    public List getTemporaryDestinations() {
        return this.temporaryDestinations;
    }

    protected void closeChildren() {
        MessageConsumer messageConsumer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeChildren");
        }
        Iterator iterator = this.messageConsumers.iterator();
        while (iterator.hasNext()) {
            messageConsumer = (MessageConsumer)iterator.next();
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.closeChildren", "1626", this);
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Caught JMSException when closing consumer", (Object)jMSException);
            }
        }
        iterator = this.messageProducers.iterator();
        while (iterator.hasNext()) {
            messageConsumer = (MessageProducer)iterator.next();
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.closeChildren", "1644", this);
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Caught JMSException when closing producer", (Object)jMSException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeChildren");
        }
    }

    protected abstract Session createNonXASession(boolean var1, int var2) throws JMSException;

    protected abstract XASession createXASession() throws JMSException;

    protected abstract Session retrieveSessionFromXASession(XASession var1) throws JMSException;

    class OnePhaseXAResource
    implements com.ibm.ws.Transaction.OnePhaseXAResource {
        protected Xid xid = null;

        OnePhaseXAResource() {
        }

        public String getResourceName() {
            String string;
            try {
                string = new String("JMSSession, provider: " + JMSWrapSession.this.parentConnection.getMetaData().getJMSProviderName() + " " + JMSWrapSession.this.parentConnection.getMetaData().getJMSVersion());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mq.JMSWrapSession.getResourceName", "1788", this);
                string = new String("JMSSession");
            }
            return string;
        }

        public int prepare(Xid xid) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "prepare", xid);
            }
            XAException xAException = new XAException(103);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Attempt to prepare one-phase resource", xAException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare");
            }
            throw xAException;
        }

        public void commit(Xid xid, boolean bl) throws XAException {
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "commit", new Object[]{xid, new Boolean(bl)});
                }
                if (this.xid != null && !xid.equals(this.xid)) {
                    XAException xAException = new XAException(-4);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Xid passed to commit is not valid: ", xAException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit");
                    }
                    throw xAException;
                }
                if (!bl) {
                    XAException xAException = new XAException(-6);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Attempt to perform two-phase commit on one-phase resource", xAException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit");
                    }
                    throw xAException;
                }
                if (JMSWrapSession.this.transactedSession != null) {
                    try {
                        JMSWrapSession.this.transactedSession.commit();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "1880", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "JMSException in commit: ", (Object)jMSException);
                            if (jMSException.getLinkedException() != null) {
                                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit");
                        }
                        throw new XAException(100);
                    }
                }
                if (JMSWrapSession.this.enlistedOnePhase) {
                    JMSWrapSession.this.parentConnection.decrementSessionCount();
                    JMSWrapSession.this.enlistedOnePhase = false;
                    JMSWrapSession.this.onePhaseXAResource = null;
                    if (JMSWrapSession.this.closed) {
                        try {
                            JMSWrapSession.this._close();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.commit", "1910", this);
                            if (!tc.isEventEnabled()) break block18;
                            Tr.event(tc, "JMSException in commit: ", (Object)jMSException);
                            if (jMSException.getLinkedException() == null) break block18;
                            Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                        }
                    }
                }
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }

        public void rollback(Xid xid) throws XAException {
            block13: {
                block12: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "rollback", xid);
                    }
                    if (this.xid != null && !xid.equals(this.xid)) {
                        XAException xAException = new XAException(-4);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Xid passed to rollback is not valid: ", xAException);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "rollback");
                        }
                        throw xAException;
                    }
                    if (JMSWrapSession.this.transactedSession != null) {
                        try {
                            JMSWrapSession.this.transactedSession.rollback();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "1967", this);
                            if (!tc.isEventEnabled()) break block12;
                            Tr.event(tc, "JMSException in rollback: ", (Object)jMSException);
                            if (jMSException.getLinkedException() == null) break block12;
                            Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                        }
                    }
                }
                if (JMSWrapSession.this.enlistedOnePhase) {
                    JMSWrapSession.this.parentConnection.decrementSessionCount();
                    JMSWrapSession.this.enlistedOnePhase = false;
                    JMSWrapSession.this.onePhaseXAResource = null;
                    if (JMSWrapSession.this.closed) {
                        try {
                            JMSWrapSession.this._close();
                        }
                        catch (JMSException jMSException) {
                            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.rollback", "1992", this);
                            if (!tc.isEventEnabled()) break block13;
                            Tr.event(tc, "JMSException in commit: ", (Object)jMSException);
                            if (jMSException.getLinkedException() == null) break block13;
                            Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                        }
                    }
                }
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }

        public void start(Xid xid, int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start", new Object[]{xid, new Integer(n)});
            }
            if (this.xid != null) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Already associated with transaction", xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start");
                }
                throw xAException;
            }
            this.xid = xid;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
        }

        public void end(Xid xid, int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "end", new Object[]{xid, new Integer(n)});
            }
            if (!xid.equals(this.xid)) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Not associated with this transaction", xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "end");
                }
                throw xAException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "end");
            }
        }

        public void forget(Xid xid) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "forget", xid);
            }
            if (!xid.equals(this.xid)) {
                XAException xAException = new XAException(-6);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Not associated with this transaction", xAException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "forget");
                }
                throw xAException;
            }
            this.xid = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forget");
            }
        }

        public Xid[] recover(int n) throws XAException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "recover", new Integer(n));
            }
            Xid[] xidArray = new Xid[]{};
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", xidArray);
            }
            return xidArray;
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isSameRM", xAResource);
            }
            boolean bl2 = bl = xAResource == this;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSameRM", new Boolean(bl));
            }
            return bl;
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int n) throws XAException {
            return false;
        }
    }

    class Synchronization
    implements javax.transaction.Synchronization {
        Synchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "afterCompletion", new Integer(n));
                }
                JMSWrapSession.this.enlistedTwoPhase = false;
                JMSWrapSession.this.transaction = null;
                JMSWrapSession.this.registeredTwoPhase = false;
                if (JMSWrapSession.this.closed) {
                    try {
                        JMSWrapSession.this._close();
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapSession.afterCompletion", "1735", this);
                        if (!tc.isEventEnabled()) break block6;
                        Tr.event(tc, "JMSException in afterCompletion: ", (Object)jMSException);
                        if (jMSException.getLinkedException() == null) break block6;
                        Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                    }
                }
            }
            if (!JMSWrapSession.this.xaCapable) {
                JMSWrapSession.this.parentConnection.decrementSessionCount();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterCompletion");
            }
        }
    }
}

