/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapMessageProducer;
import com.ibm.ejs.jms.mq.JMSWrapXATopicSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class JMSWrapTopicPublisher
extends JMSWrapMessageProducer
implements TopicPublisher {
    private Topic topic;
    private static TraceComponent tc = Tr.register(JMSWrapTopicPublisher.class.getName(), "Messaging");

    JMSWrapTopicPublisher(JMSWrapXATopicSession jMSWrapXATopicSession, Topic topic) {
        super(jMSWrapXATopicSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapTopicPublisher constructor", new Object[]{jMSWrapXATopicSession, topic});
        }
        this.topic = topic;
        Tr.exit(tc, "JMSWrapTopicPublisher constructor");
    }

    public Topic getTopic() throws JMSException {
        Tr.entry(tc, "getTopic");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getTopic: ", (Object)illegalStateException);
            Tr.exit(tc, "getTopic");
            throw illegalStateException;
        }
        Tr.exit(tc, "getTopic", this.topic);
        return this.topic;
    }

    public void publish(Message message) throws JMSException {
        Tr.entry(tc, "publish", "Message contents not traced");
        try {
            this.setupProducer();
            ((TopicPublisher)this.producer).publish(message);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicPublisher.publish", "113", this);
            Tr.event(tc, "JMSException in JMSWrapTopicPublisher publish: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "publish");
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{topic, "Message contents not trace"});
        }
        try {
            this.setupProducer();
            ((TopicPublisher)this.producer).publish(topic, message);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicPublisher.publish", "148", this);
            Tr.event(tc, "JMSException in  publish: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "publish");
        }
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{"Message contents not traced", new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            this.setupProducer();
            ((TopicPublisher)this.producer).publish(message, n, n2, l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicPublisher.publish", "192", this);
            Tr.event(tc, "JMSException in publish: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "publish");
        }
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", new Object[]{topic, "Message contents not traced", new Integer(n), new Integer(n2), new Long(l)});
        }
        try {
            this.setupProducer();
            ((TopicPublisher)this.producer).publish(topic, message, n, n2, l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicPublisher.publish", "238", this);
            Tr.event(tc, "JMSException in publish: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "publish");
        }
    }

    protected MessageProducer createMessageProducer(boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessageProducer", new Boolean(bl));
        }
        TopicPublisher topicPublisher = null;
        try {
            TopicSession topicSession = ((JMSWrapXATopicSession)this.parentSession).getTopicSession(bl);
            topicPublisher = topicSession.createPublisher(this.topic);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicPublisher.createMessageProducer", "278", this);
                Tr.event(tc, "JMSException in createMessageProducer: ", (Object)jMSException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createMessageProducer", topicPublisher);
                throw throwable;
            }
        }
        Tr.exit(tc, "createMessageProducer", topicPublisher);
        return topicPublisher;
    }
}

