/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapMessageConsumer;
import com.ibm.ejs.jms.mq.JMSWrapXATopicSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public abstract class JMSWrapTopicSubscriber
extends JMSWrapMessageConsumer
implements TopicSubscriber {
    private static TraceComponent tc = Tr.register(JMSWrapTopicSubscriber.class.getName(), "Messaging");
    protected Topic topic;
    protected boolean noLocal = false;

    JMSWrapTopicSubscriber(JMSWrapXATopicSession jMSWrapXATopicSession, Topic topic) {
        super(jMSWrapXATopicSession);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapTopicSubscriber constructor", new Object[]{jMSWrapXATopicSession, topic});
        }
        this.topic = topic;
        Tr.exit(tc, "JMSWrapTopicSubscriber constructor");
    }

    JMSWrapTopicSubscriber(JMSWrapXATopicSession jMSWrapXATopicSession, Topic topic, String string, boolean bl) {
        super(jMSWrapXATopicSession, string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMSWrapTopicSubscriber constructor", new Object[]{jMSWrapXATopicSession, topic, string, new Boolean(bl)});
        }
        this.topic = topic;
        this.noLocal = bl;
        Tr.exit(tc, "JMSWrapTopicSubscriber constructor");
    }

    public boolean getNoLocal() throws JMSException {
        Tr.entry(tc, "getNoLocal");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getNoLocal: ", (Object)illegalStateException);
            Tr.exit(tc, "getNoLocal");
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNoLocal", new Boolean(this.noLocal));
        }
        return this.noLocal;
    }

    public Topic getTopic() throws JMSException {
        Tr.entry(tc, "getTopic");
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Closed");
            Tr.event(tc, "JMSException in getTopic: ", (Object)illegalStateException);
            Tr.exit(tc, "getTopic");
            throw illegalStateException;
        }
        Tr.exit(tc, "getTopic", this.topic);
        return this.topic;
    }

    public Message receive() throws JMSException {
        Tr.entry(tc, "receive");
        Message message = null;
        try {
            this.setupConsumer();
            message = ((TopicSubscriber)this.consumer).receive();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicSubscriber.receive", "185", this);
            Tr.event(tc, "JMSException in receive: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            if (message == null) {
                Tr.debug(tc, "No message returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive", "Message contents not traced");
            }
        }
        return message;
    }

    public Message receive(long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive", new Long(l));
        }
        Message message = null;
        try {
            this.setupConsumer();
            message = ((TopicSubscriber)this.consumer).receive(l);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicSubscriber.receive", "226", this);
            Tr.event(tc, "JMSException in JMSWrapTopicSubscriber receive: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            if (message == null) {
                Tr.debug(tc, "No message returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receive", "Message contents not traced");
            }
        }
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveNoWait");
        }
        Message message = null;
        try {
            this.setupConsumer();
            message = ((TopicSubscriber)this.consumer).receiveNoWait();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapTopicSubscriber.receiveNoWait", "262", this);
            Tr.event(tc, "JMSException in receiveNoWait: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            if (message == null) {
                Tr.debug(tc, "No message returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "receiveNoWait", "Message contents not traced");
            }
        }
        return message;
    }
}

