/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapConnection;
import com.ibm.ejs.jms.mq.JMSWrapXAQueueSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;

public class JMSWrapXAQueueConnection
extends JMSWrapConnection
implements QueueConnection {
    private static TraceComponent tc = Tr.register(JMSWrapXAQueueConnection.class.getName(), "Messaging");

    JMSWrapXAQueueConnection(QueueConnection queueConnection) {
        super((Connection)queueConnection);
        Tr.entry(tc, "JMSWrapXAQueueConnection constructor", queueConnection);
        Tr.exit(tc, "JMSWrapXAQueueConnection constructor");
    }

    public synchronized QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createQueueSession", new Object[]{new Boolean(bl), new Integer(n)});
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Attempt to use closed connection");
            Tr.event(tc, "JMSException in createQueueSession: ", (Object)illegalStateException);
            Tr.exit(tc, "createQueueSession");
            throw illegalStateException;
        }
        JMSWrapXAQueueSession jMSWrapXAQueueSession = new JMSWrapXAQueueSession(this, bl, n);
        this.addSession(jMSWrapXAQueueSession);
        Tr.exit(tc, "createQueueSession", jMSWrapXAQueueSession);
        return jMSWrapXAQueueSession;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionConsumer", new Object[]{queue, string, serverSessionPool, new Integer(n)});
        }
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in createConnectionConsumer:  ", (Object)illegalStateException);
        Tr.exit(tc, "createConnectionConsumer");
        throw illegalStateException;
    }

    public QueueSession getQueueSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQueueSession", new Object[]{new Boolean(bl), new Integer(n)});
        }
        JMSWrapXAQueueSession jMSWrapXAQueueSession = null;
        try {
            jMSWrapXAQueueSession = (JMSWrapXAQueueSession)this.createQueueSession(bl, n);
            jMSWrapXAQueueSession.getQueueSession(false);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXAQueueConnection.getQueueSession", "163", this);
            Tr.event(tc, "JMSException in getQueueSession: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "getQueueSession", jMSWrapXAQueueSession);
        }
        return jMSWrapXAQueueSession;
    }

    public QueueSession getXAQueueSession() throws JMSException {
        Tr.entry(tc, "getXAQueueSession");
        JMSWrapXAQueueSession jMSWrapXAQueueSession = null;
        try {
            if (!this.xaCapable) {
                throw new IllegalStateException("XA method called on non-XA connection");
            }
            jMSWrapXAQueueSession = (JMSWrapXAQueueSession)this.createQueueSession(true, 0);
            jMSWrapXAQueueSession.getQueueSession(true);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXAQueueConnection.getXAQueueSession", "210", this);
                Tr.event(tc, "JMSException in getXAQueueSession: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "getXAQueueSession", jMSWrapXAQueueSession);
                throw throwable;
            }
        }
        Tr.exit(tc, "getXAQueueSession", jMSWrapXAQueueSession);
        return jMSWrapXAQueueSession;
    }

    public ConnectionConsumer internalCreateConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalCreateConnectionConsumer", new Object[]{queue, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            connectionConsumer = ((QueueConnection)this.connection).createConnectionConsumer(queue, string, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXAQueueConnection.internalCreateConnectionConsumer", "264", this);
                Tr.event(tc, "JMSException in internalCreateConnectionConsumer: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "internalCreateConnectionConsumer", connectionConsumer);
                throw throwable;
            }
        }
        Tr.exit(tc, "internalCreateConnectionConsumer", connectionConsumer);
        return connectionConsumer;
    }

    QueueSession internalCreateQueueSession(boolean bl, int n) throws JMSException {
        return ((QueueConnection)this.connection).createQueueSession(bl, n);
    }

    XAQueueSession internalCreateXAQueueSession() throws JMSException {
        if (this.xaCapable) {
            return ((XAQueueConnection)this.connection).createXAQueueSession();
        }
        throw new IllegalStateException("XA method called on non-XA connection");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return null;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return null;
    }
}

