/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSWrapConnection;
import com.ibm.ejs.jms.mq.JMSWrapXATopicSession;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;

public class JMSWrapXATopicConnection
extends JMSWrapConnection
implements TopicConnection {
    private static TraceComponent tc = Tr.register(JMSWrapXATopicConnection.class.getName(), "Messaging");

    JMSWrapXATopicConnection(TopicConnection topicConnection) {
        super((Connection)topicConnection);
        Tr.entry(tc, "JMSWrapXATopicConnection constructor", topicConnection);
        try {
            if (topicConnection.getClientID() == null) {
                String string = ServerName.getDisplayName();
                topicConnection.setClientID(string);
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnection.JMSWrapXATopicConnection", "68", this);
            Tr.event(tc, "JMSException in JMSWrapXATopicConnection constructor.  Could not get/set the client ID.", (Object)jMSException);
        }
        Tr.exit(tc, "JMSWrapXATopicConnection constructor");
    }

    public synchronized TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicSession", new Object[]{new Boolean(bl), new Integer(n)});
        }
        if (this.isClosed()) {
            IllegalStateException illegalStateException = new IllegalStateException("Attempt to use closed connection");
            Tr.event(tc, "JMSException in createTopicSession: ", (Object)illegalStateException);
            Tr.exit(tc, "createTopicSession");
            throw illegalStateException;
        }
        JMSWrapXATopicSession jMSWrapXATopicSession = new JMSWrapXATopicSession(this, bl, n);
        this.addSession(jMSWrapXATopicSession);
        Tr.exit(tc, "createTopicSession", jMSWrapXATopicSession);
        return jMSWrapXATopicSession;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConnectionConsumer", new Object[]{topic, string, serverSessionPool, new Integer(n)});
        }
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in createConnectionConsumer: ", (Object)illegalStateException);
        Tr.exit(tc, "createConnectionConsumer");
        throw illegalStateException;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDurableConnectionConsumer", new Object[]{topic, string, string2, serverSessionPool, new Integer(n)});
        }
        IllegalStateException illegalStateException = new IllegalStateException("Method not allowed Exception");
        Tr.event(tc, "JMSException in createDurableConnectionConsumer: ", (Object)illegalStateException);
        Tr.exit(tc, "createDurableConnectionConsumer");
        throw illegalStateException;
    }

    public TopicSession getTopicSession(boolean bl, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTopicSession", new Object[]{new Boolean(bl), new Integer(n)});
        }
        JMSWrapXATopicSession jMSWrapXATopicSession = null;
        try {
            jMSWrapXATopicSession = (JMSWrapXATopicSession)this.createTopicSession(bl, n);
            jMSWrapXATopicSession.getTopicSession(false);
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnection.getTopicSession", "204", this);
            Tr.event(tc, "JMSException in getTopicSession: ", (Object)jMSException);
            if (jMSException.getLinkedException() != null) {
                Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
            }
            throw jMSException;
        }
        finally {
            Tr.exit(tc, "getTopicSession", jMSWrapXATopicSession);
        }
        return jMSWrapXATopicSession;
    }

    public TopicSession getXATopicSession() throws JMSException {
        Tr.entry(tc, "getXATopicSession");
        JMSWrapXATopicSession jMSWrapXATopicSession = null;
        try {
            if (!this.xaCapable) {
                throw new IllegalStateException("XA method called on non-XA connection");
            }
            jMSWrapXATopicSession = (JMSWrapXATopicSession)this.createTopicSession(true, 0);
            jMSWrapXATopicSession.getTopicSession(true);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnection.getXATopicSession", "251", this);
                Tr.event(tc, "JMSException in getXATopicSession: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "getXATopicSession", jMSWrapXATopicSession);
                throw throwable;
            }
        }
        Tr.exit(tc, "getXATopicSession", jMSWrapXATopicSession);
        return jMSWrapXATopicSession;
    }

    public ConnectionConsumer internalCreateConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalCreateConnectionConsumer", new Object[]{topic, string, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            connectionConsumer = ((TopicConnection)this.connection).createConnectionConsumer(topic, string, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnection.internalCreateConnectionConsumer", "303", this);
                Tr.event(tc, "JMSException in internalCreateConnectionConsumer: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "internalCreateConnectionConsumer", connectionConsumer);
                throw throwable;
            }
        }
        Tr.exit(tc, "internalCreateConnectionConsumer", connectionConsumer);
        return connectionConsumer;
    }

    public ConnectionConsumer internalCreateDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "internalCreateDurableConnectionConsumer", new Object[]{topic, string, string2, serverSessionPool, new Integer(n)});
        }
        ConnectionConsumer connectionConsumer = null;
        try {
            connectionConsumer = ((TopicConnection)this.connection).createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnection.internalCreateDurableConnectionConsumer", "361", this);
                Tr.event(tc, "JMSException in internalCreateDurableConnectionConsumer: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "internalCreateDurableConnectionConsumer", connectionConsumer);
                throw throwable;
            }
        }
        Tr.exit(tc, "internalCreateDurableConnectionConsumer", connectionConsumer);
        return connectionConsumer;
    }

    TopicSession internalCreateTopicSession(boolean bl, int n) throws JMSException {
        return ((TopicConnection)this.connection).createTopicSession(bl, n);
    }

    XATopicSession internalCreateXATopicSession() throws JMSException {
        if (this.xaCapable) {
            return ((XATopicConnection)this.connection).createXATopicSession();
        }
        throw new IllegalStateException("XA method called on non-XA connection");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return null;
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return null;
    }
}

