/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.WrapObjectFactory;
import com.ibm.ejs.jms.mq.JMSWrapXATopicConnection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class JMSWrapXATopicConnectionFactory
implements TopicConnectionFactory,
Referenceable {
    private TopicConnectionFactory topicConnectionFactory;
    private boolean xaCapable;
    private static TraceComponent tc = Tr.register(JMSWrapXATopicConnectionFactory.class.getName(), "Messaging");

    public JMSWrapXATopicConnectionFactory(TopicConnectionFactory topicConnectionFactory) {
        Tr.entry(tc, "JMSWrapXATopicConnectionFactory constructor");
        this.topicConnectionFactory = topicConnectionFactory;
        this.xaCapable = topicConnectionFactory instanceof XATopicConnectionFactory;
        Tr.exit(tc, "JMSWrapXATopicConnectionFactory constructor");
    }

    public JMSWrapXATopicConnectionFactory(XATopicConnectionFactory xATopicConnectionFactory) {
        Tr.entry(tc, "JMSWrapXATopicConnectionFactory constructor");
        this.topicConnectionFactory = xATopicConnectionFactory;
        this.xaCapable = true;
        Tr.exit(tc, "JMSWrapXATopicConnectionFactory constructor");
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicConnection");
        }
        JMSWrapXATopicConnection jMSWrapXATopicConnection = null;
        try {
            Object object = this.xaCapable ? ((XATopicConnectionFactory)this.topicConnectionFactory).createXATopicConnection() : this.topicConnectionFactory.createTopicConnection();
            jMSWrapXATopicConnection = new JMSWrapXATopicConnection((TopicConnection)object);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory.createTopicConnection", "128", this);
                Tr.event(tc, "JMSException in createTopicConnection: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception:: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createTopicConnection", jMSWrapXATopicConnection);
                throw throwable;
            }
        }
        Tr.exit(tc, "createTopicConnection", jMSWrapXATopicConnection);
        return jMSWrapXATopicConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTopicConnection", "userid/password not traced");
        }
        JMSWrapXATopicConnection jMSWrapXATopicConnection = null;
        try {
            Object object = this.xaCapable ? ((XATopicConnectionFactory)this.topicConnectionFactory).createXATopicConnection(string, string2) : this.topicConnectionFactory.createTopicConnection(string, string2);
            jMSWrapXATopicConnection = new JMSWrapXATopicConnection((TopicConnection)object);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory.createTopicConnection", "188", this);
                Tr.event(tc, "JMSException in createTopicConnection: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createTopicConnection", jMSWrapXATopicConnection);
                throw throwable;
            }
        }
        Tr.exit(tc, "createTopicConnection", jMSWrapXATopicConnection);
        return jMSWrapXATopicConnection;
    }

    public TopicConnection createNonXATopicConnection() throws JMSException {
        Tr.entry(tc, "createNonXATopicConnection");
        JMSWrapXATopicConnection jMSWrapXATopicConnection = null;
        try {
            TopicConnection topicConnection = this.topicConnectionFactory.createTopicConnection();
            jMSWrapXATopicConnection = new JMSWrapXATopicConnection(topicConnection);
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException((Throwable)jMSException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory.createNonXATopicConnection", "228", this);
                Tr.event(tc, "JMSException in JMSWrapXATopicConnectionFactory createNonXATopicConnection: ", (Object)jMSException);
                if (jMSException.getLinkedException() != null) {
                    Tr.event(tc, "Linked exception: ", jMSException.getLinkedException());
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "createNonXATopicConnection", jMSWrapXATopicConnection);
                throw throwable;
            }
        }
        Tr.exit(tc, "createNonXATopicConnection", jMSWrapXATopicConnection);
        return jMSWrapXATopicConnection;
    }

    public Reference getReference() throws NamingException {
        Tr.entry(tc, "getReference");
        Reference reference = null;
        try {
            Reference reference2 = ((Referenceable)this.topicConnectionFactory).getReference();
            BinaryRefAddr binaryRefAddr = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(reference2);
            objectOutputStream.flush();
            binaryRefAddr = new BinaryRefAddr("WRAP", byteArrayOutputStream.toByteArray());
            reference = new Reference(this.getClass().getName(), binaryRefAddr, WrapObjectFactory.class.getName(), null);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory.getReference", "287", this);
            Tr.event(tc, "Exception in getReference: ", namingException);
            throw namingException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory.getReference", "293", this);
            Tr.event(tc, "Exception in getReference: ", exception);
            NamingException namingException = new NamingException(exception.getClass().getName());
            namingException.setRootCause(exception);
            throw namingException;
        }
        finally {
            Tr.exit(tc, "getReference");
        }
        return reference;
    }

    public XATopicConnectionFactory getProviderObject() {
        if (this.topicConnectionFactory instanceof XATopicConnectionFactory) {
            return (XATopicConnectionFactory)this.topicConnectionFactory;
        }
        return null;
    }

    public TopicConnectionFactory getWrappedFactory() {
        return this.topicConnectionFactory;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JMSWrapXATopicConnectionFactory) {
            return this.topicConnectionFactory.equals(((JMSWrapXATopicConnectionFactory)object).topicConnectionFactory);
        }
        return false;
    }

    public int hashCode() {
        return this.topicConnectionFactory.hashCode();
    }

    public Connection createConnection() throws JMSException {
        return null;
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return null;
    }
}

