/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq;

import com.ibm.ejs.jms.mq.JMSXAResourceInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQXAQueueManager;
import com.ibm.mq.MQXAResource;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.transaction.xa.XAResource;

public class JMSXAResourceFactory
implements XAResourceFactory {
    private static TraceComponent tc = Tr.register(JMSXAResourceFactory.class.getName(), "Messaging");

    public XAResource getXAResource(XAResourceInfo xAResourceInfo) throws XAResourceNotAvailableException {
        Tr.entry(tc, "getXAResource", xAResourceInfo);
        String string = ((JMSXAResourceInfo)xAResourceInfo).getQueueManagerName();
        MQXAResource mQXAResource = null;
        try {
            Class.forName("com.ibm.mq.MQXAQueueManager");
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(string);
            mQXAResource = mQXAQueueManager.getXAResource();
            try {
                MQQueueManager mQQueueManager = mQXAQueueManager.getQueueManager();
                mQQueueManager.disconnect();
            }
            catch (MQException mQException) {
                FFDCFilter.processException((Throwable)mQException, "com.ibm.ejs.jms.mq.JMSXAResourceFactory.getXAResource", "96", this);
                Tr.debug(tc, "Failed to disconnect QManager: " + (Object)((Object)mQException));
            }
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mq.JMSXAResourceFactory.getXAResource", "102", this);
                Tr.event(tc, "getXAResource exception occurred");
                throw new XAResourceNotAvailableException(exception);
            }
            catch (Throwable throwable) {
                Tr.exit(tc, "getXAResource", mQXAResource);
                throw throwable;
            }
        }
        Tr.exit(tc, "getXAResource", mQXAResource);
        return mQXAResource;
    }

    public void destroyXAResource(XAResource xAResource) {
        Tr.entry(tc, "destroyXAResource", xAResource);
        try {
            ((MQXAResource)xAResource).close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.jms.mq.JMSXAResourceFactory.destroyXAResource", "134", this);
            Tr.debug(tc, "Exception occurred", exception);
        }
        Tr.exit(tc, "destroyXAResource");
    }
}

