/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq.pcf;

import com.ibm.ejs.jms.mq.pcf.CommandServer;
import com.ibm.ejs.jms.mq.pcf.CommunicationException;
import com.ibm.ejs.jms.mq.pcf.InvalidArgumentException;
import com.ibm.ejs.jms.mq.pcf.PCFQueueData;
import com.ibm.ejs.jms.mq.pcf.QueueData;
import com.ibm.ejs.jms.mq.pcf.QueueDefinitionException;
import com.ibm.ejs.jms.mq.pcf.QueueDeletionException;
import com.ibm.ejs.jms.mq.pcf.QueueLookupException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;

public class PCFCommandServer
implements CommandServer {
    private PCFMessageAgent agent;
    private MQQueueManager qmgr;
    private static final String MQ_PCF_TRACE_MESSAGES = "com.ibm.ejs.jms.messaging";
    private static final TraceComponent tc = Tr.register(PCFCommandServer.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private Locale locale = Locale.getDefault();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string, String string2, int n, String string3, String string4, String string5) throws CommunicationException {
        try {
            Object[] objectArray;
            if (tc.isEntryEnabled()) {
                objectArray = new Object[]{string, string2, new Integer(n), string3, string4, string5};
                Tr.entry(tc, "constructor", objectArray);
            }
            objectArray = new Hashtable();
            objectArray.put("hostname", string2);
            objectArray.put("port", new Integer(n));
            objectArray.put("channel", string3);
            objectArray.put("userID", string4);
            objectArray.put("password", string5);
            this.createPCFMessageAgent(string, (Hashtable)objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string, String string2, int n, String string3) throws CommunicationException {
        try {
            Object[] objectArray;
            if (tc.isEntryEnabled()) {
                objectArray = new Object[]{string, string2, new Integer(n), string3};
                Tr.entry(tc, "constructor", objectArray);
            }
            objectArray = new Hashtable();
            objectArray.put("hostname", string2);
            objectArray.put("port", new Integer(n));
            objectArray.put("channel", string3);
            this.createPCFMessageAgent(string, (Hashtable)objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string) throws CommunicationException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "constructor", string);
            }
            this.createPCFMessageAgent(string, new Hashtable());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string, String string2, int n, String string3, String string4, String string5, Locale locale) throws CommunicationException {
        try {
            Object[] objectArray;
            if (tc.isEntryEnabled()) {
                objectArray = new Object[]{string, string2, new Integer(n), string3, string4, string5, locale};
                Tr.entry(tc, "constructor", objectArray);
            }
            this.locale = locale;
            objectArray = new Hashtable();
            objectArray.put("hostname", string2);
            objectArray.put("port", new Integer(n));
            objectArray.put("channel", string3);
            objectArray.put("userID", string4);
            objectArray.put("password", string5);
            this.createPCFMessageAgent(string, (Hashtable)objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string, String string2, int n, String string3, Locale locale) throws CommunicationException {
        try {
            Object[] objectArray;
            if (tc.isEntryEnabled()) {
                objectArray = new Object[]{string, string2, new Integer(n), string3, locale};
                Tr.entry(tc, "constructor", objectArray);
            }
            this.locale = locale;
            objectArray = new Hashtable();
            objectArray.put("hostname", string2);
            objectArray.put("port", new Integer(n));
            objectArray.put("channel", string3);
            this.createPCFMessageAgent(string, (Hashtable)objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCFCommandServer(String string, Locale locale) throws CommunicationException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "constructor", new Object[]{string, locale});
            }
            this.locale = locale;
            this.createPCFMessageAgent(string, new Hashtable());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor");
            }
        }
    }

    private void createPCFMessageAgent(String string, Hashtable hashtable) throws CommunicationException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createPCFMessageAgent", new Object[]{string, hashtable});
            }
            this.qmgr = new MQQueueManager(string, hashtable);
            this.agent = new PCFMessageAgent(this.qmgr);
        }
        catch (MQException mQException) {
            FFDCFilter.processException((Throwable)mQException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.createPCFMessageAgent", "232", this);
            throw this.processException(mQException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPCFMessageAgent");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueData lookup(String string) throws CommunicationException, QueueLookupException {
        Object object;
        PCFQueueData pCFQueueData = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "lookup", string);
            }
            PCFMessage pCFMessage = new PCFMessage(13);
            pCFMessage.addParameter(2016, string);
            int[] nArray = new int[]{2016, 20, 2013, 10, 6, 5, 9, 15, 13, 22, 2019, 23, 4, 8, 16, 2029, 2030, 61};
            pCFMessage.addParameter(1002, nArray);
            try {
                object = this.send(pCFMessage);
                try {
                    pCFMessage = object[0];
                    if ((Integer)pCFMessage.getParameterValue(20) != 1) {
                        throw new QueueLookupException("PCFCommandServerQueueNotLocal", this.locale);
                    }
                    pCFQueueData = new PCFQueueData(((String)pCFMessage.getParameterValue(2016)).trim(), false, this.locale);
                    pCFQueueData.setDescription(((String)pCFMessage.getParameterValue(2013)).trim());
                    pCFQueueData.setInhibitPut((Integer)pCFMessage.getParameterValue(10));
                    pCFQueueData.setDefaultPriority((Integer)pCFMessage.getParameterValue(6));
                    pCFQueueData.setDefaultPersistence((Integer)pCFMessage.getParameterValue(5));
                    pCFQueueData.setInhibitGet((Integer)pCFMessage.getParameterValue(9));
                    pCFQueueData.setMaxQueueDepth((Integer)pCFMessage.getParameterValue(15));
                    pCFQueueData.setMaxMessageLength((Integer)pCFMessage.getParameterValue(13));
                    pCFQueueData.setBackoutThreshold((Integer)pCFMessage.getParameterValue(22));
                    pCFQueueData.setBackoutReQueueName(((String)pCFMessage.getParameterValue(2019)).trim());
                    pCFQueueData.setShareability((Integer)pCFMessage.getParameterValue(23));
                    pCFQueueData.setDefaultInputOpenOption((Integer)pCFMessage.getParameterValue(4));
                    pCFQueueData.setHardenGetBackout((Integer)pCFMessage.getParameterValue(8));
                    pCFQueueData.setMessageDeliverySequence((Integer)pCFMessage.getParameterValue(16));
                    pCFQueueData.setClusterName(((String)pCFMessage.getParameterValue(2029)).trim());
                    pCFQueueData.setClusterNameList(((String)pCFMessage.getParameterValue(2030)).trim());
                    pCFQueueData.setDefaultBind((Integer)pCFMessage.getParameterValue(61));
                    pCFQueueData.reset();
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    FFDCFilter.processException((Throwable)invalidArgumentException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.lookup", "357", this);
                    throw new QueueLookupException("PCFCommandServerInvalidQueueSettingsReturned", this.locale);
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.lookup", "360", this);
                    throw new QueueLookupException("PCFCommandServerInvalidSettingTypeReturned", this.locale);
                }
            }
            catch (QueueDefinitionException queueDefinitionException) {
                if (queueDefinitionException.isReason(2085)) {
                    try {
                        pCFQueueData = new PCFQueueData(string, this.locale);
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        FFDCFilter.processException((Throwable)invalidArgumentException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.lookup", "373", this);
                        throw new QueueLookupException("PCFCommandServerQueueNameNotValid", this.locale);
                    }
                }
                throw new QueueLookupException(queueDefinitionException);
            }
            object = pCFQueueData;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookup", pCFQueueData);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup", pCFQueueData);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(QueueData queueData) throws QueueDefinitionException, CommunicationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", queueData);
        }
        try {
            PCFQueueData pCFQueueData = (PCFQueueData)queueData;
            if (pCFQueueData.isNew()) {
                PCFMessage pCFMessage = new PCFMessage(11);
                pCFMessage.addParameter(2016, pCFQueueData.getQueueName());
                pCFMessage.addParameter(20, 1);
                if (pCFQueueData.isModified()) {
                    String string;
                    if (pCFQueueData.modifiedField("description")) {
                        string = pCFQueueData.getDescription();
                        pCFMessage.addParameter(2013, string.length() == 0 ? " " : string);
                    }
                    if (pCFQueueData.modifiedField("inhibitPut")) {
                        pCFMessage.addParameter(10, pCFQueueData.getInhibitPut());
                    }
                    if (pCFQueueData.modifiedField("defaultPriority")) {
                        pCFMessage.addParameter(6, pCFQueueData.getDefaultPriority());
                    }
                    if (pCFQueueData.modifiedField("defaultPersistence")) {
                        pCFMessage.addParameter(5, pCFQueueData.getDefaultPersistence());
                    }
                    if (pCFQueueData.modifiedField("clusterName")) {
                        string = pCFQueueData.getClusterName();
                        pCFMessage.addParameter(2029, string.length() == 0 ? " " : string);
                        pCFMessage.addParameter(2030, " ");
                    }
                    if (pCFQueueData.modifiedField("clusterNameList")) {
                        string = pCFQueueData.getClusterNameList();
                        pCFMessage.addParameter(2030, string.length() == 0 ? " " : string);
                        pCFMessage.addParameter(2029, " ");
                    }
                    if (pCFQueueData.modifiedField("defaultBind")) {
                        pCFMessage.addParameter(61, pCFQueueData.getDefaultBind());
                    }
                    if (pCFQueueData.modifiedField("inhibitGet")) {
                        pCFMessage.addParameter(9, pCFQueueData.getInhibitGet());
                    }
                    if (pCFQueueData.modifiedField("maxQueueDepth")) {
                        pCFMessage.addParameter(15, pCFQueueData.getMaxQueueDepth());
                    }
                    if (pCFQueueData.modifiedField("maxMessageLength")) {
                        pCFMessage.addParameter(13, pCFQueueData.getMaxMessageLength());
                    }
                    if (pCFQueueData.modifiedField("shareability")) {
                        pCFMessage.addParameter(23, pCFQueueData.getShareability());
                    }
                    if (pCFQueueData.modifiedField("defaultInputOpenOptions")) {
                        pCFMessage.addParameter(4, pCFQueueData.getDefaultInputOpenOption());
                    }
                    if (pCFQueueData.modifiedField("messageDeliverySequence")) {
                        pCFMessage.addParameter(16, pCFQueueData.getMessageDeliverySequence());
                    }
                    if (pCFQueueData.modifiedField("backoutThreshold")) {
                        pCFMessage.addParameter(22, pCFQueueData.getBackoutThreshold());
                    }
                    if (pCFQueueData.modifiedField("backoutReQueueName")) {
                        string = pCFQueueData.getBackoutReQueueName();
                        pCFMessage.addParameter(2019, string.length() == 0 ? " " : string);
                    }
                    if (pCFQueueData.modifiedField("hardenGetBackout")) {
                        pCFMessage.addParameter(8, pCFQueueData.getHardenGetBackout());
                    }
                }
                this.send(pCFMessage);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(QueueData queueData) throws QueueDefinitionException, CommunicationException {
        try {
            String string;
            PCFQueueData pCFQueueData;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "modify", queueData);
            }
            if ((pCFQueueData = (PCFQueueData)queueData).isNew()) {
                throw new QueueDefinitionException("PCFCommandServerQueueDoesNotExist", 2085, this.locale);
            }
            if (!pCFQueueData.isModified()) {
                return;
            }
            PCFMessage pCFMessage = new PCFMessage(8);
            pCFMessage.addParameter(2016, pCFQueueData.getQueueName());
            pCFMessage.addParameter(20, 1);
            if (pCFQueueData.modifiedField("description")) {
                string = pCFQueueData.getDescription();
                pCFMessage.addParameter(2013, string.length() == 0 ? " " : string);
            }
            if (pCFQueueData.modifiedField("inhibitPut")) {
                pCFMessage.addParameter(10, pCFQueueData.getInhibitPut());
            }
            if (pCFQueueData.modifiedField("defaultPriority")) {
                pCFMessage.addParameter(6, pCFQueueData.getDefaultPriority());
            }
            if (pCFQueueData.modifiedField("defaultPersistence")) {
                pCFMessage.addParameter(5, pCFQueueData.getDefaultPersistence());
            }
            if (pCFQueueData.modifiedField("clusterName")) {
                string = pCFQueueData.getClusterName();
                pCFMessage.addParameter(2029, string.length() == 0 ? " " : string);
                pCFMessage.addParameter(2030, " ");
            }
            if (pCFQueueData.modifiedField("clusterNameList")) {
                string = pCFQueueData.getClusterNameList();
                pCFMessage.addParameter(2030, string.length() == 0 ? " " : string);
                pCFMessage.addParameter(2029, " ");
            }
            if (pCFQueueData.modifiedField("defaultBind")) {
                pCFMessage.addParameter(61, pCFQueueData.getDefaultBind());
            }
            if (pCFQueueData.modifiedField("inhibitGet")) {
                pCFMessage.addParameter(9, pCFQueueData.getInhibitGet());
            }
            if (pCFQueueData.modifiedField("maxQueueDepth")) {
                pCFMessage.addParameter(15, pCFQueueData.getMaxQueueDepth());
            }
            if (pCFQueueData.modifiedField("maxMessageLength")) {
                pCFMessage.addParameter(13, pCFQueueData.getMaxMessageLength());
            }
            if (pCFQueueData.modifiedField("shareability")) {
                pCFMessage.addParameter(23, pCFQueueData.getShareability());
            }
            if (pCFQueueData.modifiedField("defaultInputOpenOptions")) {
                pCFMessage.addParameter(4, pCFQueueData.getDefaultInputOpenOption());
            }
            if (pCFQueueData.modifiedField("messageDeliverySequence")) {
                pCFMessage.addParameter(16, pCFQueueData.getMessageDeliverySequence());
            }
            if (pCFQueueData.modifiedField("backoutThreshold")) {
                pCFMessage.addParameter(22, pCFQueueData.getBackoutThreshold());
            }
            if (pCFQueueData.modifiedField("backoutReQueueName")) {
                string = pCFQueueData.getBackoutReQueueName();
                pCFMessage.addParameter(2019, string.length() == 0 ? " " : string);
            }
            if (pCFQueueData.modifiedField("hardenGetBackout")) {
                pCFMessage.addParameter(8, pCFQueueData.getHardenGetBackout());
            }
            this.send(pCFMessage);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "modify");
            }
        }
    }

    public void delete(String string) throws QueueDeletionException, CommunicationException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "delete", string);
            }
            PCFMessage pCFMessage = new PCFMessage(12);
            pCFMessage.addParameter(2016, string);
            pCFMessage.addParameter(1007, 1);
            this.send(pCFMessage);
        }
        catch (QueueDefinitionException queueDefinitionException) {
            FFDCFilter.processException((Throwable)queueDefinitionException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.delete", "671", this);
            throw new QueueDeletionException(queueDefinitionException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "delete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "close");
            }
            this.agent.disconnect();
        }
        catch (MQException mQException) {
            FFDCFilter.processException((Throwable)mQException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.close", "695", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An error occured while calling PCFMessageAgent.disconnect", (Object)mQException);
            }
        }
        finally {
            block15: {
                try {
                    this.qmgr.disconnect();
                }
                catch (MQException mQException) {
                    FFDCFilter.processException((Throwable)mQException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.close", "703", this);
                    if (!tc.isEventEnabled()) break block15;
                    Tr.event(tc, "An error occured while calling MQQueueManager.disconnect", (Object)mQException);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    private PCFMessage[] send(PCFMessage pCFMessage) throws QueueDefinitionException, CommunicationException {
        try {
            PCFMessage[] pCFMessageArray;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "send", pCFMessage);
            }
            if ((pCFMessageArray = this.agent.send(pCFMessage, false))[0].getCompCode() == 0) {
                PCFMessage[] pCFMessageArray2 = pCFMessageArray;
                return pCFMessageArray2;
            }
            try {
                QueueDefinitionException queueDefinitionException = new QueueDefinitionException(this.locale);
                for (int i = 0; i < pCFMessageArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, pCFMessageArray[i].toString());
                    }
                    this.processExceptionMessage(pCFMessageArray[i], queueDefinitionException);
                }
                Tr.debug(tc, "Error while attempting to do something with the queue", queueDefinitionException);
                throw queueDefinitionException;
            }
            catch (PCFException pCFException) {
                FFDCFilter.processException((Throwable)((Object)pCFException), "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.send", "743", this);
                QueueDefinitionException queueDefinitionException = new QueueDefinitionException(this.locale);
                queueDefinitionException.addError("PCFCommandServerUnexpectedPCFError", pCFException.reasonCode);
                throw queueDefinitionException;
            }
            catch (MQException mQException) {
                FFDCFilter.processException((Throwable)mQException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.send", "749", this);
                throw this.processException(mQException);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ejs.jms.mq.pcf.PCFCommandServer.send", "753", this);
                throw this.processException(iOException);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    private void processExceptionMessage(PCFMessage pCFMessage, QueueDefinitionException queueDefinitionException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExceptionMessage", pCFMessage);
        }
        try {
            block2 : switch (pCFMessage.getReason()) {
                case 4005: {
                    Object[] objectArray = new Object[]{this.paramIDtoString((Integer)pCFMessage.getParameterValue(1012))};
                    queueDefinitionException.addError("PCFCommandServerInvalidSetting", 4005, objectArray);
                    break;
                }
                case 3090: {
                    queueDefinitionException.addError("PCFCommandServerClusterSettingNotValid", 3090);
                    break;
                }
                case 3008: {
                    queueDefinitionException.addError("PCFCommandServerCommandFailed", 3008);
                    break;
                }
                case 4001: {
                    queueDefinitionException.addError("PCFCommandServerQueueExists", 4001);
                    break;
                }
                case 4008: {
                    try {
                        Tr.debug(tc, "object parameter id", new Integer(pCFMessage.getIntParameterValue(1012)));
                        switch (pCFMessage.getIntParameterValue(1012)) {
                            case 2029: {
                                queueDefinitionException.addError("PCFCommandServerInvaidClusterName", 4008);
                                break block2;
                            }
                            case 2030: {
                                queueDefinitionException.addError("PCFCommandServerInvaidClusterNameList", 4008);
                                break block2;
                            }
                            case 2016: {
                                queueDefinitionException.addError("PCFCommandServerInvaidQueueName", 4008);
                                break block2;
                            }
                            case 2019: {
                                queueDefinitionException.addError("PCFCommandServerInvaidBackoutReQueueName", 4008);
                                break block2;
                            }
                            case 2013: {
                                queueDefinitionException.addError("PCFCommandServerInvaidQueueDescription", 4008);
                                break block2;
                            }
                        }
                        queueDefinitionException.addError("PCFCommandServerInvaidParameter", 4008);
                    }
                    catch (PCFException pCFException) {
                        queueDefinitionException.addError("PCFCommandServerInvaidParameter", 4008);
                    }
                    break;
                }
                case 4004: {
                    queueDefinitionException.addError("PCFCommandServerQueueOpen", 4004);
                    break;
                }
                default: {
                    queueDefinitionException.addError("PCFCommandServerUnexpectedPCFError", pCFMessage.getReason());
                }
            }
        }
        catch (Throwable throwable) {
            Tr.event(tc, "Some horrible error I don't know what it is", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExceptionMessage");
        }
    }

    private CommunicationException processException(MQException mQException) {
        CommunicationException communicationException;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "processException", (Object)mQException);
        }
        switch (mQException.reasonCode) {
            case 2009: {
                communicationException = new CommunicationException("PCFCommandServerUnableToConnectToQueueManager", mQException.reasonCode, this.locale);
                break;
            }
            case 2273: {
                communicationException = new CommunicationException("PCFCommandServerConnectionError", mQException.reasonCode, this.locale);
                break;
            }
            case 2030: {
                communicationException = new CommunicationException("PCFCommandServerMessageTooBigForQueue", mQException.reasonCode, this.locale);
                break;
            }
            case 2035: {
                communicationException = new CommunicationException("PCFCommandServerNotAuthorized", mQException.reasonCode, this.locale);
                break;
            }
            case 2137: {
                communicationException = new CommunicationException("PCFCommandServerOpenFailed", mQException.reasonCode, this.locale);
                break;
            }
            case 2058: {
                communicationException = new CommunicationException("PCFCommandServerQueueManagerNameError", mQException.reasonCode, this.locale);
                break;
            }
            case 2059: {
                communicationException = new CommunicationException("PCFCommandServerQueueManagerNotAvailable", mQException.reasonCode, this.locale);
                break;
            }
            case 2161: {
                communicationException = new CommunicationException("PCFCommandServerQueueManagerQuiescing", mQException.reasonCode, this.locale);
                break;
            }
            case 2162: {
                communicationException = new CommunicationException("PCFCommandServerQueueManagerStopping", mQException.reasonCode, this.locale);
                break;
            }
            case 2055: {
                communicationException = new CommunicationException("PCFCommandServerQueueNotEmpty", mQException.reasonCode, this.locale);
                break;
            }
            case 2067: {
                communicationException = new CommunicationException("PCFCommandServerSelectorError", mQException.reasonCode, this.locale);
                break;
            }
            case 2071: {
                communicationException = new CommunicationException("PCFCommandServerNotEnoughStorage", mQException.reasonCode, this.locale);
                break;
            }
            case 2085: {
                communicationException = new CommunicationException("PCFCommandServerQueueDoesNotExist", mQException.reasonCode, this.locale);
                break;
            }
            default: {
                communicationException = new CommunicationException(this.locale);
                communicationException.addError("PCFCommandServerUnexpectedMQError", mQException.reasonCode);
            }
        }
        return communicationException;
    }

    private CommunicationException processException(IOException iOException) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "processException", iOException);
        }
        return new CommunicationException("PCFCommandServerUnexpectedIOError", this.locale);
    }

    public void finalize() {
        this.close();
    }

    private String paramIDtoString(int n) {
        String string = "";
        switch (n) {
            case 2016: {
                string = "Queue name";
                break;
            }
            case 20: {
                string = "Queue type";
                break;
            }
            case 2013: {
                string = "Queue description";
                break;
            }
            case 10: {
                string = "inhibit put";
                break;
            }
            case 6: {
                string = "default priority";
                break;
            }
            case 5: {
                string = "default persistence";
                break;
            }
            case 9: {
                string = "inhibit get";
                break;
            }
            case 15: {
                string = "Queue depth";
                break;
            }
            case 13: {
                string = "maximum message length";
                break;
            }
            case 22: {
                string = "backout threshold";
                break;
            }
            case 2019: {
                string = "backout re-queue Queue name";
                break;
            }
            case 23: {
                string = "shareability";
                break;
            }
            case 4: {
                string = "default input open option";
                break;
            }
            case 8: {
                string = "harden get backout";
                break;
            }
            case 16: {
                string = "message delivery sequence";
                break;
            }
            case 2029: {
                string = "cluster name";
                break;
            }
            case 2030: {
                string = "cluster name list";
                break;
            }
            case 61: {
                string = "default bind";
                break;
            }
            default: {
                string = "an unknown";
            }
        }
        return string;
    }
}

