/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq.pcf;

import com.ibm.ejs.jms.mq.pcf.CommandServer;
import com.ibm.ejs.jms.mq.pcf.CommandServerFactory;
import com.ibm.ejs.jms.mq.pcf.CommunicationException;
import com.ibm.ejs.jms.mq.pcf.QueueData;
import com.ibm.ejs.jms.mq.pcf.QueueDefinerConstants;
import com.ibm.ejs.jms.mq.pcf.QueueDefinerException;
import com.ibm.ejs.jms.mq.pcf.QueueDefinitionException;
import com.ibm.ejs.jms.mq.pcf.QueueLookupException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class WMQQueueDefiner
implements QueueDefinerConstants {
    private static final String MQ_PCF_TRACE_MESSAGES = "com.ibm.ejs.jms.messaging";
    private static final TraceComponent tc = Tr.register(WMQQueueDefiner.class, "Messaging", "com.ibm.ejs.jms.messaging");
    private static final String DEFAULT_QUEUE_MANAGER_NAME = "";
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final int DEFAULT_PORT_NUMBER = 1414;
    private static final String DEFAULT_CHANNEL_NAME = "SYSTEM.DEF.SVRCONN";

    public Properties query(Properties properties) throws QueueDefinerException {
        Object object;
        Properties properties2;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "query", properties);
            }
            properties2 = null;
            Locale locale = Locale.getDefault();
            CommandServer commandServer = null;
            try {
                Object object2;
                String string = DEFAULT_QUEUE_MANAGER_NAME;
                String string2 = DEFAULT_HOST_NAME;
                int n = 1414;
                String string3 = DEFAULT_CHANNEL_NAME;
                if (properties.containsKey("Locale")) {
                    object2 = properties.get("Locale");
                    if (object2 instanceof Locale) {
                        locale = (Locale)object2;
                    } else {
                        Tr.debug(tc, "object specified as locale is not a locale", object2);
                    }
                }
                if (!properties.containsKey("Queue Name")) {
                    throw new QueueLookupException("PCFCommandServerMQQueueNameNotSpecified", locale);
                }
                String string4 = properties.getProperty("Queue Name").trim();
                if (properties.containsKey("Queue Manager Name")) {
                    string = properties.getProperty("Queue Manager Name").trim();
                } else {
                    properties.put("Queue Manager Name", string);
                }
                if (properties.containsKey("Host Name")) {
                    string2 = properties.getProperty("Host Name").trim();
                }
                if (properties.containsKey("Port Number")) {
                    try {
                        n = Integer.parseInt(properties.getProperty("Port Number").trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "query", numberFormatException);
                        }
                        FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.queryQueue", "136", this);
                        throw new CommunicationException("PCFCommandServerPortNotANumber", locale);
                    }
                }
                if (properties.containsKey("Channel Name")) {
                    string3 = properties.getProperty("Channel Name").trim();
                }
                if (properties.containsKey("User Name") && properties.containsKey("Password") && properties.containsKey("Host Name") && properties.containsKey("Port Number") && properties.containsKey("Channel Name")) {
                    object2 = properties.getProperty("User Name").trim();
                    object = properties.getProperty("Password").trim();
                    commandServer = CommandServerFactory.createCommandServer(string, string2, n, string3, (String)object2, (String)object, locale);
                } else {
                    commandServer = properties.containsKey("Host Name") && properties.containsKey("Port Number") && properties.containsKey("Channel Name") ? CommandServerFactory.createCommandServer(string, string2, n, string3, locale) : CommandServerFactory.createCommandServer(string, locale);
                }
                object2 = commandServer.lookup(string4);
                properties2 = new Properties();
                properties2.putAll((Map<?, ?>)properties);
                properties2.setProperty("Queue Description", object2.getDescription());
                properties2.setProperty("Inhibit Put", object2.getInhibitPut() == 1 ? "Inhibited" : "Allowed");
                properties2.setProperty("Default Persistence", object2.getDefaultPersistence() == 1 ? "Persistent" : "Not Persistent");
                properties2.setProperty("Cluster Name", object2.getClusterName());
                properties2.setProperty("Cluster Name List", object2.getClusterNameList());
                properties2.setProperty("Default Bind", object2.getDefaultBind() == 1 ? "Not Fixed" : "On Open");
                properties2.setProperty("Inhibit Get", object2.getInhibitGet() == 1 ? "Inhibited" : "Allowed");
                properties2.setProperty("Max Queue Depth", Integer.toString(object2.getMaxQueueDepth()));
                properties2.setProperty("Max Message Length", Integer.toString(object2.getMaxMessageLength()));
                properties2.setProperty("Shareability", object2.getShareability() == 0 ? "Not Shareable" : "Shareable");
                properties2.setProperty("Default Input Open Options", object2.getDefaultInputOpenOption() == 4 ? "Exclusive" : "Shared");
                properties2.setProperty("Message Delivery Sequence", object2.getMessageDeliverySequence() == 1 ? "FIFO" : "Priority");
                properties2.setProperty("Backout Threshold", Integer.toString(object2.getBackoutThreshold()));
                properties2.setProperty("Backout Requeue Name", object2.getBackoutReQueueName());
                properties2.setProperty("Harden Get Backout", object2.getHardenGetBackout() == 1 ? "Hardened" : "Not Hardened");
                properties2.setProperty("Default Priority", Integer.toString(object2.getDefaultPriority()));
                if (!object2.isNew()) {
                    properties2.setProperty("Exists", "true");
                }
                object = properties2;
                if (commandServer == null) break block24;
                commandServer.close();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "query", noClassDefFoundError);
                    }
                    FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.queryQueue", "141", this);
                    throw new QueueLookupException("PCFCommandServerMQClientNotPresent", locale);
                }
                catch (Throwable throwable) {
                    if (commandServer != null) {
                        commandServer.close();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "query", properties2);
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "query", properties2);
        }
        return object;
    }

    public void update(Properties properties) throws QueueDefinerException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", properties);
        }
        Locale locale = Locale.getDefault();
        CommandServer commandServer = null;
        try {
            Object object;
            String string = DEFAULT_QUEUE_MANAGER_NAME;
            String string2 = DEFAULT_HOST_NAME;
            int n = 1414;
            String string3 = DEFAULT_CHANNEL_NAME;
            if (properties.containsKey("Locale") && (object = properties.get("Locale")) instanceof Locale) {
                locale = (Locale)object;
            }
            if (!properties.containsKey("Queue Name")) {
                throw new QueueDefinitionException("PCFCommandServerMQQueueNameNotSpecified", locale);
            }
            String string4 = properties.getProperty("Queue Name").trim();
            if (properties.containsKey("Queue Manager Name")) {
                string = properties.getProperty("Queue Manager Name").trim();
            }
            if (properties.containsKey("Host Name")) {
                string2 = properties.getProperty("Host Name").trim();
            }
            if (properties.containsKey("Port Number")) {
                try {
                    n = Integer.parseInt(properties.getProperty("Port Number").trim());
                }
                catch (NumberFormatException numberFormatException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "update", numberFormatException);
                    }
                    FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.update", "282", this);
                    throw new CommunicationException("PCFCommandServerPortNotANumber", locale);
                }
            }
            if (properties.containsKey("Channel Name")) {
                string3 = properties.getProperty("Channel Name").trim();
            }
            if (properties.containsKey("User Name") && properties.containsKey("Password") && !properties.getProperty("User Name").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && !properties.getProperty("Password").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && properties.containsKey("Host Name") && properties.containsKey("Port Number") && properties.containsKey("Channel Name") && !properties.getProperty("Host Name").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && !properties.getProperty("Port Number").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && !properties.getProperty("Channel Name").trim().equals(DEFAULT_QUEUE_MANAGER_NAME)) {
                object = properties.getProperty("User Name").trim();
                String string5 = properties.getProperty("Password").trim();
                commandServer = CommandServerFactory.createCommandServer(string, string2, n, string3, (String)object, string5, locale);
            } else {
                commandServer = properties.containsKey("Host Name") && properties.containsKey("Port Number") && properties.containsKey("Channel Name") && !properties.getProperty("Host Name").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && !properties.getProperty("Port Number").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) && !properties.getProperty("Channel Name").trim().equals(DEFAULT_QUEUE_MANAGER_NAME) ? CommandServerFactory.createCommandServer(string, string2, n, string3, locale) : CommandServerFactory.createCommandServer(string, locale);
            }
            object = commandServer.lookup(string4);
            if (properties.containsKey("Queue Description")) {
                object.setDescription(properties.getProperty("Queue Description").trim());
            }
            if (properties.containsKey("Inhibit Put")) {
                object.setInhibitPut(properties.getProperty("Inhibit Put").trim().equals("Inhibited") ? 1 : 0);
            }
            if (properties.containsKey("Default Persistence")) {
                object.setDefaultPersistence(properties.getProperty("Default Persistence").trim().equals("Not Persistent") ? 0 : 1);
            }
            if (properties.containsKey("Cluster Name")) {
                object.setClusterName(properties.getProperty("Cluster Name").trim());
            }
            if (properties.containsKey("Cluster Name List")) {
                object.setClusterNameList(properties.getProperty("Cluster Name List").trim());
            }
            if (properties.containsKey("Default Bind")) {
                object.setDefaultBind(properties.getProperty("Default Bind").trim().equals("Not Fixed") ? 1 : 0);
            }
            if (properties.containsKey("Inhibit Get")) {
                object.setInhibitGet(properties.getProperty("Inhibit Get").trim().equals("Inhibited") ? 1 : 0);
            }
            if (properties.containsKey("Max Queue Depth")) {
                try {
                    object.setMaxQueueDepth(Integer.parseInt(properties.getProperty("Max Queue Depth").trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "update", numberFormatException);
                    }
                    FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.update", "228", this);
                    throw new QueueDefinitionException("PCFCommandQueueDepthNotANumber", locale);
                }
            }
            if (properties.containsKey("Max Message Length")) {
                try {
                    object.setMaxMessageLength(Integer.parseInt(properties.getProperty("Max Message Length").trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "update", numberFormatException);
                    }
                    FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.update", "237", this);
                    throw new QueueDefinitionException("PCFCommandServerMaximumMessageLengthNotANumber", locale);
                }
            }
            if (properties.containsKey("Shareability")) {
                object.setShareability(properties.getProperty("Shareability").trim().equals("Not Shareable") ? 0 : 1);
            }
            if (properties.containsKey("Default Input Open Options")) {
                object.setDefaultInputOpenOption(properties.getProperty("Default Input Open Options").trim().equals("Exclusive") ? 4 : 2);
            }
            if (properties.containsKey("Message Delivery Sequence")) {
                object.setMessageDeliverySequence(properties.getProperty("Message Delivery Sequence").trim().equals("FIFO") ? 1 : 0);
            }
            if (properties.containsKey("Backout Threshold")) {
                try {
                    object.setBackoutThreshold(Integer.parseInt(properties.getProperty("Backout Threshold").trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "update", numberFormatException);
                    }
                    FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.update", "253", this);
                    throw new QueueDefinitionException("PCFCommandServerBackoutThresholdNotANumber", locale);
                }
            }
            if (properties.containsKey("Default Priority")) {
                try {
                    object.setDefaultPriority(Integer.parseInt(properties.getProperty("Default Priority").trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "update", numberFormatException);
                    }
                    FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.update", "262", this);
                    throw new QueueDefinitionException("PCFCommandServerPriorityNotANumber", locale);
                }
            }
            if (properties.containsKey("Backout Requeue Name")) {
                object.setBackoutReQueueName(properties.getProperty("Backout Requeue Name").trim());
            }
            if (properties.containsKey("Harden Get Backout")) {
                object.setHardenGetBackout(properties.getProperty("Harden Get Backout").trim().equals("Hardened") ? 1 : 0);
            }
            if (object.isNew()) {
                commandServer.create((QueueData)object);
            } else {
                commandServer.modify((QueueData)object);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "update", noClassDefFoundError);
            }
            FFDCFilter.processException((Throwable)noClassDefFoundError, "com.ibm.ejs.jms.mq.pcf.WMQQueueDefiner.queryQueue", "285", this);
            throw new QueueLookupException("PCFCommandServerMQClientNotPresent", locale);
        }
        finally {
            if (commandServer != null) {
                commandServer.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "update");
            }
        }
    }
}

