/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.registration;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;

public final class JVMUtils {
    private static final TraceComponent _tc = Tr.register(JVMUtils.class, "Messaging", JMSCMUtils.MSG_BUNDLE);

    public static final boolean isIBMJVM() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isIBMJVM");
        }
        boolean bl = "IBM J9 VM".equals(System.getProperty("java.vm.name"));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isIBMJVM", new Boolean(bl));
        }
        return bl;
    }

    public static final boolean is32Bit(File file) {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "is32Bit", new Object[]{file});
        }
        String string = System.getProperty("sun.arch.data.model", null);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The bitMode taken by looking at sun.arch.data.model is " + string);
        }
        string = System.getProperty("com.ibm.vm.bitmode", string);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The bitMode taken by looking at com.ibm.vm.bitmode is " + string);
        }
        if ("64".equals(string)) {
            bl = false;
        } else if ("32".equals(string)) {
            bl = true;
        } else if (file == null || !file.exists()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "We couldn't find a 64-bit library so we assume 32-bit mode");
            }
            bl = true;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "We have not found out the bit mode by all our other means, so we are going to have to try to load the 64-bit library.");
            }
            try {
                System.load(file.getAbsolutePath());
                bl = false;
            }
            catch (Throwable throwable) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "absorbing", throwable);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Unable to load the 64-bit libraries, must be 32-bit so use 32-bit libraries");
                }
                bl = true;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "is32Bit", new Boolean(bl));
        }
        return bl;
    }

    public static boolean updateJavaLibraryPath(File file) {
        boolean bl = false;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateJavaLibraryPath", file);
        }
        if (file != null && file.exists() && JVMUtils.isIBMJVM()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(System.getProperty("java.library.path"));
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(file.getAbsolutePath());
            System.setProperty("java.library.path", stringBuffer.toString());
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateJavaLibraryPath");
        }
        return bl;
    }
}

