/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.registration;

import com.ibm.ejs.jms.JMSCMUtils;
import com.ibm.ejs.jms.registration.JVMUtils;
import com.ibm.ejs.jms.registration.Version;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

public final class MA88Install {
    private static final TraceComponent _tc = Tr.register(MA88Install.class, "Messaging", JMSCMUtils.MSG_BUNDLE);
    private static final String WMQ_JAVA_DIR = "/java/lib";
    private static final String WMQ_JAVA_64_DIR = "/java/lib64";
    private File _mqInstallPath;
    private File _ma88JavaPath;
    private File _ma88NativePath;
    private boolean _valid;
    private Version _version;
    private String _toString = "";

    public MA88Install(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MA88Install", string);
        }
        if (string == null) {
            this._mqInstallPath = null;
        } else if (string.startsWith("file:/")) {
            try {
                this._mqInstallPath = new File(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Caught URISyntaxException: " + uRISyntaxException);
                }
                String string2 = string.substring("file:/".length());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Handmade mqInstallPath is: " + string2);
                }
                this._mqInstallPath = new File(string2);
            }
        } else {
            this._mqInstallPath = new File(string);
        }
        this._toString = this._mqInstallPath == null ? string : this._mqInstallPath.getAbsolutePath();
        this.validateMA88Path(this._mqInstallPath);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "MA88Install", this);
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public File getInstallRoot() {
        return this._mqInstallPath;
    }

    public File[] getJars() {
        File[] fileArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJars", this);
        }
        if ((fileArray = this._ma88JavaPath.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("jar");
            }
        })) == null) {
            fileArray = new File[]{};
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJars", fileArray);
        }
        return fileArray;
    }

    public File[] getNativeLibraries() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNativeLibraries", this);
        }
        File[] fileArray = new File[]{};
        if (!JVMUtils.isIBMJVM()) {
            File file = new File(this._mqInstallPath, WMQ_JAVA_64_DIR);
            if (file.exists() && file.isDirectory()) {
                File file2;
                String string = System.mapLibraryName("mqjbnd05");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "system library name is " + string);
                }
                if (JVMUtils.is32Bit(file2 = new File(file, string))) {
                    file = new File(this._mqInstallPath, WMQ_JAVA_DIR);
                }
                if ((fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.getName().endsWith("dll")) {
                            return true;
                        }
                        if (file.getName().endsWith("DLL")) {
                            return true;
                        }
                        if (file.getName().endsWith("so")) {
                            return true;
                        }
                        return file.getName().endsWith("sl");
                    }
                })) == null) {
                    fileArray = new File[]{};
                }
            } else {
                file = new File(this._mqInstallPath, WMQ_JAVA_DIR);
                fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.getName().endsWith("dll")) {
                            return true;
                        }
                        if (file.getName().endsWith("DLL")) {
                            return true;
                        }
                        if (file.getName().endsWith("so")) {
                            return true;
                        }
                        return file.getName().endsWith("sl");
                    }
                });
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNativeLibraries", fileArray);
        }
        return fileArray;
    }

    public Version getVersion() {
        return this._version;
    }

    private void validateMA88Path(File file) {
        boolean bl;
        block21: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "validateMA88Path", new Object[]{file, this});
            }
            bl = true;
            if (file == null) {
                bl = false;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The MA88 path is null");
                }
            } else if (file.exists() && file.isDirectory()) {
                try {
                    this._ma88JavaPath = new File(this._mqInstallPath, WMQ_JAVA_DIR);
                    File[] fileArray = this.getJars();
                    URL[] uRLArray = new URL[fileArray.length];
                    for (int i = 0; i < fileArray.length; ++i) {
                        uRLArray[i] = fileArray[i].toURL();
                    }
                    URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                    Class<?> clazz = uRLClassLoader.loadClass("com.ibm.mq.MQEnvironment");
                    Package package_ = clazz.getPackage();
                    if (package_ == null) {
                        Exception exception = new Exception("Null package received from MQEnvironment class");
                        FFDCFilter.processException(exception, "com.ibm.ejs.jms.JMSRegistration.MA88Install.validateMA88Path", "302", clazz, new Object[]{this, clazz});
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, exception.toString());
                        }
                        bl = false;
                        break block21;
                    }
                    String string = package_.getSpecificationVersion();
                    if (string == null) {
                        Exception exception = new Exception("Null version received from package for MQEnvironment class");
                        FFDCFilter.processException(exception, "com.ibm.ejs.jms.JMSRegistration.MA88Install.validateMA88Path", "303", package_, new Object[]{this, clazz, package_});
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, exception.toString());
                        }
                        bl = false;
                        break block21;
                    }
                    this._version = new Version(string);
                    this._ma88NativePath = new File(this._mqInstallPath, WMQ_JAVA_64_DIR);
                    if (this._ma88NativePath.exists() && this._ma88NativePath.isDirectory()) {
                        File file2;
                        String string2 = System.mapLibraryName("mqjbnd05");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "system library name is " + string2);
                        }
                        if (JVMUtils.is32Bit(file2 = new File(this._ma88NativePath, string2))) {
                            this._ma88NativePath = new File(this._mqInstallPath, WMQ_JAVA_DIR);
                        }
                        break block21;
                    }
                    this._ma88NativePath = new File(this._mqInstallPath, WMQ_JAVA_DIR);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ejs.jms.JMSRegistration.MA88Install.validateMA88Path", "301", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Unable to locate MQ client at " + file, classNotFoundException);
                    }
                    bl = false;
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ejs.jms.JMSRegistration.MA88Install.validateMA88Path", "305", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Unable to convert " + file + " to a URL, indicates a JVM bug", malformedURLException);
                    }
                    bl = false;
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The MA88 path " + file + " is invalid");
                    Tr.debug(_tc, "The MA88 path exists:      " + file.exists());
                    Tr.debug(_tc, "The MA88 path isDirectory: " + file.isDirectory());
                }
                bl = false;
            }
        }
        this._valid = bl;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateMA88Path");
        }
    }

    public File getJavaPath() {
        return this._ma88JavaPath;
    }

    public File getNativePath() {
        return this._ma88NativePath;
    }

    public String toString() {
        return this._toString;
    }
}

