/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;

class BMFinderHelper
implements FinderHelper {
    private final PersisterHome home;
    private Enumeration enumerationSource = null;
    private Collection collectionSource = null;
    private Iterator collectionIterator = null;
    private boolean isCollection = false;
    private static final TraceComponent tc = Tr.register(BMFinderHelper.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.BMFinderHelper";

    BMFinderHelper(PersisterHome persisterHome, Enumeration enumeration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", persisterHome);
        }
        this.home = persisterHome;
        this.enumerationSource = enumeration;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    BMFinderHelper(PersisterHome persisterHome, Collection collection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", persisterHome);
        }
        this.home = persisterHome;
        this.collectionSource = collection;
        this.collectionIterator = this.collectionSource.iterator();
        this.isCollection = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public EJBObject[] enumerateIntoArray(int n, boolean bl) throws EnumeratorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enumerateIntoArray", new Integer(n));
        }
        Vector<EJBObject> vector = new Vector<EJBObject>();
        try {
            int n2;
            if (this.isCollection) {
                for (n2 = 0; n2 < n && this.collectionIterator.hasNext(); ++n2) {
                    vector.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.collectionIterator.next())));
                }
            } else {
                for (n2 = 0; n2 < n && this.enumerationSource.hasMoreElements(); ++n2) {
                    vector.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.enumerationSource.nextElement())));
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.persistence.BMFinderHelper.enumerateIntoArray", "81", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray:", exception);
            }
            throw new EnumeratorException("", (Throwable)exception);
        }
        if (vector.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: no more elements");
            }
            throw new NoMoreElementsException();
        }
        Object[] objectArray = new EJBObject[vector.size()];
        vector.copyInto(objectArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enumerateIntoArray: found", new Integer(objectArray.length));
        }
        return objectArray;
    }

    public EJBObject[] enumerateIntoArray(boolean bl) throws EnumeratorException {
        return this.enumerateIntoArray(Integer.MAX_VALUE, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnumerationExhausted");
        }
        try {
            if (this.isCollection) {
                boolean bl = this.collectionIterator.hasNext();
                return bl;
            }
            boolean bl = this.enumerationSource.hasMoreElements();
            return bl;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isEnumerationExhausted");
            }
        }
    }

    public void destroy() {
    }

    public void cacheCustomFinderAccessIntentState() {
    }
}

