/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.Remote;
import java.util.Vector;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;

class CMFinderHelper
implements FinderHelper {
    boolean cmp11cfWithRWAccessIntent = false;
    boolean cmp11ai = true;
    String cmp11methname = null;
    boolean lazyEnumerationScenario = false;
    boolean initialRequestCompleted = false;
    private PersisterHome home;
    private Finder source;
    private static final TraceComponent tc = Tr.register(CMFinderHelper.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.CMFinderHelper";

    CMFinderHelper(PersisterHome persisterHome, Finder finder) {
        try {
            this.source = finder;
            this.home = persisterHome;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CMFinderHelper created");
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ejs.persistence.CMFinderHelper.CMFinderHelper", "76", this);
            this.destroy();
            Tr.error(tc, "CAUGHT_EXCEPTION_AND_RETHROWING_CNTR0039E", runtimeException);
            throw runtimeException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.CMFinderHelper.CMFinderHelper", "86", this);
            this.destroy();
            ContainerEJBException containerEJBException = new ContainerEJBException("Caught unexpected Throwable: " + throwable.getMessage(), throwable);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{throwable, containerEJBException.toString()});
            throw containerEJBException;
        }
    }

    public EJBObject[] enumerateIntoArray(int n, boolean bl) throws EnumeratorException {
        Vector<EJBObject> vector = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "enumerateIntoArray", new Integer(n));
            }
            vector = new Vector<EJBObject>();
            if (this.lazyEnumerationScenario && this.initialRequestCompleted) {
                this.home.setCustomFinderAccessIntentThreadState(this.cmp11cfWithRWAccessIntent, this.cmp11ai, this.cmp11methname);
            }
            for (int i = 0; i < n && this.source.hasMore(); ++i) {
                if (bl || this.home.hasInheritance()) {
                    vector.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.source.nextObject()));
                    continue;
                }
                vector.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.source.nextKey())));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.CMFinderHelper.enumerateIntoArray", "146", this);
            this.destroy();
            EnumeratorException enumeratorException = new EnumeratorException("Unexpected exception: " + throwable.getMessage(), throwable);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{throwable, enumeratorException.toString()});
            throw enumeratorException;
        }
        finally {
            this.initialRequestCompleted = true;
            if (this.lazyEnumerationScenario && this.initialRequestCompleted) {
                this.home.resetCustomFinderAccessIntentContext();
            }
        }
        if (vector.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: no more elements");
            }
            throw new NoMoreElementsException();
        }
        try {
            Object[] objectArray = new EJBObject[vector.size()];
            vector.copyInto(objectArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: found", new Integer(objectArray.length));
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.CMFinderHelper.enumerateIntoArray", "179", this);
            this.destroy();
            EnumeratorException enumeratorException = new EnumeratorException("Unexpected exception: " + throwable.getMessage(), throwable);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{throwable, enumeratorException.toString()});
            throw enumeratorException;
        }
    }

    public EJBObject[] enumerateIntoArray(boolean bl) throws EnumeratorException {
        return this.enumerateIntoArray(Integer.MAX_VALUE, bl);
    }

    public boolean hasMoreElements() throws EnumeratorException {
        boolean bl = false;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hasMoreElements");
            }
            if (this.source != null && !(bl = this.source.hasMore())) {
                this.destroy();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.CMFinderHelper.hasMoreElements", "231", this);
            this.destroy();
            EnumeratorException enumeratorException = new EnumeratorException("Unexpected exception: " + throwable.getMessage(), throwable);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{throwable, enumeratorException.toString()});
            throw enumeratorException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasMoreElements returning boolean " + bl);
        }
        return bl;
    }

    public void destroy() {
        if (this.source != null) {
            Finder finder = this.source;
            this.source = null;
            this.home = null;
            finder.close();
        }
    }

    public void cacheCustomFinderAccessIntentState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheCustomFinderAccessIntentState");
        }
        this.lazyEnumerationScenario = true;
        EJSDeployedSupport eJSDeployedSupport = (EJSDeployedSupport)this.home.getCurrentThreadDeployedSupport();
        if (eJSDeployedSupport != null && eJSDeployedSupport.getEJBMethodInfo() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Acquring Deployed Support");
            }
            this.cmp11cfWithRWAccessIntent = eJSDeployedSupport.getEJBMethodInfo().getIsCMP11CustomFinderWithForUpdateAI();
            this.cmp11ai = eJSDeployedSupport.getEJBMethodInfo().getReadOnlyAttribute();
            this.cmp11methname = eJSDeployedSupport.getEJBMethodInfo().getMethodName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Deployed Support State Info[method:" + this.cmp11methname + " CMP11AI " + String.valueOf(this.cmp11ai) + " CFwUpdateAI " + String.valueOf(this.cmp11cfWithRWAccessIntent) + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Deployed Support is null");
        }
    }
}

