/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.persistence.EJSFinder;
import com.ibm.ejs.persistence.EJSJDBCPersister;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.ejb.EJBObject;

public class EJSJDBCFinder
implements EJSFinder {
    private static final TraceComponent tc = Tr.register(EJSJDBCFinder.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.EJSJDBCFinder";
    protected EJSJDBCPersister persister;
    protected ResultSet resultSet;
    protected PreparedStatement pstmt;
    boolean haveReadNextRow = false;
    boolean resultSetExhausted = false;
    protected boolean closed = false;

    public EJSJDBCFinder(ResultSet resultSet, EJSJDBCPersister eJSJDBCPersister, PreparedStatement preparedStatement) {
        this.resultSet = resultSet;
        this.persister = eJSJDBCPersister;
        this.pstmt = preparedStatement;
    }

    public Object nextElement() {
        try {
            return this.nextObject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.persistence.EJSJDBCFinder.nextElement", "133", this);
            throw new NoSuchElementException();
        }
    }

    public boolean hasMoreElements() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hasMoreElements()");
            }
            boolean bl = this.hasMore();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "hasMoreElements", new Boolean(bl));
            }
            return bl;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCFinder.hasMoreElements", "156", this);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "close");
            }
            if (this.resultSet == null) return;
            try {
                this.resultSet.close();
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.EJSJDBCFinder.close", "186", this);
                    Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        this.persister.returnPreparedStatement(this.pstmt);
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException(throwable3, "com.ibm.ejs.persistence.EJSJDBCFinder.close", "197", this);
                        Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", throwable3);
                    }
                }
            }
            try {
                this.persister.returnPreparedStatement(this.pstmt);
                return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.EJSJDBCFinder.close", "197", this);
                Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", throwable);
                return;
            }
        }
        finally {
            this.closed = true;
            this.resultSet = null;
            this.persister = null;
            this.pstmt = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
        }
    }

    public Object getPrimaryKey() throws Exception {
        this.isFinderActive();
        try {
            return this.persister.getPrimaryKey(this.resultSet);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.persistence.EJSJDBCFinder.getPrimaryKey", "232", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", exception);
            throw exception;
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, "com.ibm.ejs.persistence.EJSJDBCFinder.getPrimaryKey", "239", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", error);
            throw error;
        }
    }

    public boolean hasMore() throws SQLException {
        try {
            boolean bl = false;
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "finder closed");
                }
                bl = false;
            } else if (this.haveReadNextRow) {
                bl = true;
            } else {
                this.haveReadNextRow = true;
                bl = this.advanceResultSet();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCFinder.hasMore", "290", this);
            if (!this.closed) {
                this.close();
                Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ejs.persistence.EJSJDBCFinder.hasMore", "301", this);
            this.close();
            ContainerEJBException containerEJBException = new ContainerEJBException("Caught unexpected Throwable: " + throwable.getMessage(), throwable);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{throwable, containerEJBException.toString()});
            throw containerEJBException;
        }
    }

    public EJBObject nextObject() throws Exception {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "nextObject");
            }
            this.consumeRow();
            EJBObject eJBObject = this.persister.getBean(this.resultSet);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nextObject", eJBObject);
            }
            return eJBObject;
        }
        catch (NoMoreElementsException noMoreElementsException) {
            FFDCFilter.processException((Throwable)noMoreElementsException, "com.ibm.ejs.persistence.EJSJDBCFinder.nextObject", "349", this);
            throw noMoreElementsException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.persistence.EJSJDBCFinder.nextObject", "354", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", exception);
            throw exception;
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, "com.ibm.ejs.persistence.EJSJDBCFinder.nextObject", "361", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", error);
            throw error;
        }
    }

    public Object nextKey() throws Exception {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "nextKey");
            }
            this.consumeRow();
            Object object = this.getPrimaryKey();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nextKey", object);
            }
            return object;
        }
        catch (NoMoreElementsException noMoreElementsException) {
            FFDCFilter.processException((Throwable)noMoreElementsException, "com.ibm.ejs.persistence.EJSJDBCFinder.nextKey", "396", this);
            throw noMoreElementsException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.persistence.EJSJDBCFinder.nextKey", "401", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", exception);
            throw exception;
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, "com.ibm.ejs.persistence.EJSJDBCFinder.nextKey", "408", this);
            this.close();
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", error);
            throw error;
        }
    }

    protected void isFinderActive() {
        if (this.closed) {
            throw new IllegalStateException("");
        }
    }

    protected void consumeRow() throws SQLException, NoMoreElementsException {
        this.isFinderActive();
        if (this.resultSetExhausted) {
            throw new NoMoreElementsException();
        }
        if (this.haveReadNextRow) {
            this.haveReadNextRow = false;
        } else if (!this.advanceResultSet()) {
            throw new NoMoreElementsException();
        }
    }

    protected boolean advanceResultSet() throws SQLException {
        if (this.resultSetExhausted) {
            return false;
        }
        boolean bl = false;
        try {
            boolean bl2 = bl = this.resultSet.next();
            return bl2;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCFinder.advanceResultSet", "478", this);
            Tr.error(tc, "FINDER_CAUGHT_EXCEPTION_CNTR0040E", sQLException);
            throw sQLException;
        }
        finally {
            if (!bl) {
                this.close();
                this.resultSetExhausted = true;
            }
        }
    }
}

