/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.portability.PortableConnection;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.ContainerManagedBeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.util.BuzzHash;
import com.ibm.ejs.container.util.NameUtil;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.ejs.persistence.EJSPersister;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.JDBCPersisterMetaData;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.util.WSThreadLocal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public abstract class EJSJDBCPersister
implements EJSPersister {
    private static final TraceComponent tc = Tr.register(EJSJDBCPersister.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.EJSJDBCPersister";
    private static final TraceComponent tc2 = Tr.register("com.ibm.ejs.persistence.EJSJDBCPersister$DataStoreHelper", "EJBContainer", "com.ibm.ejs.resources.CONMMessages");
    private boolean ivCMPAutoCommitWarningLogged = false;
    private boolean ivCMPWarningLogged = false;
    private static final WSThreadLocal cvThreadLocal = new WSThreadLocal();
    protected PersisterHome home = null;
    protected String schemaName;
    protected WSJdbcDataSource jdbcDataSource = null;
    protected PortableDataSource dataSource = null;
    protected String dbUser = null;
    protected String dbPassword = null;
    private boolean newDataSource = false;
    private DataStoreHelper dshelper = null;
    private DataStoreHelperMetaData dshelperMetadata = null;
    private InternalDataStoreHelper intDSHelper = null;
    private boolean supportsSelectForUpdate;
    private boolean supportsKeepUpdateLocks;

    public static EJSJDBCPersister create(JDBCPersisterMetaData jDBCPersisterMetaData) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create(MetaData)");
        }
        Class clazz = EJSJDBCPersister.getPersisterClass(jDBCPersisterMetaData);
        EJSJDBCPersister eJSJDBCPersister = (EJSJDBCPersister)clazz.newInstance();
        Properties properties = jDBCPersisterMetaData.getPersisterConfigData().getProperties();
        eJSJDBCPersister.initialize(jDBCPersisterMetaData.getDataSource(), (String)properties.get("DBUser"), (String)properties.get("DBPassword"), (String)properties.get("DBSchema"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create(MetaData)");
        }
        return eJSJDBCPersister;
    }

    private static Class getPersisterClass(JDBCPersisterMetaData jDBCPersisterMetaData) throws Exception {
        String string;
        Class<?> clazz;
        block10: {
            String string2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getPersisterClass");
            }
            clazz = null;
            ClassLoader classLoader = jDBCPersisterMetaData.getClassLoader();
            EnterpriseBean enterpriseBean = jDBCPersisterMetaData.getEnterpriseBean();
            string = string2 = NameUtil.getDeployedPersisterClassName(enterpriseBean);
            try {
                string = string + "_" + BuzzHash.computeHashStringMid32Bit(NameUtil.getHashStr(enterpriseBean));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPersisterClass(): Ejb module 2.0 - Loading Persister = " + string);
                }
                clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = NameUtil.updateFilenameHashCode(enterpriseBean, string);
                if (string != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getPersisterClass(): Failed Loading version 2 class, try modified BuzzHash version=" + string);
                    }
                    try {
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        // empty catch block
                    }
                }
                if (clazz != null) break block10;
                string = string2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPersisterClass(): Ejb module 1.0 - Loading Persister = " + string);
                }
                Class<?> clazz2 = clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersisterClass Loaded " + string);
        }
        return clazz;
    }

    public EJSJDBCPersister() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void setHome(PersisterHome persisterHome) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setHome", persisterHome);
        }
        this.home = persisterHome;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setHome");
        }
    }

    /*
     * Exception decompiling
     */
    public void initialize(DataSource var1_1, String var2_2, String var3_3, String var4_4) throws EJSPersistenceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean dbSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    public final boolean dbSupportsKeepUpdateLocks() {
        return this.supportsKeepUpdateLocks;
    }

    protected void postInit() {
    }

    public void create(EntityBean entityBean) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create(EntityBean)", this);
        }
        try {
            this._create(entityBean);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCPersister.create", "319", this);
            if (this.newDataSource) {
                SQLException sQLException2 = this.dshelper.mapException(sQLException);
                if (sQLException2 instanceof com.ibm.websphere.ce.cm.DuplicateKeyException) {
                    throw new DuplicateKeyException();
                }
                throw sQLException2;
            }
            SQLException sQLException3 = this.dataSource.getPortabilityLayer().translateException(sQLException);
            if (sQLException3 instanceof com.ibm.ejs.cm.portability.DuplicateKeyException) {
                throw new DuplicateKeyException();
            }
            throw sQLException3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create(EntityBean)");
        }
    }

    public EJBObject getBean(Object object) throws Exception {
        return this.home.getBean(this.getPrimaryKey(object), object);
    }

    public void checkCMPStoreOperation(BeanId beanId, boolean bl) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCMPStoreOperation beanid[" + beanId + "] loadedForUpdate[" + bl + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]");
        }
        if (this.newDataSource) {
            int n;
            String string;
            Connection connection = this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword);
            if (!this.ivCMPWarningLogged && (string = this.dshelper.hasLostUpdateOrDeadLockOccurred(n = connection.getTransactionIsolation(), bl)) != null) {
                Tr.service(tc2, string, beanId);
                this.ivCMPWarningLogged = true;
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update or Deadlock Condition");
                }
            }
        } else {
            PortableConnection portableConnection = (PortableConnection)this.dataSource.getConnection(this.dbUser, this.dbPassword);
            if (portableConnection.getAutoCommit()) {
                if (!this.ivCMPAutoCommitWarningLogged) {
                    Tr.service(tc, "POTENTIAL_LOST_UPDATE_CNTR0038W", beanId);
                    this.ivCMPAutoCommitWarningLogged = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkCMPStoreOperation: WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update");
                    }
                }
            } else if (!this.ivCMPWarningLogged) {
                PortabilityLayerExt portabilityLayerExt = portableConnection.getPortabilityLayer();
                this.ivCMPWarningLogged = portabilityLayerExt.checkCMPStoreOperation(beanId.toString(), portableConnection, bl);
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + bl + "] Possible Lost Update or Deadlock Condition");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCMPStoreOperation beanid[" + beanId + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]");
        }
    }

    public PreparedStatement getPreparedStatement(String string) throws EJSPersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreparedStatement " + string);
        }
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            ContainerManagedBeanO containerManagedBeanO;
            Object object;
            connection = this.newDataSource ? this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword) : this.dataSource.getConnection(this.dbUser, this.dbPassword);
            Object var4_4 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            String string2 = null;
            ContainerTx containerTx = null;
            EJSDeployedSupport eJSDeployedSupport = (EJSDeployedSupport)this.home.getCurrentThreadDeployedSupport();
            EJBMethodInfo eJBMethodInfo = null;
            if (eJSDeployedSupport != null && (eJBMethodInfo = eJSDeployedSupport.getEJBMethodInfo()) != null) {
                bl = eJBMethodInfo.getIsCMP11FBPK();
                bl2 = eJBMethodInfo.getIsCMP11CustomFinderWithForUpdateAI();
                bl3 = eJBMethodInfo.getReadOnlyAttribute();
                string2 = eJBMethodInfo.getMethodName();
                containerTx = eJSDeployedSupport.getCurrentTx();
                if (containerTx != null) {
                    bl6 = eJBMethodInfo.getEJBComponentMetaData().getEJBModuleVersion() == 11 ? containerTx.isTransactionGlobal() : true;
                    n = containerTx.getIsolationLevel();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx:" + containerTx + " CMP11FlushActive :" + containerTx.getCMP11FlushActive());
                    }
                    if (n == 0) {
                        bl5 = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Isolevel of TRANSACTION_NONE encountered, using default database isolation level");
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling Method [" + string2 + "] DB ForUpdate: " + this.supportsSelectForUpdate + " DBExt ForUpdate:" + this.supportsKeepUpdateLocks + " CF w/RW AI:" + bl2 + " FBPK:" + bl + " read-only:" + bl3 + " Inherit:" + this.home.hasInheritance() + " Child:" + this.home.isChild());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (eJSDeployedSupport == null || eJBMethodInfo == null)) {
                Tr.debug(tc, "Custom Finder SQL Update Processing Skipped");
            }
            if (bl6 && !containerTx.getCMP11FlushActive() && bl2 && !bl3) {
                boolean bl7;
                boolean bl8 = bl7 = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (bl5) {
                        try {
                            n = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException resourceException) {
                            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", "874", this);
                            throw new EJSPersistenceException("", (Throwable)resourceException);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + n);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx (glbl):" + containerTx + " CurrentIsolevel:" + n);
                    }
                    string = this.intDSHelper.processSQL(string, n, this.supportsSelectForUpdate, bl7);
                } else {
                    PortableConnection portableConnection = (PortableConnection)connection;
                    object = portableConnection.getPortabilityLayer();
                    if (bl5) {
                        n = object.getPreferredIsolationLevel();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + n);
                        }
                    }
                    string = object.processSQL(string, n, this.supportsSelectForUpdate, bl7);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enhancing SQL Scenario, CF Case, SQL: " + string);
                }
                bl4 = true;
            }
            if (!bl4 && this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && (containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get()) != null && containerManagedBeanO.getCalledFromLoadMethodForUpdate()) {
                boolean bl9;
                boolean bl10 = bl9 = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx:" + containerTx + " CurrentIsolevel:" + n);
                    }
                    if (bl5) {
                        try {
                            n = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException resourceException) {
                            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", "938", this);
                            throw new EJSPersistenceException("", (Throwable)resourceException);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + n);
                        }
                    }
                    string = this.intDSHelper.processSQL(string, n, false, bl9);
                } else {
                    object = (PortableConnection)connection;
                    PortabilityLayerExt portabilityLayerExt = object.getPortabilityLayer();
                    if (bl5) {
                        n = portabilityLayerExt.getPreferredIsolationLevel();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + n);
                        }
                    }
                    string = portabilityLayerExt.processSQL(string, n, false, bl9);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enhancing SQL Scenario, Load Ext For Update Case, SQL: " + string);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SQL for prepareStatement:" + string);
            }
            preparedStatement = connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            block37: {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", "466", this);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException2) {
                    FFDCFilter.processException((Throwable)sQLException2, "com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", "477", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block37;
                    Tr.debug(tc, "Connection close after error failed with: ", sQLException2);
                }
            }
            throw new EJSPersistenceException("getPStmt failed", (Throwable)sQLException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreparedStatement");
        }
        return preparedStatement;
    }

    protected final void returnPreparedStatement(PreparedStatement preparedStatement) throws EJSPersistenceException {
        Connection connection = null;
        try {
            connection = preparedStatement.getConnection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", "503", this);
            throw new EJSPersistenceException((Throwable)sQLException);
        }
        if (connection == null) {
            EJSPersistenceException eJSPersistenceException = new EJSPersistenceException("Prepared statement does not map to connection");
            Tr.error(tc, "PREPARED_STATEMENT_NOT_FOUND_CNTR0037E");
            throw eJSPersistenceException;
        }
        try {
            preparedStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", "526", this);
            throw new EJSPersistenceException((Throwable)sQLException);
        }
    }

    public void preFind() throws RemoteException {
        this.home.preFind();
    }

    public final void setContextData(ContainerManagedBeanO containerManagedBeanO) {
        cvThreadLocal.set(containerManagedBeanO);
    }

    public final Object[] getDataFromCache() {
        ContainerManagedBeanO containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get();
        return containerManagedBeanO.getDataCache();
    }

    public final void putDataIntoCache(Object[] objectArray) {
        ContainerManagedBeanO containerManagedBeanO = (ContainerManagedBeanO)cvThreadLocal.get();
        containerManagedBeanO.setDataCache(objectArray);
    }

    public abstract void _create(EntityBean var1) throws Exception;

    public abstract void remove(EntityBean var1) throws Exception;

    public abstract void refresh(EntityBean var1, boolean var2) throws Exception;

    public abstract void load(EntityBean var1, Object var2, boolean var3) throws Exception;

    public abstract Object getPrimaryKey(Object var1) throws Exception;

    public abstract void hydrate(EntityBean var1, Object var2, Object var3) throws Exception;

    public abstract void store(EntityBean var1) throws Exception;
}

