/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.persistence.BMFinderHelper;
import com.ibm.ejs.persistence.CMFinderHelper;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderCollection;
import com.ibm.ejs.persistence.FinderEnumeration;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.PortableFinderCollection;
import com.ibm.ejs.persistence.PortableFinderEnumeration;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ejs.persistence.RemoteEnumeratorImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.cpi.PersisterTx;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;

public abstract class MultivalueFinderFactory {
    private static final TraceComponent tc = Tr.register(MultivalueFinderFactory.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.MultivalueFinderFactory";
    public static final boolean propFlag = MultivalueFinderFactory.getPropFlag();

    public static Enumeration createEnumeration(PersisterTx persisterTx, PersisterHome persisterHome, Finder finder) throws RemoteException, FinderException {
        CMFinderHelper cMFinderHelper = new CMFinderHelper(persisterHome, finder);
        if (!persisterTx.beganInThisScope()) {
            return (Enumeration)MultivalueFinderFactory.createLazyEnumerator(persisterTx, cMFinderHelper, false);
        }
        return (Enumeration)MultivalueFinderFactory.createGreedyEnumerator(persisterTx, cMFinderHelper, false);
    }

    public static Enumeration createEnumeration(PersisterTx persisterTx, PersisterHome persisterHome, Enumeration enumeration) throws RemoteException, FinderException {
        BMFinderHelper bMFinderHelper = new BMFinderHelper(persisterHome, enumeration);
        if (!persisterTx.beganInThisScope()) {
            return (Enumeration)MultivalueFinderFactory.createLazyEnumerator(persisterTx, bMFinderHelper, false);
        }
        return (Enumeration)MultivalueFinderFactory.createGreedyEnumerator(persisterTx, bMFinderHelper, false);
    }

    public static Collection createCollection(PersisterTx persisterTx, PersisterHome persisterHome, Finder finder) throws RemoteException, FinderException {
        CMFinderHelper cMFinderHelper = new CMFinderHelper(persisterHome, finder);
        if (!persisterTx.beganInThisScope()) {
            return (Collection)MultivalueFinderFactory.createLazyEnumerator(persisterTx, cMFinderHelper, true);
        }
        return (Collection)MultivalueFinderFactory.createGreedyEnumerator(persisterTx, cMFinderHelper, true);
    }

    public static Collection createCollection(PersisterTx persisterTx, PersisterHome persisterHome, Collection collection) throws RemoteException, FinderException {
        BMFinderHelper bMFinderHelper = new BMFinderHelper(persisterHome, collection);
        if (!persisterTx.beganInThisScope()) {
            return (Collection)MultivalueFinderFactory.createLazyEnumerator(persisterTx, bMFinderHelper, true);
        }
        return (Collection)MultivalueFinderFactory.createGreedyEnumerator(persisterTx, bMFinderHelper, true);
    }

    private static Object createLazyEnumerator(PersisterTx persisterTx, FinderHelper finderHelper, boolean bl) throws RemoteException, FinderException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createLazyEnumerator", new Object[]{persisterTx, finderHelper});
        }
        EJBObject[] eJBObjectArray = null;
        boolean bl2 = false;
        try {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderEnumerator");
                }
                eJBObjectArray = finderHelper.enumerateIntoArray(25, true);
            } else {
                eJBObjectArray = finderHelper.enumerateIntoArray(25, true);
            }
            bl2 = !finderHelper.hasMoreElements();
        }
        catch (NoMoreElementsException noMoreElementsException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Enumeration is empty");
            }
            bl2 = true;
        }
        catch (EnumeratorException enumeratorException) {
            FFDCFilter.processException(enumeratorException, "com.ibm.ejs.persistence.MultivalueFinderFactory.createLazyEnumerator", "138");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createLazyEnumerator", (Object)enumeratorException);
            }
            throw new FinderException(enumeratorException.toString());
        }
        RemoteEnumeratorImpl remoteEnumeratorImpl = null;
        if (!bl2) {
            if (finderHelper instanceof CMFinderHelper) {
                finderHelper.cacheCustomFinderAccessIntentState();
            }
            remoteEnumeratorImpl = new RemoteEnumeratorImpl(finderHelper);
            persisterTx.registerSynchronization(remoteEnumeratorImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createLazyEnumerator");
        }
        if (bl) {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderCollection");
                }
                return new PortableFinderCollection(eJBObjectArray, bl2, (RemoteEnumerator)remoteEnumeratorImpl);
            }
            return new FinderCollection(eJBObjectArray, bl2, (RemoteEnumerator)remoteEnumeratorImpl);
        }
        if (propFlag) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating PortableFinderEnumeration");
            }
            return new PortableFinderEnumeration(eJBObjectArray, bl2, (RemoteEnumerator)remoteEnumeratorImpl);
        }
        return new FinderEnumeration(eJBObjectArray, bl2, (RemoteEnumerator)remoteEnumeratorImpl);
    }

    private static Object createGreedyEnumerator(PersisterTx persisterTx, FinderHelper finderHelper, boolean bl) throws RemoteException, FinderException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createGreedyEnumerator", new Object[]{persisterTx, finderHelper});
        }
        EJBObject[] eJBObjectArray = null;
        try {
            eJBObjectArray = finderHelper.enumerateIntoArray(false);
        }
        catch (NoMoreElementsException noMoreElementsException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Enumeration is empty");
            }
        }
        catch (EnumeratorException enumeratorException) {
            FFDCFilter.processException(enumeratorException, "com.ibm.ejs.persistence.MultivalueFinderFactory.createGreedyEnumerator", "184");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createGreedyEnumerator", (Object)enumeratorException);
            }
            throw new FinderException(enumeratorException.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createGreedyEnumerator");
        }
        if (bl) {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderCollection");
                }
                return new PortableFinderCollection(eJBObjectArray);
            }
            return new FinderCollection(eJBObjectArray);
        }
        if (propFlag) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating PortableFinderEnumeration");
            }
            return new PortableFinderEnumeration(eJBObjectArray);
        }
        return new FinderEnumeration(eJBObjectArray);
    }

    public static boolean getPropFlag() {
        boolean bl = true;
        String string = ContainerProperties.PortableFinder;
        bl = string != null ? string.equalsIgnoreCase("true") : ContainerProperties.Portable;
        return bl;
    }
}

