/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.GetContextClassLoaderPrivileged;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.csi.TransactionalObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadContextAccessor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import javax.transaction.Synchronization;

class RemoteEnumeratorImpl
extends PortableRemoteObject
implements RemoteEnumerator,
Synchronization,
TransactionalObject {
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

        public Object run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }
    });
    private FinderHelper helper;
    private ClassLoader contextClassLoader;
    private final SetContextClassLoaderPrivileged contextClassLoaderChanger = new SetContextClassLoaderPrivileged(threadContextAccessor);
    private boolean pushContextChangedTheContextClassLoader;
    private ComponentMetaData componentMetaData;
    private static final TraceComponent tc = Tr.register(RemoteEnumeratorImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.RemoteEnumeratorImpl";

    RemoteEnumeratorImpl(FinderHelper finderHelper) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", finderHelper);
        }
        this.helper = finderHelper;
        this.saveContexts();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public EJBObject[] nextNElements(int n) throws EnumeratorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "nextNElements", new Integer(n));
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.pushContext();
            if (this.helper != null) {
                EJBObject[] eJBObjectArray = this.helper.enumerateIntoArray(n, true);
                return eJBObjectArray;
            }
            throw new CollectionCannotBeFurtherAccessedException();
        }
        finally {
            this.popContext(classLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nextNElements");
            }
        }
    }

    public EJBObject[] allRemainingElements() throws EnumeratorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "allRemainingElements");
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.pushContext();
            if (this.helper != null) {
                EJBObject[] eJBObjectArray = this.helper.enumerateIntoArray(true);
                return eJBObjectArray;
            }
            throw new CollectionCannotBeFurtherAccessedException();
        }
        finally {
            this.popContext(classLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "allRemainingElements");
            }
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int n) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "afterCompletion" + n);
            }
            try {
                this.helper.destroy();
                this.helper = null;
                this.destroyContexts();
                PortableRemoteObject.unexportObject((Remote)this);
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ejs.persistence.RemoteEnumeratorImpl.afterCompletion", "123", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "Exception discarding RemoteEnumeratorImpl", new Object[]{this, remoteException});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    protected void saveContexts() {
        GetContextClassLoaderPrivileged getContextClassLoaderPrivileged = new GetContextClassLoaderPrivileged();
        AccessController.doPrivileged((PrivilegedAction)getContextClassLoaderPrivileged);
        this.contextClassLoader = getContextClassLoaderPrivileged.currentClassLoader;
        this.componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
    }

    protected void destroyContexts() {
        this.contextClassLoader = null;
        this.componentMetaData = null;
    }

    protected ClassLoader pushContext() {
        ClassLoader classLoader = this.contextClassLoaderChanger.execute(this.contextClassLoader);
        this.pushContextChangedTheContextClassLoader = this.contextClassLoaderChanger.wasChanged;
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(this.componentMetaData);
        return classLoader;
    }

    protected void popContext(ClassLoader classLoader) {
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        if (this.pushContextChangedTheContextClassLoader) {
            this.contextClassLoaderChanger.execute(classLoader);
        }
    }
}

