/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBETraceLogger
extends TraceLogger {
    private static String svHeaderString = "<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">" + System.getProperty("line.separator");
    private static String svFooterString = "</CommonBaseEvents>" + System.getProperty("line.separator");
    private byte[] ivHeader;
    private byte[] ivFooter;
    private Locale ivLocale;

    public CBETraceLogger(OutputStream outputStream, Locale locale) {
        super(outputStream);
        this.ivLocale = locale;
        this.ivHeader = svHeaderString.getBytes();
        this.ivFooter = svFooterString.getBytes();
    }

    public CBETraceLogger(OutputStream outputStream, Locale locale, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.ivLocale = locale;
        this.ivHeader = svHeaderString.getBytes(string);
        this.ivFooter = svFooterString.getBytes(string);
    }

    synchronized void doLog(LogRecord logRecord) {
        CommonBaseEventLogRecord commonBaseEventLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
        CommonBaseEvent commonBaseEvent = commonBaseEventLogRecord.getCommonBaseEvent();
        String string = TraceLogFormatter.formatCBEXML101(commonBaseEvent, logRecord.getResourceBundle(), logRecord.getResourceBundleName(), this.ivLocale);
        if (string != null) {
            this.ivOut.println(string);
        }
    }

    synchronized void printHeader() {
        try {
            this.ivOs.write(this.ivHeader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void printFooter(int n) {
        try {
            this.ivOs.write(this.ivFooter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

