/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordHelper;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedAction;
import java.util.Vector;
import java.util.logging.LogRecord;

class SharedLogWriter
extends SharedLogBase
implements WsHandler {
    private static final TraceComponent tc = Tr.register(SharedLogWriter.class, null, "com.ibm.ejs.resources.RasMessages");
    private static final int QUEUE_CHECK_INTERVAL_TIME = 5000;
    private static final int MAX_QUEUE_DEPTH = 200;
    private static String svFqFileName = null;
    private static File svFile = null;
    private static String svFqLockFileName = null;
    private static File svLockFile = null;
    static int svFileLength;
    static int svMaxMessageSize;
    private static SharedLogWriter svSharedLogWriter;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private boolean ivUsable;
    private boolean ivVerifyCompleted;
    private boolean ivRecovered;
    private Vector ivUnwrittenEvents;
    private long ivFirstErrorTime;
    private boolean ibQueuedEventThreadRunning;

    static synchronized SharedLogWriter getInstance() {
        if (svSharedLogWriter == null) {
            try {
                svSharedLogWriter = new SharedLogWriter();
            }
            catch (Throwable throwable) {
                svSharedLogWriter = null;
            }
        }
        return svSharedLogWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SharedLogWriter() throws RasException {
        block14: {
            this.ivUsable = false;
            this.ivVerifyCompleted = false;
            this.ivRecovered = false;
            this.ivUnwrittenEvents = null;
            this.ivFirstErrorTime = 0L;
            this.ibQueuedEventThreadRunning = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SharedLogWriter - ctor");
            }
            svFqFileName = RasProperties.getActivityLogName();
            svFileLength = RasProperties.getActivityLogSize();
            svFqLockFileName = svFqFileName + ".lck";
            svLockFile = new File(svFqLockFileName);
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
            svMaxMessageSize = svFileLength - 4100;
            if (svMaxMessageSize > 100000) {
                svMaxMessageSize = 100000;
            }
            boolean bl = false;
            try {
                try {
                    SharedLogWriter.acquireHostLock(svLockFile, false);
                    bl = true;
                    this.ivUsable = true;
                    this.verifyLogFile(false);
                    this.ivVerifyCompleted = true;
                }
                catch (SharedLogLockException sharedLogLockException) {
                    Object var5_3 = null;
                    if (bl) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                        Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                        Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                        Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                    }
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "SharedLogWriter - ctor");
                    return;
                }
                catch (RasException rasException) {
                    this.ivUsable = false;
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, rasException});
                    throw rasException;
                }
                catch (IOException iOException) {
                    this.ivUsable = false;
                    rasException = new RasException(iOException);
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, rasException});
                    throw rasException;
                }
                Object var5_2 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (bl) {
                    SharedLogWriter.releaseHostLock(svLockFile);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                    Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                    Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                    Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "SharedLogWriter - ctor");
                throw throwable;
            }
            SharedLogWriter.releaseHostLock(svLockFile);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
            Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
            Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
            Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SharedLogWriter - ctor");
    }

    public void processEvent(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        this.logMessage(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void logMessage(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        if (!this.ivUsable && this.ivVerifyCompleted) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = this.prepareEntry(logRecord);
        if (byArray == null || byArray.length > svMaxMessageSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "log - message size is invalid", byArray);
            }
            return;
        }
        boolean bl = false;
        try {
            SharedLogHeader sharedLogHeader;
            SharedLogWriter.acquireHostLock(svLockFile, false);
            bl = true;
            if (!this.ivVerifyCompleted) {
                this.ivUsable = true;
                this.verifyLogFile(true);
                this.ivVerifyCompleted = true;
            }
            randomAccessFile = this.createRandomAccessFile(svFqFileName, "rw");
            try {
                sharedLogHeader = new SharedLogHeader(randomAccessFile);
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "log - failed reading header for file, attempting recovery", iOException);
                }
                this.recoverFile(randomAccessFile);
                this.ivRecovered = true;
                sharedLogHeader = new SharedLogHeader(randomAccessFile);
            }
            this.writeEvent(randomAccessFile, sharedLogHeader, byArray);
        }
        catch (SharedLogLockException sharedLogLockException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "log - caught SharedLogLockException", sharedLogLockException);
            }
            try {
                if (this.ivUnwrittenEvents == null) {
                    this.ivUnwrittenEvents = new Vector(10);
                    this.ivUnwrittenEvents.addElement(byArray);
                    this.ivFirstErrorTime = System.currentTimeMillis();
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Added message to queue.  Current queue size is " + this.ivUnwrittenEvents.size());
                    }
                } else {
                    long l = System.currentTimeMillis();
                    if (l - this.ivFirstErrorTime < 600000L) {
                        int n = this.ivUnwrittenEvents.size();
                        while (n + 1 > 200) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "SharedLogWriter queue contains " + n + " entries.  Deleting oldest one to make room for newer entry.");
                            }
                            this.ivUnwrittenEvents.remove(0);
                            n = this.ivUnwrittenEvents.size();
                        }
                        this.ivUnwrittenEvents.addElement(byArray);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Added message to queue.  Current queue size is " + this.ivUnwrittenEvents.size());
                        }
                    } else {
                        this.ivUsable = false;
                        Tr.removeWsHandler(this);
                        Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", sharedLogLockException);
                    }
                }
                if (!this.ibQueuedEventThreadRunning) {
                    this.startSharedLogWriterHelper();
                }
            }
            catch (RasException rasException) {
                this.ivUsable = false;
                Tr.removeWsHandler(this);
                Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", sharedLogLockException);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "log - caught exception", throwable);
            }
            this.ivUsable = false;
            Tr.removeWsHandler(this);
            Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", throwable);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
            if (bl) {
                SharedLogWriter.releaseHostLock(svLockFile);
            }
        }
    }

    private void writeEvent(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray) throws IOException {
        this.writeQueuedEvents(randomAccessFile, sharedLogHeader);
        this.writeDataAndHeader(randomAccessFile, sharedLogHeader, byArray);
    }

    private void writeQueuedEvents(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader) throws IOException {
        if (this.ivUnwrittenEvents != null) {
            int n = this.ivUnwrittenEvents.size();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Attempting to write " + n + " messages from queue.");
            }
            for (int i = 0; i < n; ++i) {
                byte[] byArray = (byte[])this.ivUnwrittenEvents.elementAt(i);
                this.writeDataAndHeader(randomAccessFile, sharedLogHeader, byArray);
            }
            this.ivUnwrittenEvents = null;
        }
    }

    private byte[] prepareEntry(LogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare entry");
        }
        try {
            this.baos.reset();
            this.dos.write(svEntryHeader, 0, svEntryHeader.length);
            this.dos.writeInt(0);
            WsLogRecordHelper.writeEventToStream(logRecord, this.dos);
            this.dos.write(svEntryTrailer, 0, svEntryTrailer.length);
            byte[] byArray = this.baos.toByteArray();
            int n = svEntryHeader.length;
            int n2 = byArray.length - 12;
            int n3 = 0;
            int n4 = 24;
            while (n3 < 4) {
                byArray[n + n3] = (byte)(0xFF & n2 >> n4);
                ++n3;
                n4 -= 8;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry");
            }
            return byArray;
        }
        catch (IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry", iOException);
            }
            return null;
        }
    }

    private void writeDataAndHeader(RandomAccessFile randomAccessFile, SharedLogHeader sharedLogHeader, byte[] byArray) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeDataAndHeader");
        }
        int n2 = sharedLogHeader.ivFreeSpace;
        int n3 = byArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - writing " + n3 + " bytes to  location " + n2);
        }
        if (n2 + n3 <= sharedLogHeader.ivMaxSize) {
            randomAccessFile.seek(n2);
            randomAccessFile.write(byArray);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - data wraps");
            }
            n = sharedLogHeader.ivMaxSize - n2;
            int n4 = n3 - n;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray, n, byArray3, 0, n4);
            randomAccessFile.seek(n2);
            randomAccessFile.write(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - firstHalf writing " + n + " bytes to  location " + n2);
            }
            sharedLogHeader.ivFileWrapped = true;
            randomAccessFile.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - 2ndHalf writing " + n4 + " bytes to  location " + SharedLogHeader.DATA_AREA_OFFSET);
            }
            randomAccessFile.write(byArray3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - write complete, filePointer = " + randomAccessFile.getFilePointer());
        }
        if ((n = (int)randomAccessFile.getFilePointer()) == sharedLogHeader.ivMaxSize) {
            sharedLogHeader.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
            sharedLogHeader.ivFileWrapped = true;
        } else {
            sharedLogHeader.ivFreeSpace = n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - freeSpace ptr = " + sharedLogHeader.ivFreeSpace);
        }
        sharedLogHeader.writeHeader(randomAccessFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeDataAndHeader");
        }
    }

    private void verifyLogFile(boolean bl) throws IOException, RasException {
        RandomAccessFile randomAccessFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyLogFile");
        }
        try {
            randomAccessFile = this.createRandomAccessFile(svFqFileName, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verifyLogFile caught FileNotFound Exception", fileNotFoundException);
            }
            throw new RasException("unable to access file " + svFqFileName, fileNotFoundException);
        }
        if (randomAccessFile.length() == 0L) {
            SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
        } else {
            this.processExistingFile(randomAccessFile, bl);
        }
        randomAccessFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogFile");
        }
    }

    private void processExistingFile(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExistingFile");
        }
        SharedLogHeader sharedLogHeader = null;
        try {
            sharedLogHeader = new SharedLogHeader(randomAccessFile);
        }
        catch (IOException iOException) {
            this.recoverFile(randomAccessFile);
            this.ivRecovered = true;
            sharedLogHeader = new SharedLogHeader(randomAccessFile);
        }
        if (sharedLogHeader.ivMaxSize != svFileLength) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processExistingFile - changing size of log file");
            }
            try {
                SharedLogReader sharedLogReader = new SharedLogReader(svFqFileName, true);
                randomAccessFile.setLength(svFileLength);
                sharedLogHeader.ivMaxSize = svFileLength;
                sharedLogHeader.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
                sharedLogHeader.ivFileWrapped = false;
                sharedLogHeader.writeHeader(randomAccessFile);
                boolean bl2 = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processExistingFile - rewriting existing messages");
                }
                do {
                    WsLogRecord wsLogRecord;
                    if ((wsLogRecord = sharedLogReader.getNextMessage()) == null) {
                        bl2 = true;
                        continue;
                    }
                    this.logMessage(wsLogRecord.getImpl());
                } while (!bl2);
            }
            catch (RasException rasException) {
                if (!bl) {
                    Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", rasException);
                }
                Tr.removeWsHandler(this);
                Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", rasException);
                Tr.addWsHandler(this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExistingFile");
        }
    }

    private void recoverFile(RandomAccessFile randomAccessFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverFile");
        }
        try {
            if (randomAccessFile.length() == 0L) {
                SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
                return;
            }
            randomAccessFile.setLength(0L);
            SharedLogHeader sharedLogHeader = new SharedLogHeader(randomAccessFile, svFileLength);
            return;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "recoverFile - Exception occurred", iOException);
            }
            throw iOException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverFile");
            }
        }
    }

    private synchronized void startSharedLogWriterHelper() throws RasException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSharedLogWriterHelper");
        }
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Thread thread = new Thread((Runnable)new SharedLogWriterHelper(), "SharedLogWriterHelper");
                    thread.start();
                    SharedLogWriter.this.ibQueuedEventThreadRunning = true;
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new RasException("Unable to start SharedLogWriterHelper", throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startSharedLogWriterHelper");
            }
        }
    }

    static {
        svMaxMessageSize = 100000;
        svSharedLogWriter = null;
    }

    class SharedLogWriterHelper
    implements Runnable {
        SharedLogWriterHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = 0;
            int n2 = 180;
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SharedLogWriter sharedLogWriter = SharedLogWriter.this;
                synchronized (sharedLogWriter) {
                    try {
                        if (SharedLogWriter.this.ivUnwrittenEvents == null || SharedLogWriter.this.ivUnwrittenEvents.size() == 0) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "No work for SharedLogWriterHelper for past " + n * 5000 / 1000 + " seconds.");
                            }
                            ++n;
                        } else {
                            n = 0;
                        }
                        if (n >= n2) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "No work for SharedLogWriterHelper -- terminating thread.");
                            }
                            SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                            return;
                        }
                        boolean bl = this.processQueuedEvents();
                        if (!bl) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "SharedLogWriterHelper thread terminating");
                            }
                            SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "SharedLogWriterHelper thread terminating due to caught Throwable.", throwable);
                        }
                        SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processQueuedEvents() {
            if (!SharedLogWriter.this.ivUsable && SharedLogWriter.this.ivVerifyCompleted) {
                return false;
            }
            if (SharedLogWriter.this.ivUnwrittenEvents == null || SharedLogWriter.this.ivUnwrittenEvents.size() == 0) {
                return true;
            }
            RandomAccessFile randomAccessFile = null;
            boolean bl = false;
            try {
                SharedLogHeader sharedLogHeader;
                SharedLogBase.acquireHostLock(svLockFile, false);
                bl = true;
                if (!SharedLogWriter.this.ivVerifyCompleted) {
                    SharedLogWriter.this.ivUsable = true;
                    SharedLogWriter.this.verifyLogFile(true);
                    SharedLogWriter.this.ivVerifyCompleted = true;
                }
                randomAccessFile = SharedLogWriter.this.createRandomAccessFile(svFqFileName, "rw");
                try {
                    sharedLogHeader = new SharedLogHeader(randomAccessFile);
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - failed reading header for file, attempting recovery", iOException);
                    }
                    SharedLogWriter.this.recoverFile(randomAccessFile);
                    SharedLogWriter.this.ivRecovered = true;
                    sharedLogHeader = new SharedLogHeader(randomAccessFile);
                }
                SharedLogWriter.this.writeQueuedEvents(randomAccessFile, sharedLogHeader);
                boolean bl2 = true;
                return bl2;
            }
            catch (SharedLogLockException sharedLogLockException) {
                long l;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "log - caught SharedLogLockException", sharedLogLockException);
                }
                if ((l = System.currentTimeMillis()) - SharedLogWriter.this.ivFirstErrorTime >= 600000L) {
                    SharedLogWriter.this.ivUsable = false;
                    Tr.removeWsHandler(svSharedLogWriter);
                    Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", sharedLogLockException);
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = true;
                return bl4;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "log - caught exception", throwable);
                }
                SharedLogWriter.this.ivUsable = false;
                Tr.removeWsHandler(svSharedLogWriter);
                Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", throwable);
                boolean bl5 = false;
                return bl5;
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    SharedLogBase.releaseHostLock(svLockFile);
                }
            }
        }
    }
}

