/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.SystemStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.ws.bootstrap.WsLogManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.LogManager;

public class SystemErrStream
extends SystemStream
implements LogRolloverListener {
    private static final String svSystemErr = "SystemErr";
    private static TraceComponent svTc = Tr.register("SystemErr", null, "com.ibm.ejs.resources.RasMessages");
    private static WrappingFileOutputStream svFile = null;

    public static synchronized void replaceSystemErrStream(String string, int n, int n2, long l, int n3, int n4, boolean bl, boolean bl2) throws RasException {
        Object object;
        try {
            object = LogManager.getLogManager();
            if (object instanceof WsLogManager) {
                ((LogManager)object).readConfiguration();
            }
        }
        catch (IOException iOException) {
            throw new RasException("Redirection of System.err to file " + string + " failed", iOException);
        }
        RasHelper.printErrHeader(System.err);
        object = new NullOutputStream();
        if (string == null || string.equalsIgnoreCase("console")) {
            SystemErrStream systemErrStream = new SystemErrStream((OutputStream)object, System.err, bl, bl2);
            RasHelper.setSystemErr(systemErrStream);
            return;
        }
        if (string.equalsIgnoreCase("none")) {
            PrintStream printStream = new PrintStream((OutputStream)object);
            RasHelper.setSystemErr(printStream);
            return;
        }
        try {
            String string2 = RasHelper.generateOutputFileName(string, svSystemErr, svTc);
            svFile = new WrappingFileOutputStream(string2, n, n2, l, n3, n4);
            PrintStream printStream = new PrintStream(svFile);
            SystemErrStream systemErrStream = new SystemErrStream((OutputStream)object, printStream, bl, bl2);
            svFile.addRolloverListener(systemErrStream);
            RasHelper.setSystemErr(systemErrStream);
            File file = new File(string2);
            if (file.length() == 0L) {
                RasHelper.printErrHeader(svFile);
            } else if (!RasHelper.containsRasHeader(string2)) {
                SystemErrStream.rolloverLogFileImmediate(null);
            } else if (WsLogManager.getErrorHeaderControl().equals("full")) {
                RasHelper.printErrHeader(svFile);
            }
        }
        catch (RasException rasException) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Err", rasException});
            throw rasException;
        }
        catch (Throwable throwable) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Err", throwable});
            throw new RasException("Redirection of System.out to file " + string + " failed", throwable);
        }
    }

    static synchronized String rolloverLogFileImmediate(String string) throws RasException {
        if (svFile == null) {
            throw new RasException("System.err currently not redirected to a log file");
        }
        try {
            String string2 = svFile.rolloverImmediate(string);
            return string2;
        }
        catch (IOException iOException) {
            throw new RasException(iOException);
        }
    }

    SystemErrStream(OutputStream outputStream, PrintStream printStream, boolean bl, boolean bl2) {
        super(outputStream, printStream, bl, bl2, "basic");
    }

    StreamEvent6 createEvent(String string) {
        return new StreamEvent6(14, svTc, string);
    }

    StreamEvent6 createEvent(byte[] byArray) {
        return new StreamEvent6(14, svTc, byArray);
    }

    StreamEvent6 createEvent(char[] cArray) {
        return new StreamEvent6(14, svTc, cArray);
    }

    void dispatchEvent(StreamEvent6 streamEvent6) {
        Tr.systemErr(streamEvent6);
    }

    public void logRolled() {
        RasHelper.printErrHeader(svFile);
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }
    }
}

