/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import com.ibm.ejs.ras.SystemStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.LogRecord;

public class SystemOutStream
extends SystemStream
implements WsHandler,
LogRolloverListener {
    private static String svSystemOut = "SystemOut";
    private static TraceComponent svTc = Tr.register(svSystemOut, null, "com.ibm.ejs.resources.RasMessages");
    private static SystemOutStream svSos;
    private static WrappingFileOutputStream svFile;
    private boolean ivSuppressStacks;

    public static synchronized void replaceSystemOutStream(String string, int n, int n2, long l, int n3, int n4, boolean bl, boolean bl2, String string2, boolean bl3) throws RasException {
        RasHelper.printHeader(System.out);
        NullOutputStream nullOutputStream = new NullOutputStream();
        if (string == null || string.equalsIgnoreCase("console")) {
            SystemOutStream systemOutStream = new SystemOutStream(nullOutputStream, System.out, bl, bl2, string2, bl3);
            RasHelper.setSystemOut(systemOutStream);
            Tr.replaceWsHandler(systemOutStream, svSos);
            svSos = systemOutStream;
            return;
        }
        if (string.equalsIgnoreCase("none")) {
            PrintStream printStream = new PrintStream(nullOutputStream);
            RasHelper.setSystemOut(printStream);
            Tr.replaceWsHandler(null, svSos);
            svSos = null;
            return;
        }
        try {
            String string3 = RasHelper.generateOutputFileName(string, svSystemOut, svTc);
            svFile = new WrappingFileOutputStream(string3, n, n2, l, n3, n4);
            PrintStream printStream = new PrintStream(svFile);
            SystemOutStream systemOutStream = new SystemOutStream(nullOutputStream, printStream, bl, bl2, string2, bl3);
            svFile.addRolloverListener(systemOutStream);
            RasHelper.setSystemOut(systemOutStream);
            Tr.replaceWsHandler(systemOutStream, svSos);
            svSos = systemOutStream;
        }
        catch (RasException rasException) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", rasException});
            throw rasException;
        }
        catch (Throwable throwable) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", throwable});
            throw new RasException("Redirection of System.out to file " + string + " failed", throwable);
        }
    }

    static synchronized String rolloverLogFileImmediate(String string) throws RasException {
        if (svFile == null) {
            throw new RasException("System.out currently not redirected to a log file");
        }
        try {
            return svFile.rolloverImmediate(string);
        }
        catch (IOException iOException) {
            throw new RasException(iOException);
        }
    }

    static void initialize() {
        if (svSos != null) {
            svSos.printHeader();
        }
    }

    private SystemOutStream(OutputStream outputStream, PrintStream printStream, boolean bl, boolean bl2, String string, boolean bl3) {
        super(outputStream, printStream, bl, bl2, string);
        this.ivSuppressStacks = bl3;
    }

    public void logRolled() {
        this.printHeader();
    }

    public void processEvent(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        if (logRecord.getLevel().intValue() < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
            return;
        }
        this.logMessage(logRecord);
    }

    private synchronized void logMessage(LogRecord logRecord) {
        this.writeWebSphereEvent(this.formatMessage(logRecord));
    }

    private String formatMessage(LogRecord logRecord) {
        if ("advanced".equals(this.ivFormatType)) {
            return TraceLogFormatter.formatAdvanced(logRecord);
        }
        return TraceLogFormatter.formatBasic(logRecord);
    }

    StreamEvent6 createEvent(String string) {
        StreamEvent6 streamEvent6 = new StreamEvent6(13, svTc, string);
        return streamEvent6;
    }

    StreamEvent6 createEvent(byte[] byArray) {
        StreamEvent6 streamEvent6 = new StreamEvent6(13, svTc, byArray);
        return streamEvent6;
    }

    StreamEvent6 createEvent(char[] cArray) {
        StreamEvent6 streamEvent6 = new StreamEvent6(13, svTc, cArray);
        return streamEvent6;
    }

    void dispatchEvent(StreamEvent6 streamEvent6) {
        Tr.systemOut(streamEvent6);
    }

    void printHeader() {
        if (this.ivStream == null) {
            return;
        }
        try {
            if (svFile != null) {
                RasHelper.printHeader(svFile);
            } else {
                RasHelper.printHeader(this.ivStream);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        svFile = null;
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }
    }
}

