/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.CastoutPolicy;
import com.ibm.ejs.util.LRUCacheElement;
import com.ibm.ejs.util.Queue;
import java.util.Enumeration;
import java.util.Hashtable;

public class LRUCache {
    protected Hashtable elements;
    protected Queue lruQ;
    protected int maxSize;
    protected CastoutPolicy castoutPolicy;

    public LRUCache(int n, CastoutPolicy castoutPolicy) {
        this.maxSize = n;
        this.castoutPolicy = castoutPolicy;
        this.elements = n >= 10 ? new Hashtable(n / 10) : new Hashtable(n);
        this.lruQ = new Queue();
    }

    public Object get(Object object) {
        LRUCacheElement lRUCacheElement = null;
        lRUCacheElement = (LRUCacheElement)this.elements.get(object);
        if (lRUCacheElement != null) {
            this.lruQ.remove(lRUCacheElement);
            this.lruQ.addToTail(lRUCacheElement);
        }
        return lRUCacheElement;
    }

    public void put(Object object, LRUCacheElement lRUCacheElement) {
        LRUCacheElement lRUCacheElement2 = (LRUCacheElement)this.elements.remove(object);
        if (lRUCacheElement2 != null) {
            this.lruQ.remove(lRUCacheElement2);
            if (this.castoutPolicy != null) {
                this.castoutPolicy.castout(lRUCacheElement2);
            }
        } else {
            while (this.elements.size() >= this.maxSize) {
                LRUCacheElement lRUCacheElement3 = (LRUCacheElement)this.lruQ.removeHead();
                this.elements.remove(lRUCacheElement3.key);
                if (this.castoutPolicy == null) continue;
                this.castoutPolicy.castout(lRUCacheElement3);
            }
        }
        this.elements.put(object, lRUCacheElement);
        lRUCacheElement.key = object;
        this.lruQ.addToTail(lRUCacheElement);
    }

    public LRUCacheElement remove(Object object) {
        LRUCacheElement lRUCacheElement = (LRUCacheElement)this.elements.remove(object);
        if (lRUCacheElement != null) {
            this.lruQ.remove(lRUCacheElement);
        }
        return lRUCacheElement;
    }

    public int size() {
        return this.elements.size();
    }

    public void dump() {
    }

    public Enumeration elements() {
        return this.lruQ.elements();
    }
}

