/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Random;

public class ThreadLocal {
    ReferenceQueue queue = new ReferenceQueue();
    int nbuckets = 127;
    Entry[] buckets = new Entry[this.nbuckets];

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        Entry entry = this.ourEntry(true);
        return entry == null ? null : entry.value;
    }

    public void set(Object object) {
        this.clean();
        Entry entry = this.ourEntry(false);
        entry.value = object;
    }

    private Entry ourEntry(boolean bl) {
        int n;
        Thread thread = Thread.currentThread();
        Entry entry = this.lookup(thread, n = (thread.hashCode() & Integer.MAX_VALUE) % this.nbuckets);
        if (entry == null) {
            Object object;
            Object object2 = object = bl ? this.initialValue() : null;
            if (object != null || !bl) {
                entry = new Entry(thread, n, object, this.queue);
                this.insert(entry);
            }
        }
        return entry;
    }

    void clean() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            this.remove(entry);
        }
    }

    Entry lookup(Thread thread, int n) {
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (entry.get() == thread) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(Entry entry) {
        Entry[] entryArray = this.buckets;
        synchronized (this.buckets) {
            entry.next = this.buckets[entry.bucketIndex];
            this.buckets[entry.bucketIndex] = entry;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Entry entry) {
        Entry[] entryArray = this.buckets;
        synchronized (this.buckets) {
            Entry entry2 = this.buckets[entry.bucketIndex];
            if (entry2 == entry) {
                this.buckets[entry.bucketIndex] = entry2.next;
            } else {
                while (entry2 != null) {
                    if (entry2.next == entry) {
                        entry2.next = entry.next;
                        break;
                    }
                    entry2 = entry2.next;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void main(String[] stringArray) {
        final ThreadLocal threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new Integer(0);
            }

            void remove(Entry entry) {
                System.out.println("removing");
                super.remove(entry);
            }

            void insert(Entry entry) {
                System.out.println("insert " + Thread.currentThread() + " entry " + entry + " bucket " + entry.bucketIndex);
                if (this.buckets[entry.bucketIndex] != null) {
                    System.out.println("bucket collision " + entry.bucketIndex);
                }
                super.insert(entry);
            }
        };
        final Random random = new Random();
        int n = Integer.parseInt(stringArray[0]);
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            new Thread(){

                public void run() {
                    Object[] objectArray = new Object[100];
                    System.out.println("Thread " + n3 + " starting");
                    for (int i = 0; i < 100; ++i) {
                        Integer n = (Integer)threadLocal.get();
                        if (n != i) {
                            System.err.println("MISMATCH");
                        }
                        ThreadLocal.pause((random.nextInt() & 0xFF) + 100);
                        threadLocal.set(new Integer(i + 1));
                        for (int j = 0; j < i; ++j) {
                            objectArray[j] = new byte[10240];
                        }
                    }
                    System.out.println("Thread " + n3 + " done");
                }
            }.start();
            ThreadLocal.pause(2500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pause(int n) {
        Object object = new Object();
        try {
            Object object2 = object;
            synchronized (object2) {
                object.wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException(interruptedException, "com.ibm.ejs.util.ThreadLocal.pause", "129");
        }
    }

    static class Entry
    extends WeakReference {
        Object value;
        Entry next;
        int bucketIndex;

        Entry(Object object, int n, Object object2, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.value = object2;
            this.bucketIndex = n;
        }
    }
}

