/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.BucketImpl;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.IllegalOperationException;
import com.ibm.ejs.util.cache.LimitStrategy;
import com.ibm.ejs.util.cache.NoSuchObjectException;
import com.ibm.ejs.util.cache.WrapperBucket;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.cache.DiscardWithLockStrategy;
import java.util.Enumeration;

public final class Cache
implements EJBCache,
Dumpable {
    protected FaultStrategy faultStrategy = null;
    protected LimitStrategy limitStrategy = null;
    protected EvictionStrategy evictionStrategy = null;
    protected DiscardStrategy discardStrategy = null;
    protected LockTable ivEvictionLocks = null;
    protected String ivName;
    protected Bucket[] buckets;
    protected int numBuckets;
    protected int numObjects = 0;
    private int numEvictionAttempts = 0;
    private int numEvictions = 0;
    protected long numSweeps = 0L;
    protected boolean dumped = false;
    private static final TraceComponent tc = Tr.register(Cache.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.Cache";

    public Cache(String string, int n, boolean bl) {
        n = MathUtil.findNextPrime(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> (" + string + "," + n + "," + bl + ")");
        }
        this.ivName = string;
        this.numBuckets = n;
        this.buckets = new Bucket[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.buckets[i] = new WrapperBucket(this);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.buckets[i] = new BucketImpl();
            }
        }
        Tr.registerDumpable(tc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Cache(String string, long l, boolean bl) {
        this(string, (int)l, bl);
    }

    public final int getSize() {
        return this.numObjects;
    }

    public final int getConfigSize() {
        return this.numBuckets;
    }

    public String getName() {
        return this.ivName;
    }

    public final void setFaultStrategy(FaultStrategy faultStrategy) {
        this.faultStrategy = faultStrategy;
    }

    public final void setLimitStrategy(LimitStrategy limitStrategy) {
        this.limitStrategy = limitStrategy;
    }

    public final void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.evictionStrategy = evictionStrategy;
    }

    public final void setDiscardStrategy(DiscardStrategy discardStrategy) {
        this.discardStrategy = discardStrategy;
        if (discardStrategy instanceof DiscardWithLockStrategy) {
            this.ivEvictionLocks = ((DiscardWithLockStrategy)discardStrategy).getEvictionLockTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Element element = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            element = bucket.findByKey(object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", new Boolean(element != null));
        }
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                ++element.pinned;
                object2 = element.object;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findDontPinNAdjustPinCount(Object object, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findDontPinNAdjustPinCount", object + ", adujust pin count=" + n);
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                object2 = element.object;
                element.pinned += n;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findDontPinNAdjustPinCount", object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findAndFault(Object object) throws FaultException, InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findAndFault", object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object2 = null;
        Object object3 = bucket;
        synchronized (object3) {
            Element element = bucket.findByKey(object);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findAndFault : found in cache");
                }
                return element.object;
            }
            if (this.faultStrategy == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findAndFault : not in cache : no FaultStrategy");
                }
                return null;
            }
            try {
                object2 = this.faultStrategy.faultOnKey(this, object);
                if (object2 != null) {
                    element = bucket.insertByKey(object, object2);
                    element.accessed = true;
                    element.sweepCount = 0;
                    element.accessedSweep = this.numSweeps;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.util.cache.Cache.findAndFault", "417", this);
                throw new FaultException(exception, (Object)object.toString());
            }
        }
        if (object2 != null) {
            object3 = this;
            synchronized (object3) {
                ++this.numObjects;
            }
        }
        this.trimCache();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findAndFault : not in cache : faulted");
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object, boolean bl) {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Object[]{object, new Boolean(bl)});
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object3 = bucket;
        synchronized (object3) {
            Element element = bucket.removeByKey(object, bl);
            object2 = element != null ? element.object : null;
        }
        if (object2 != null) {
            object3 = this;
            synchronized (object3) {
                --this.numObjects;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove", object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAndDiscard(Object object, boolean bl) throws DiscardException {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAndDiscard", new Object[]{object, new Boolean(bl)});
        }
        Bucket bucket = this.getBucketForKey(object);
        Object object3 = null;
        try {
            object2 = bucket;
            synchronized (object2) {
                Element element = bucket.removeByKey(object, bl);
                Object object4 = object3 = element != null ? element.object : null;
                if (object3 != null && this.discardStrategy != null) {
                    try {
                        this.discardStrategy.discardObject(this, element.key, element.object);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.util.cache.Cache.removeAndDiscard", "540", this);
                        Tr.warning(tc, "EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", new Object[]{element, exception});
                        element = null;
                        throw new DiscardException(exception, object);
                    }
                }
            }
        }
        finally {
            if (object3 != null) {
                object2 = this;
                synchronized (object2) {
                    --this.numObjects;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAndDiscard", object3);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object object, Object object2) throws InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{object, object2});
        }
        try {
            this.trimCache();
            Bucket bucket = this.getBucketForKey(object);
            Object object3 = bucket;
            synchronized (object3) {
                Element element = bucket.insertByKey(object, object2);
                ++element.pinned;
            }
            object3 = this;
            synchronized (object3) {
                ++this.numObjects;
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "insert");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(Object object) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pin", object);
        }
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "pin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(object);
            }
            ++element.pinned;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinOnce(Object object) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pinOnce", object);
        }
        boolean bl = false;
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element != null && element.pinned == 0) {
                ++element.pinned;
                bl = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pinOnce : " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unpin(Object object) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unpin", object);
        }
        int n = 0;
        Bucket bucket2 = bucket = this.getBucketForKey(object);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "unpin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(object);
            }
            if (element.pinned < 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "unpin - throw IllegalOperationException");
                }
                throw new IllegalOperationException(object, element.pinned);
            }
            --element.pinned;
            n = element.pinned;
            element.accessed = true;
            element.sweepCount = 0;
            element.accessedSweep = this.numSweeps;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unpin:" + n);
        }
        return n;
    }

    public void touch(Element element) {
        element.accessed = true;
        element.sweepCount = 0;
        element.accessedSweep = this.numSweeps;
    }

    public final Enumeration enumerateElements() {
        return new CacheElementEnumerator(this);
    }

    public final Bucket getBucketForKey(Object object) {
        return this.buckets[(object.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trimCache() throws InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "trimCache");
        }
        if (this.limitStrategy == null || this.evictionStrategy == null) {
            return;
        }
        while (this.limitStrategy.hardLimitReached(this)) {
            Object object = this.evictionStrategy.getVictim(this);
            if (object != null) {
                if (this.ivEvictionLocks != null) {
                    Object object2 = this.ivEvictionLocks.getLock(object);
                    synchronized (object2) {
                        this.evictObject(object);
                        continue;
                    }
                }
                this.evictObject(object);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "trimCache - throw InsufficientCacheSpaceException");
            }
            throw new InsufficientCacheSpaceException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "trimCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evictObject(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "evictObject", object);
        }
        Bucket bucket = this.getBucketForKey(object);
        Element element = null;
        Object object2 = this;
        synchronized (object2) {
            ++this.numEvictionAttempts;
        }
        try {
            object2 = bucket;
            synchronized (object2) {
                element = bucket.findByKey(object);
                if (element != null && this.evictionStrategy.canBeDiscarded(element)) {
                    element = bucket.discardByKey(object);
                    if (element != null) {
                        Cache cache = this;
                        synchronized (cache) {
                            --this.numObjects;
                            ++this.numEvictions;
                        }
                        if (this.discardStrategy != null) {
                            try {
                                this.discardStrategy.discardObject(this, element.key, element.object);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.util.cache.Cache.evictObject", "863", this);
                                Tr.warning(tc, "EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", new Object[]{element, exception});
                                element = null;
                            }
                        }
                    }
                } else {
                    element = null;
                }
            }
        }
        catch (IllegalOperationException illegalOperationException) {
            try {
                FFDCFilter.processException((Throwable)((Object)illegalOperationException), "com.ibm.ejs.util.cache.Cache.evictObject", "878", this);
                element = null;
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "evictObject", new Boolean(element != null));
                }
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "evictObject", new Boolean(element != null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "evictObject", new Boolean(element != null));
        }
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Cache Dump -- ", this);
            Tr.dump(tc, "Name of Cache: " + this.ivName);
            Tr.dump(tc, "Number of buckets: " + this.numBuckets);
            Cache cache = this;
            synchronized (cache) {
                Tr.dump(tc, "Number of objects currently in cache: " + this.numObjects);
                Tr.dump(tc, "Number of evictions attempted (since last dump): " + this.numEvictionAttempts);
                Tr.dump(tc, "Number of evictions (since last dump): " + this.numEvictions);
            }
        }
        finally {
            this.dumped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDump() {
        this.dumped = false;
        Cache cache = this;
        synchronized (cache) {
            this.numEvictionAttempts = 0;
            this.numEvictions = 0;
        }
    }
}

