/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Cache;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;

final class CacheElementEnumerator
implements Enumeration {
    private static final TraceComponent tc = Tr.register(CacheElementEnumerator.class, "EJBCache", "com.ibm.ejs.container.container");
    private Cache ivCache = null;
    private int ivBucketCount = 0;
    private int ivBucketIndex = 0;
    private Object[] ivBucket = null;
    private int ivBucketSize = 0;
    private int ivElementIndex = 0;
    private int ivElementsReturned = 0;
    private int ivMaxBucketSize = 0;
    private long ivTotalLookups = 0L;
    private int[] ivBucketSizeStats = new int[21];

    public CacheElementEnumerator(Cache cache) {
        this.ivCache = cache;
        int n = this.ivCache.buckets[this.ivBucketIndex].size() + 20;
        if (n < 50) {
            n = 50;
        }
        this.ivBucket = new Object[n];
        this.reset();
    }

    void reset() {
        Random random = new Random(System.currentTimeMillis());
        this.ivBucketIndex = random.nextInt() % this.ivCache.buckets.length;
        if (this.ivBucketIndex < 0) {
            this.ivBucketIndex = -this.ivBucketIndex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String string = "";
            if (this.ivBucketCount > 0 && (this.ivBucketCount < this.ivCache.buckets.length || this.ivElementIndex < this.ivBucketSize)) {
                string = ", returned = " + this.ivElementsReturned + " (lookup avg = " + (float)this.ivTotalLookups / (float)this.ivElementsReturned + ", max = " + this.ivMaxBucketSize + ")";
            }
            Tr.debug(tc, "reset : " + this.ivCache.getName() + " = " + this.ivCache.numObjects + ", index = " + this.ivBucketIndex + "/" + this.ivCache.numBuckets + string);
            this.ivElementsReturned = 0;
            this.ivMaxBucketSize = 0;
            this.ivTotalLookups = 0L;
            for (int i = 0; i < this.ivBucketSizeStats.length; ++i) {
                this.ivBucketSizeStats[i] = 0;
            }
        }
        for (int i = 0; i < this.ivBucketSize; ++i) {
            this.ivBucket[i] = null;
        }
        this.ivBucketCount = 0;
        this.ivBucketSize = 0;
        this.ivElementIndex = 0;
    }

    public boolean hasMoreElements() {
        if (this.ivElementIndex < this.ivBucketSize) {
            return true;
        }
        return this.findNextBucket();
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.ivElementIndex >= this.ivBucketSize && !this.findNextBucket()) {
            throw new NoSuchElementException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivElementsReturned;
        }
        return this.ivBucket[this.ivElementIndex++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findNextBucket() {
        Object object;
        while (this.ivBucketCount < this.ivCache.buckets.length) {
            this.ivBucketIndex = (this.ivBucketIndex + 1) % this.ivCache.buckets.length;
            Bucket bucket = this.ivCache.buckets[this.ivBucketIndex];
            ++this.ivBucketCount;
            object = bucket;
            synchronized (object) {
                if (!bucket.isEmpty()) {
                    this.ivBucketSize = bucket.size();
                    if (this.ivBucket.length < this.ivBucketSize) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, this.ivCache.getName() + ": Expanding internal bucket from " + this.ivBucket.length + " to " + (this.ivBucketSize + 20));
                        }
                        this.ivBucket = new Object[this.ivBucketSize + 20];
                    }
                    this.ivBucket = bucket.toArray(this.ivBucket);
                    this.ivElementIndex = 0;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        if (this.ivBucketSize > this.ivMaxBucketSize) {
                            this.ivMaxBucketSize = this.ivBucketSize;
                        }
                        if (this.ivBucketSize < this.ivBucketSizeStats.length) {
                            int n = this.ivBucketSize;
                            this.ivBucketSizeStats[n] = this.ivBucketSizeStats[n] + 1;
                        } else {
                            int n = this.ivBucketSizeStats.length - 1;
                            this.ivBucketSizeStats[n] = this.ivBucketSizeStats[n] + 1;
                        }
                        for (int i = 1; i <= this.ivBucketSize; ++i) {
                            this.ivTotalLookups += (long)i;
                        }
                        if (this.ivBucketSize > 100) {
                            Tr.debug(tc, this.ivCache.getName() + ": Hash = " + this.ivBucketIndex + ", size = " + this.ivBucketSize);
                        }
                    }
                    return true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    this.ivBucketSizeStats[0] = this.ivBucketSizeStats[0] + 1;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.ivElementsReturned > 0) {
            int n = (int)((float)this.ivElementsReturned / (float)this.ivBucketCount * 100.0f);
            Tr.debug(tc, "Empty : " + this.ivCache.getName() + " returned = " + this.ivElementsReturned + ", " + n + "% capacity" + " (lookup avg = " + (float)this.ivTotalLookups / (float)this.ivElementsReturned + ", max = " + this.ivMaxBucketSize + ")");
            object = "0[" + this.ivBucketSizeStats[0] + "]";
            for (int i = 1; i < this.ivBucketSizeStats.length; ++i) {
                if (this.ivBucketSizeStats[i] <= 0) continue;
                object = (String)object + ", " + i;
                if (i == this.ivBucketSizeStats.length - 1) {
                    object = (String)object + "+";
                }
                object = (String)object + "[" + this.ivBucketSizeStats[i] + "]";
            }
            Tr.debug(tc, "Empty : " + this.ivCache.getName() + " size[buckets] = " + (String)object);
        }
        return false;
    }
}

