/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;

public final class WrapperBucket
implements Bucket {
    private static final TraceComponent tc = Tr.register(WrapperBucket.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final int DEFAULT_BUCKET_SIZE = 3;
    public final Cache ivWrapperCache;
    private EJSWrapperCommon[] ivWrappers = null;
    private int ivSize = 0;
    private long hitCount = 0L;

    WrapperBucket(Cache cache) {
        this.ivWrapperCache = cache;
    }

    public Element findByKey(Object object) {
        for (int i = this.ivSize - 1; i >= 0; --i) {
            EJSWrapperCommon eJSWrapperCommon = this.ivWrappers[i];
            if (!eJSWrapperCommon.key.equals(object)) continue;
            ++this.hitCount;
            return eJSWrapperCommon;
        }
        return null;
    }

    public Element insertByKey(Object object, Object object2) {
        EJSWrapperCommon eJSWrapperCommon = (EJSWrapperCommon)object2;
        if (this.ivWrappers == null || this.ivWrappers.length == this.ivSize) {
            this.expandCapacity();
        }
        this.ivWrappers[this.ivSize++] = eJSWrapperCommon;
        eJSWrapperCommon.ivWrapperCacheBucket = this;
        eJSWrapperCommon.pinned = 0;
        ++this.hitCount;
        return eJSWrapperCommon;
    }

    public Element discardByKey(Object object) {
        int n = this.findIndexByKey(object);
        EJSWrapperCommon eJSWrapperCommon = null;
        if (n != -1) {
            eJSWrapperCommon = this.ivWrappers[n];
            if (eJSWrapperCommon.pinned > 0) {
                return null;
            }
            this.remove(n);
            ++this.hitCount;
        }
        return eJSWrapperCommon;
    }

    public Element removeByKey(Object object) {
        return this.removeByKey(object, false);
    }

    public Element removeByKey(Object object, boolean bl) {
        int n = this.findIndexByKey(object);
        EJSWrapperCommon eJSWrapperCommon = null;
        if (n != -1) {
            eJSWrapperCommon = this.ivWrappers[n];
            if (!bl && eJSWrapperCommon.pinned > 0 || bl && eJSWrapperCommon.pinned > 1) {
                throw new IllegalOperationException(object, eJSWrapperCommon.pinned);
            }
            this.remove(n);
            ++this.hitCount;
        }
        return eJSWrapperCommon;
    }

    public boolean isEmpty() {
        return this.ivSize == 0;
    }

    public int size() {
        return this.ivSize;
    }

    public Object[] toArray(Object[] objectArray) {
        for (int i = 0; i < this.ivSize; ++i) {
            objectArray[i] = this.ivWrappers[i];
        }
        if (objectArray.length > this.ivSize) {
            objectArray[this.ivSize] = null;
        }
        return objectArray;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    private Object remove(int n) {
        if (n < 0 || n >= this.ivSize) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        EJSWrapperCommon eJSWrapperCommon = this.ivWrappers[n];
        --this.ivSize;
        for (int i = n; i < this.ivSize; ++i) {
            this.ivWrappers[i] = this.ivWrappers[i + 1];
        }
        this.ivWrappers[this.ivSize] = null;
        eJSWrapperCommon.pinned = -1;
        return eJSWrapperCommon;
    }

    private int findIndexByKey(Object object) {
        for (int i = this.ivSize - 1; i >= 0; --i) {
            EJSWrapperCommon eJSWrapperCommon = this.ivWrappers[i];
            if (!eJSWrapperCommon.key.equals(object)) continue;
            return i;
        }
        return -1;
    }

    private void expandCapacity() {
        int n = this.ivSize + 3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "expandCapacity: " + this.ivSize + " -> " + n);
        }
        EJSWrapperCommon[] eJSWrapperCommonArray = new EJSWrapperCommon[n];
        for (int i = 0; i < this.ivSize; ++i) {
            eJSWrapperCommonArray[i] = this.ivWrappers[i];
        }
        this.ivWrappers = eJSWrapperCommonArray;
    }
}

