/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.tran;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.tran.TxSync;
import com.ibm.ws.LocalTransaction.ContainerSynchronization;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class SyncDriver
implements Synchronization,
ContainerSynchronization {
    private static final TraceComponent tc = Tr.register(SyncDriver.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.tran.SyncDriver";
    private ArrayList txSyncParticipants;
    private ArrayList synchronizationParticipants;
    private Object coord;

    SyncDriver(UOWCoordinator uOWCoordinator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = uOWCoordinator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(UOWCoordinator uOWCoordinator, TxSync txSync) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> UOWCoordinator, TxSync");
        }
        this.coord = uOWCoordinator;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(txSync);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(Transaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = transaction;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(Transaction transaction, TxSync txSync) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> Transaction, TxSync");
        }
        this.coord = transaction;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(txSync);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(LocalTransactionCoordinator localTransactionCoordinator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = localTransactionCoordinator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(LocalTransactionCoordinator localTransactionCoordinator, TxSync txSync) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> LocalTransactionCoordinator, TxSync ");
        }
        this.coord = localTransactionCoordinator;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(txSync);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(TxSync txSync) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addParticipant (" + txSync + ")");
        }
        if (this.txSyncParticipants == null) {
            this.txSyncParticipants = new ArrayList(10);
        }
        ArrayList arrayList = this.txSyncParticipants;
        synchronized (arrayList) {
            this.txSyncParticipants.add(txSync);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(Synchronization synchronization) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addParticipant (" + synchronization + ")");
        }
        if (this.synchronizationParticipants == null) {
            this.synchronizationParticipants = new ArrayList(10);
        }
        ArrayList arrayList = this.synchronizationParticipants;
        synchronized (arrayList) {
            this.synchronizationParticipants.add(synchronization);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addParticipant");
        }
    }

    public void beforeCompletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        try {
            int n;
            int n2;
            if (this.synchronizationParticipants != null) {
                n2 = this.synchronizationParticipants.size();
                for (n = 0; n < n2; ++n) {
                    ((Synchronization)this.synchronizationParticipants.get(n)).beforeCompletion();
                }
            }
            if (this.txSyncParticipants != null) {
                n2 = this.txSyncParticipants.size();
                for (n = 0; n < n2; ++n) {
                    ((TxSync)this.txSyncParticipants.get(n)).beforeCompletion();
                }
                for (n = 0; n < n2; ++n) {
                    ((TxSync)this.txSyncParticipants.get(n)).beforeCompletionFinally();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ejs.util.tran.SyncDriver.beforeCompletion", "155", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "beforeCompletion failed: ", exception);
            }
            LocalTransactionCoordinator localTransactionCoordinator = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
            RuntimeException runtimeException = new RuntimeException(exception);
            try {
                if (localTransactionCoordinator != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Marking local tx for rollback");
                    }
                    localTransactionCoordinator.setRollbackOnly();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Marking global tx for rollback");
                    }
                    Transaction transaction = (Transaction)this.coord;
                    transaction.setRollbackOnly();
                }
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ejs.util.tran.SyncDriver.beforeCompletion", "176", this);
                Tr.warning(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{exception2, runtimeException.toString()});
            }
            throw runtimeException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    public void afterCompletion(int n) {
        int n2;
        int n3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion (" + this.print(n) + ")");
        }
        boolean bl = false;
        if (n == 3) {
            bl = true;
        }
        if (this.synchronizationParticipants != null) {
            n3 = this.synchronizationParticipants.size();
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    ((Synchronization)this.synchronizationParticipants.get(n2)).afterCompletion(n);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.util.tran.SyncDriver.afterCompletion", "208", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "afterCompletion failed", new Object[]{tc, throwable});
                }
            }
        }
        if (this.txSyncParticipants != null) {
            n3 = this.txSyncParticipants.size();
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    ((TxSync)this.txSyncParticipants.get(n2)).afterCompletion(bl, this.coord);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ejs.util.tran.SyncDriver.afterCompletion", "219", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "afterCompletion failed", new Object[]{tc, throwable});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public void setCompleting(boolean bl) {
        int n;
        int n2;
        if (this.synchronizationParticipants != null) {
            n2 = this.synchronizationParticipants.size();
            for (n = 0; n < n2; ++n) {
                if (!(this.synchronizationParticipants.get(n) instanceof ContainerSynchronization)) continue;
                ((ContainerSynchronization)this.synchronizationParticipants.get(n)).setCompleting(bl);
            }
        }
        if (this.txSyncParticipants != null) {
            n2 = this.txSyncParticipants.size();
            for (n = 0; n < n2; ++n) {
                if (!(this.txSyncParticipants.get(n) instanceof ContainerSynchronization)) continue;
                ((ContainerSynchronization)this.txSyncParticipants.get(n)).setCompleting(bl);
            }
        }
    }

    private String print(int n) {
        if (n == 5) {
            return "StatusUnknown";
        }
        if (n == 1) {
            return "StatusMarkedRollback";
        }
        if (n == 0) {
            return "StatusActive";
        }
        if (n == 2) {
            return "StatusPrepared";
        }
        if (n == 6) {
            return "StatusNoTransaction";
        }
        if (n == 7) {
            return "StatusPreparing";
        }
        if (n == 8) {
            return "StatusCommitting";
        }
        if (n == 3) {
            return "StatusCommitted";
        }
        if (n == 9) {
            return "StatusRollingBack";
        }
        if (n == 4) {
            return "StatusRolledBack";
        }
        return "ERROR! UNKNOWN STATUS";
    }
}

