/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AnalysisEngineUtilities {
    public static final String analysisEngineUtilitiesCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String LINESEPARATOR = AnalysisEngineUtilities.getSystemProperty("line.separator");

    private static String getSystemProperty(String string) {
        final String string2 = string;
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NullPointerException, IllegalArgumentException {
                    return System.getProperty(string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public static String getAttributeValue(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string.trim()).getNodeValue().trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getDescendentNodeText(Node node, String string) {
        Node[] nodeArray = AnalysisEngineUtilities.getDescendentNodes(node, string);
        int n = 0;
        while (n < nodeArray.length) {
            Node node2 = nodeArray[n];
            if (node2.hasChildNodes()) {
                NodeList nodeList = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    Node node3 = nodeList.item(n2);
                    if (node3.getNodeType() == 3) {
                        String string2 = node3.getNodeValue();
                        if (string2 != null) {
                            return string2.trim();
                        }
                        return null;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public static Node[] getDescendentNodes(Node node, String string) {
        String string2;
        Vector<Node> vector = new Vector<Node>();
        if (string != null && node != null && node.hasChildNodes() && !(string2 = string.trim()).equals("")) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeName().trim().equals(string2)) {
                    vector.addElement(node2);
                }
                vector.addAll(Arrays.asList(AnalysisEngineUtilities.getDescendentNodes(node2, string)));
                ++n;
            }
        }
        return vector.toArray(new Node[vector.size()]);
    }

    public static boolean equals(Node node, Node node2) {
        return AnalysisEngineUtilities.equals(node, node2, new String[0]);
    }

    public static boolean equals(Node node, Node node2, String[] stringArray) {
        int n;
        Node node3;
        int n2;
        boolean[] blArray;
        Object object;
        Object object2;
        if (node == null && node2 == null) {
            return true;
        }
        if (node == null || node2 == null) {
            return false;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!node.getNodeName().trim().equals(node2.getNodeName().trim())) {
            return false;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && node.getNodeName().trim().equals(stringArray[n3].trim())) {
                return true;
            }
            ++n3;
        }
        String string = node.getNodeValue();
        String string2 = node2.getNodeValue();
        if (string != null && string2 != null ? !string.trim().equals(string2.trim()) : string != null || string2 != null) {
            return false;
        }
        if (node.hasAttributes() && node2.hasAttributes()) {
            object2 = node.getAttributes();
            object = node2.getAttributes();
            if (object2.getLength() != object.getLength()) {
                return false;
            }
            blArray = new boolean[object.getLength()];
            n2 = 0;
            while (n2 < object2.getLength()) {
                node3 = object2.item(n2);
                n = 0;
                while (n < object.getLength()) {
                    if (!blArray[n] && AnalysisEngineUtilities.equals(node3, object.item(n), stringArray)) {
                        blArray[n] = true;
                        break;
                    }
                    ++n;
                }
                if (n == object.getLength()) {
                    return false;
                }
                ++n2;
            }
        } else if (node.hasAttributes() || node2.hasAttributes()) {
            return false;
        }
        if (node.hasChildNodes() && node2.hasChildNodes()) {
            object2 = node.getChildNodes();
            object = node2.getChildNodes();
            if (object2.getLength() != object.getLength()) {
                return false;
            }
            blArray = new boolean[object.getLength()];
            n2 = 0;
            while (n2 < object2.getLength()) {
                node3 = object2.item(n2);
                n = 0;
                while (n < object.getLength()) {
                    if (!blArray[n] && AnalysisEngineUtilities.equals(node3, object.item(n), stringArray)) {
                        blArray[n] = true;
                        break;
                    }
                    ++n;
                }
                if (n == object.getLength()) {
                    return false;
                }
                ++n2;
            }
        } else if (node.hasChildNodes() || node2.hasChildNodes()) {
            return false;
        }
        return true;
    }

    public static Node getElementById(Document document, String string, String string2, String string3) {
        try {
            NodeList nodeList = document.getElementsByTagName(string);
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (AnalysisEngineUtilities.getAttributeValue(node, string2).equals(string3)) {
                    return node;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

